# NAME

Data::Object::Role::Stashable

# ABSTRACT

Stashable Role for Perl 5

# SYNOPSIS

    package Example;

    use Moo;

    with 'Data::Object::Role::Stashable';

    package main;

    my $example = Example->new;

# DESCRIPTION

This package provides methods for stashing data within the object.

# METHODS

This package implements the following methods:

## stash

    stash(Maybe[Str] $key, Maybe[Any] $value) : Any

The stash method is used to fetch and stash named values associated with the
object. Calling this method without arguments returns all values.

- stash example #1

        # given: synopsis

        my $result = $example->stash;

        [$result, $example]

- stash example #2

        # given: synopsis

        my $result = $example->stash(time => time);

        [$result, $example]

- stash example #3

        # given: synopsis

        my $result = $example->stash('time');

        [$result, $example]

# AUTHOR

Al Newkirk, `awncorp@cpan.org`

# LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the ["license
file"](https://github.com/iamalnewkirk/data-object-role-stashable/blob/master/LICENSE).

# PROJECT

[Wiki](https://github.com/iamalnewkirk/data-object-role-stashable/wiki)

[Project](https://github.com/iamalnewkirk/data-object-role-stashable)

[Initiatives](https://github.com/iamalnewkirk/data-object-role-stashable/projects)

[Milestones](https://github.com/iamalnewkirk/data-object-role-stashable/milestones)

[Contributing](https://github.com/iamalnewkirk/data-object-role-stashable/blob/master/CONTRIBUTE.md)

[Issues](https://github.com/iamalnewkirk/data-object-role-stashable/issues)
