#########################################################################
#
# Serz Minus (Sergey Lepenkov), <abalama@cpan.org>
#
# Copyright (C) 1998-2020 D&D Corporation. All Rights Reserved
#
# This is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.
#
# $Id: 24-digest.t 286 2020-08-29 06:41:11Z minus $
#
#########################################################################
use strict;
use warnings;
use Test::More tests => 3;

use CTK::Digest::M11R;
use CTK::Digest::FNV32a;

# Test M11R class
{
    my $m11r = CTK::Digest::M11R->new();
    $m11r->add("123456789"); # 5
    #$empty->addfile("t.txt");

    #print ">", $m11r->digest, "<\n";
    is($m11r->digest, 5, "M11R Check Digit for 123456789 is 5");
}

# Test FNV32a class
{
    my $fnv32a = CTK::Digest::FNV32a->new();
    $fnv32a->add("123456789");
    is($fnv32a->digest, 0xbb86b11c, "FNV32a for 123456789 is 3146166556");
    is($fnv32a->hexdigest, 'bb86b11c', "FNV32a (hex) for 123456789 is 0xbb86b11c");
}


1;

__END__
