# This Makefile.PL for Task-Weaken was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.39.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.006;
use ExtUtils::MakeMaker;

# Dear Distribution Packagers
#
# Hi there!
#
# Before we begin, I'm really really sorry for what you are about to
# encounter a bit lower down in this file.
#
# Trust me, I didn't want to WRITE it just as much as you are probably
# not going to want to READ it and try to work out how the hell it
# applies to your Linux/etc distribution.
#
# So lets try to shortcut the whole confusion thing and save us both
# some time.
#
# Some distributions have this problem where the Scalar::Util version
# in the Perl core gets built WITHOUT a C compiler available. When this happens,
# most of the functions in Scalar::Util that need the compiler are replaced
# with a Pure-Perl version that works identically...
#
# ...except for two function relating to "weak references", a reference
# that is intentionally not counted for the purposes of garbage collection.
#
# It's used to implement certain specific data structures, like circular
# references and parent links in tree structures, in a way that can safely
# be garbage collected and won't leak.
#
# So what you really should check FIRST, is that the Perl build in your
# distribution has the Scalar::Util::weaken function defined.
#
# If not, then your Perl build is probably broken, and your solution
# ultimately needs to be applied to Perl itself. Then the whole problem
# goes away.
#
# If Scalar::Util::weaken is defined in your core Perl distribution, then
# none of the edge cases described below apply, and everything will be
# just rosy.
#
# Best Regards
#
# Adam K

my %WriteMakefileArgs = (
  "ABSTRACT" => "Ensure that a platform has weaken support",
  "AUTHOR" => "Adam Kennedy <adamk\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Config" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0
  },
  "DISTNAME" => "Task-Weaken",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME" => "Task::Weaken",
  "PREREQ_PM" => {
    "strict" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Spec::Functions" => 0,
    "Scalar::Util" => 0,
    "Test::More" => 0,
    "warnings" => 0
  },
  "VERSION" => "1.05",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "File::Spec::Functions" => 0,
  "Scalar::Util" => 0,
  "Test::More" => 0,
  "strict" => 0,
  "warnings" => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.034
check_scalar_util();

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub requires;	# forward declaration

sub check_scalar_util {
	# Try to load Scalar::Util
	eval {
		require Scalar::Util;
	};
	if ( $@ ) {
		# Scalar::Util not installed (really old Perl?)
		requires 'Scalar::Util' => '1.14';
		return;
	}

	# Is installed
	my $module_version = $Scalar::Util::VERSION;
	my $module_weaken  = !! defined &Scalar::Util::weaken;
	if ( $module_weaken ) {
		# Already have weaken support.
		# Make sure it is a new enough version
		requires 'Scalar::Util' => '1.14';
		return;
	}

	# Does NOT have weaken, so either a very old
	# Scalar::Util, or a broken one.
	if ( $module_version <= 1.01 ) {
		# Very old Scalar::Util, upgrade it
		requires 'Scalar::Util' => '1.14';
		return;
	}

	my $latest_scalar_util = 1.21; #does not support 5.5, but weak references were introduced in 5.6
	$latest_scalar_util = 1.19 if $] < 5.006;
	# will not work of course - CPAN automatically installs only latest version
        
	# Broken Scalar::Util
	# That is, it does NOT contain the weaken function
	# which means it was built without a compiler.
	unless ( can_cc() ) {
		# The user does not have a compiler
		# There is currently no way to resolve
		# this situation, but we should probably
		# try to upgrade Scalar::Util anyway, just
		# in case the author is able to come up
		# with a solution at some point in the
		# future.
		message1();
		requires 'List::Util::XS' => $latest_scalar_util;
		return;
	}

	# User should be capable of installing an
	# upgraded version.
	# Can we be certain they WILL do the upgrade?
	if ( $module_version < $latest_scalar_util ) {
		# We should be able to do a straight
		# forward upgrade of the module
		requires 'List::Util::XS' => $latest_scalar_util;
		return;
	}

	# They ALREADY have the newest version... and it is broken.
	# Very little we can do in this case, other than issue a
	# message to the user, and then add a high dependency in the
	# vague hope it does something.
	message2();
	requires 'List::Util::XS' => $latest_scalar_util;
	return;
}
sub message1 {
	print "\n\n\n";
	print "    ERROR:\n\n";
	print "    A CPAN module critically requires a function\n";
	print "    (Scalar::Util::weaken) that can only be provided by\n";
	print "    upgrading your Scalar::Util module to a new version,\n";
	print "    which will need a C compiler in order to install.\n\n";
	print "    Unfortunately, I can't seem to locate a C compiler on this\n";
	print "    computer.\n\n";
	print "    I'm going to try to continue anyway, but the most likely result\n";
	print "    is going to be an extremely noisy series of testing errors.\n\n";
	print "    If this happens, you will need to install a C compiler\n";
	print "    (such as gcc) and then try to install whatever it is you are\n";
	print "    installing again.\n\n";
	print "    During the second attempt, I should be able to find the C\n";
	print "    compiler and be able to build the needed function without\n";
	print "    having to bother you again.\n\n";
	print "    I'm going to wait for about a minute now in the hope you read\n";
	print "    this\n\n\n";
	sleep( 50 );
}

sub message2 {
	print "\n\n\n";
	print "    ERROR:\n\n";
	print "    A CPAN module critically requires a function\n";
	print "    (Scalar::Util::weaken) that should exist in your\n";
	print "    Scalar::Util module but doesn't.\n\n";
	print "    This probably happened because you are using a Perl\n";
	print "    provided by a binary package from a vendor, and this\n";
	print "    vendor has packaged Perl incorrectly.\n\n";
	print "    I have checked for a couple of potential workarounds\n";
	print "    but none of them appear to be usable in your\n";
	print "    situation.\n\n";
	print "    I will try a last-ditch option anyway, but the most\n";
	print "    likely result is a number of noisily failing tests\n\n";
	print "    If this happens, you will need to contact technical\n";
	print "    support for your vendor and report the broken Perl,\n";
	print "    so that they can repair it.\n\n";
	print "    Please refer them to the documentation for the\n";
	print "    'Task::Weaken' CPAN module, which explains the problem\n";
	print "    and how they can fix it.\n\n";
	print "    I'm going to wait for about a minute now so you have time\n";
	print "    to read this message\n\n\n";
	sleep( 50 );
}

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.034
sub _add_prereq {
  my ($mm_key, $module, $version_or_range) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
      and $WriteMakefileArgs{$mm_key}{$module} ne '0'
      and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
        and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub can_cc {
  if ($^O eq 'VMS') {
    require ExtUtils::CBuilder;
    my $builder = ExtUtils::CBuilder->new(quiet => 1);
    return $builder->have_compiler;
  }

  my @chunks = split(/ /, $Config::Config{cc});

  # $Config{cc} may contain args; try to find out the program part
  while (@chunks) {
    return can_run("@chunks") || (pop(@chunks), next);
  }

  return 0;
}

sub can_run {
  my ($cmd) = @_;

  return $cmd if -x $cmd;
  if (my $found_cmd = MM->maybe_command($cmd)) {
    return $found_cmd;
  }

  for my $dir ((split /$Config::Config{path_sep}/, $ENV{PATH}), '.') {
    next if $dir eq '';
    require File::Spec;
    my $abs = File::Spec->catfile($dir, $cmd);
    return $abs if (-x $abs or $abs = MM->maybe_command($abs));
  }

  return;
}

# Fix Cygwin bug on maybe_command(), fixed in EUMM 6.69_04
BEGIN { if ( $^O eq 'cygwin' ) {
  require ExtUtils::MM_Cygwin;
  require ExtUtils::MM_Win32;
  {
    no warnings 'redefine';
    package ExtUtils::MM_Cygwin;
    sub maybe_command {
      my ($self, $file) = @_;
      my $cygpath = Cygwin::posix_to_win_path('/', 1);
      my $filepath = Cygwin::posix_to_win_path($file, 1);
      return (substr($filepath,0,length($cygpath)) eq $cygpath)
        ? $self->SUPER::maybe_command($file) # Unix
        : ExtUtils::MM_Win32->maybe_command($file); # Win32
    }
  }
} }

sub requires { goto &runtime_requires }

sub runtime_requires {
  my ($module, $version_or_range) = @_;
  _add_prereq(PREREQ_PM => $module, $version_or_range);
}
