use strict;
use warnings;

package Task::Badge::Depot;

our $VERSION = '0.0101'; # VERSION
# ABSTRACT: All Badge::Depot badges

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Task::Badge::Depot - All Badge::Depot badges



=begin HTML

<p><img src="https://img.shields.io/badge/perl-5.10.1+-brightgreen.svg" alt="Requires Perl 5.10.1+" /> <a href="https://travis-ci.org/Csson/p5-Task-Badge-Depot"><img src="https://api.travis-ci.org/Csson/p5-Task-Badge-Depot.svg?branch=master" alt="Travis status" /></a> </p>

=end HTML


=begin markdown

![Requires Perl 5.10.1+](https://img.shields.io/badge/perl-5.10.1+-brightgreen.svg) [![Travis status](https://api.travis-ci.org/Csson/p5-Task-Badge-Depot.svg?branch=master)](https://travis-ci.org/Csson/p5-Task-Badge-Depot) 

=end markdown

=head1 VERSION

Version 0.0101, released 2016-01-19.

=head1 TASK CONTENTS

=head2 Badge::Depot, with badges

=head3 L<Badge::Depot>

=head3 L<Badge::Depot::Plugin::Coverage>

=head3 L<Badge::Depot::Plugin::Gratipay>

=head3 L<Badge::Depot::Plugin::Perl>

=head3 L<Badge::Depot::Plugin::Travis>

=head1 SOURCE

L<https://github.com/Csson/p5-Task-Badge-Depot>

=head1 HOMEPAGE

L<https://metacpan.org/release/Task-Badge-Depot>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
