package WordList::EN::PersonName::PopularBabyName::US::SSA::1970::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyName-US-SSA'; # DIST
our $VERSION = '0.003'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("shortest_word_len",2,"num_words_contains_unicode",0,"num_words_contains_nonword_chars",0,"num_words_contain_unicode",0,"avg_word_len",6.006,"num_words",1000,"num_words_contain_whitespace",0,"num_words_contains_whitespace",0,"longest_word_len",11,"num_words_contain_nonword_chars",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1970 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyName::US::SSA::1970::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1970 (from Social Security Administration)

=head1 VERSION

This document describes version 0.003 of WordList::EN::PersonName::PopularBabyName::US::SSA::1970::FemaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyName-US-SSA), released on 2020-05-22.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyName::US::SSA::1970::FemaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyName::US::SSA::1970::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 6.006 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyName-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Jennifer
Lisa
Kimberly
Michelle
Amy
Angela
Melissa
Tammy
Mary
Tracy
Julie
Karen
Laura
Christine
Susan
Dawn
Stephanie
Elizabeth
Heather
Kelly
Tina
Shannon
Lori
Patricia
Cynthia
Pamela
Sandra
Wendy
Rebecca
Nicole
Michele
Donna
Deborah
Teresa
Christina
Denise
Sharon
Linda
Maria
Brenda
Barbara
Stacy
Andrea
Cheryl
Kathleen
Rhonda
Debra
Stacey
Tonya
Nancy
Robin
Jill
Theresa
Dana
Tracey
Monica
Paula
Rachel
Catherine
Sherry
Gina
Ann
Kristin
Leslie
Sarah
Jacqueline
Katherine
Renee
Tara
Diane
Carol
Cindy
Carrie
Holly
Sheila
Tanya
Kathy
Kim
Tamara
Margaret
Heidi
Kristen
April
Carolyn
Victoria
Regina
Suzanne
Laurie
Diana
Deanna
Melanie
Beth
Melinda
Carla
Jodi
Janet
Valerie
Jessica
Tiffany
Traci
Crystal
Anna
Shelly
Kathryn
Christy
Yolanda
Sabrina
Amanda
Kristine
Veronica
Erin
Anne
Terri
Danielle
Kelli
Colleen
Connie
Alicia
Lynn
Jamie
Julia
Sherri
Kristi
Tricia
Kristina
Sara
Anita
Annette
Erica
Bonnie
Sonya
Wanda
Allison
Cassandra
Vicki
Krista
Cathy
Vanessa
Felicia
Sheri
Yvonne
Natalie
Martha
Shelley
Janice
Virginia
Tracie
Debbie
Samantha
Beverly
Katrina
Carmen
Jody
Marie
Darlene
Toni
Penny
Kellie
Jean
Monique
Becky
Yvette
Gloria
Joyce
Stacie
Charlotte
Charlene
Shawn
Betty
Joanne
Erika
Trina
Emily
Peggy
Tammie
Kerry
Judy
Ruth
Bridget
Dorothy
Kristie
Maureen
Rose
Joy
Kimberley
Sonia
Alison
Ellen
Sylvia
Jeanette
Helen
Leah
Judith
Kari
Vickie
Karla
Kristy
Shirley
Frances
Alice
Belinda
Jane
Rita
Jeanne
Joann
Tami
Dina
Dena
Kara
Shawna
Robyn
Kelley
Leigh
Sheryl
Raquel
Evelyn
Elaine
Norma
Tonia
Candace
Gail
Rosa
Kerri
Jenny
Marsha
Ginger
Aimee
Roberta
Caroline
Jackie
Loretta
Deana
Ronda
Meredith
Lara
Joanna
Christie
Lauren
Sonja
Audrey
Joan
Angie
Amber
Marcia
Eileen
Megan
Juanita
Marilyn
Sally
Sandy
Gretchen
Claudia
Bobbie
Gwendolyn
Christa
Lora
Shari
Molly
Shelia
Cheri
Rochelle
Melody
Lorraine
Lynette
Alisa
Misty
Kendra
Staci
Terry
Angel
Billie
Jo
Marla
Teri
Irene
Stefanie
Jodie
Karin
Tabitha
Ana
Janine
Candy
Nichole
Kirsten
Eva
Jana
Candice
Antoinette
Roxanne
Adrienne
Cherie
Dianna
Shana
Rachelle
Hope
Dianne
Leticia
Lee
Darla
Jacquelyn
Angelique
Latonya
Trisha
Priscilla
Ashley
Sherrie
Lydia
Angelia
Patrice
Ramona
Marisol
Glenda
Rachael
Christi
Doris
Marlene
Audra
Tammi
Lynda
Wendi
Dionne
Lorie
Jeannie
Vicky
Nina
Camille
Paulette
Constance
Keri
Jeanine
Rosemary
Bobbi
Desiree
Courtney
Lillian
Lana
Shauna
Vivian
Grace
Bernadette
Lesley
Phyllis
Paige
Brooke
Shanna
Marcy
Jenifer
Esther
Arlene
Natasha
Cara
Jeannette
Doreen
Mindy
Bethany
Katie
Chandra
Ruby
Elisa
Daphne
Darcy
Leanne
Marianne
Brandi
Josephine
Nora
Sue
Lynne
Nikki
Miriam
Iris
Marci
Annmarie
Serena
Cathleen
Marjorie
Mona
Pauline
Bridgette
Alexandra
Lucinda
Laurel
Cecilia
Ericka
Brandy
Jeannine
Janelle
Anissa
Francine
Edith
Jennie
Deanne
Nadine
Celeste
Patty
Tasha
Deena
Lea
Marlo
Angelica
Tabatha
Leann
Sophia
Kimberlee
Cristina
June
Dolores
Lorrie
Susanne
Melisa
Naomi
Faith
Jami
Rene
Ladonna
Louise
Patti
Gayle
Dora
Alma
Angelina
Emma
Tamra
Deirdre
Ingrid
Geraldine
Lois
Lorena
Marcie
Marcella
Tania
Shonda
Maryann
Elena
Georgia
Lena
Deidre
Lucy
Sondra
Margarita
Annie
Jan
Suzette
Lashawn
Amelia
Betsy
Maribel
Keisha
Irma
Mia
Rosemarie
Guadalupe
Bridgett
Mildred
Kay
Janie
Jeri
Karyn
Adriana
Chris
Michael
Myra
Malinda
Tonja
Lynnette
Edna
Alyssa
Claudine
Delores
Kris
Janette
Marnie
Cari
Latanya
Elisabeth
Luz
Noelle
Beatrice
Shellie
Carole
Alisha
Isabel
Julianne
Jocelyn
Johanna
Valarie
Amie
Carey
Justine
Liza
Katharine
Danette
Tamera
Deann
Terrie
Gena
Rena
Shelby
Marisa
Tisha
Colette
Debora
Lauri
Gabrielle
Juliet
Margie
Olga
Janel
Renae
Ida
Jerri
Jolene
Marion
Tia
Marian
Meghan
Kerrie
Bernice
Rebekah
Rosalind
Bertha
Eleanor
Vera
Gladys
Blanca
Abigail
Caryn
Allyson
Alissa
Celia
Clara
Susie
Hilary
Alexis
Gwen
Madeline
James
Trudy
Olivia
Whitney
Lawanda
Lesa
Stella
Greta
Joni
Charity
Claire
Nanette
Corinne
Krystal
Eugenia
Jessie
Karrie
Kenya
Ursula
Elise
Randi
Florence
Cassie
Delia
Pam
Robert
Marta
Ella
Bonita
Patsy
Clarissa
Shelli
Maritza
Hollie
Penelope
Dee
Felecia
Sandi
Cecelia
Daisy
Genevieve
Tamela
Tyra
Antonia
Stacia
Therese
Latonia
Hilda
Jeanna
Joelle
Leeann
Elsa
Lourdes
Silvia
Geneva
Josette
Polly
Selena
Kate
Larissa
Demetria
Marina
Della
Tamatha
John
Juli
Misti
David
Dayna
Margo
Benita
Mara
Leona
Shanon
Corina
Shannan
Vonda
Buffy
Rae
Annemarie
Dara
Catrina
Terra
Michell
Janell
Shanda
Anjanette
Thelma
Deidra
Janeen
Maura
Jeanie
Missy
Malissa
Marissa
Maxine
Valencia
Georgina
Janna
Tamika
Elissa
Hillary
Simone
Aretha
Denice
Mitzi
Richelle
Saundra
Charmaine
Rosie
Sharron
Ivy
Coleen
Lucia
Alana
Casandra
Chanda
Tawnya
Candi
Gabriela
Letitia
Vikki
Susana
Latrice
Casey
Janis
Eve
Holli
Robbin
Ada
Anastasia
Cristy
Lenora
Martina
Aileen
Rosalinda
Rosalyn
Lucille
Trena
Danita
Cora
Darci
Hazel
Lorna
Leanna
Mandy
Chrystal
Janene
Jeana
Tawana
Alyson
Danna
Ethel
Gayla
Graciela
Chelsea
Ivette
Lorri
Mari
Mechelle
Ami
Corinna
Robbie
Lisette
Johnna
Kisha
Latricia
Esmeralda
Marni
Jaime
Windy
Christopher
Lissette
Lolita
Evette
Miranda
Nicolle
Shiela
Beatriz
Susanna
Adrian
Carolina
Charla
Lashonda
Latasha
Tana
Sheree
Renita
Sharlene
Antionette
Nichelle
Cindi
Faye
William
Alecia
Darcie
Lillie
Mercedes
Wilma
Autumn
Helena
Athena
Barbra
Noel
Pamala
Latisha
Tiffani
Claudette
Joey
Kandi
Kathie
Cathryn
Karie
Kristal
Sharla
Adrianne
Christal
Christian
Mollie
Verna
Dawna
Angeline
Roxann
India
Racquel
Eunice
Mellissa
Tera
Brigitte
Jayne
Roslyn
Venus
Marguerite
Tressa
Chantel
Rosanna
Tori
Johnnie
Charisse
Geri
Teressa
Cori
Kathrine
Roseann
Aida
Juliette
Shonna
Velma
Rosalie
Tessa
Ernestine
Yolonda
Jolie
Juana
Lucretia
Marybeth
Noreen
Ava
Carmela
Shani
Valeria
Carin
Georgette
Juliana
Tresa
Caren
Mayra
Danelle
Dori
Hannah
Lanette
Maggie
Starla
Abby
Andria
Kathi
Dale
Delilah
Josie
Kecia
Lola
Maryellen
Harriet
Loriann
Luann
Adriane
Angelita
Toya
Willie
Carissa
Francesca
Frankie
Gia
Maricela
Katy
Aurora
Jada
Kandy
Milagros
Noemi
Patrica
Dedra
Araceli
Laverne
Dione
Pearl
Roxanna
Bessie
Dixie
Nellie
Richard
Shona
Elsie
Lou
Myrna
Kayla
Magdalena
Mattie
Carie
Cherry
Collette
Eliza
Milissa
Dominique
Karri
Lenore
Cary
Corrine
Davina
Juliann
Linette
Consuelo
Kirstin
Camilla
Jonna
Lorene
Tangela
Tanja
Valorie
Elvira
Monika
Rosetta
Dona
Jacquline
Karina
Rosanne
Viola
Althea
Carlene
Estella
Lavonne
Marisela
Selina
Charles
Stefani
Brian
Carri
Eric
Bobby
Cherise
Jayme
Kimberlie
Lorinda
Machelle
Treva
Twila
Coretta
Kasey
Sharonda
Tena
Freda
Kesha
Tawanda
Kimberli
Melonie
Tisa
Anthony
Maya
Stephenie
Gerri
Rolanda
Sebrina
Timothy
Alberta
Brigette
Deloris
Jeffrey
Jena
Violet
Angella
Raina
Tiffanie
Francis
Inez
Joseph
Judi
Mark
Rona
Shaun
Trista
Christen
Crista
Flora
Kristan
Carmella
Christin
Diann
Helene
Kyra
Mindi
Sherie
Suzanna
Alexandria
Josefina
Susannah
Tawanna
Lani
Leisa
Marti
Niki
Serina
Shay
Tamiko
Thomas
Andra
Cristi
Glenna
Lela
Zoe
Kami
Melodie
Rosario
Shawnda
Tosha
Zandra
Leila
Petra
Christel
Deedee
Dorothea
Kevin
Tanisha
Tracee
Delisa
Dyan
Gale
Lilia
Chantelle
Elisha
Michaela
Minerva
Steven
Antonette
Daria
Kimberely
Lily
Marlena
Minnie
Stephany
Treena
Cammie
Gillian
Ginny
Gracie
