package JobAd::Model;
use strict; use warnings;

use base 'DBIx::Class::Schema';

use JobAd::GENModel;

sub get_db_options {
    return { AutoCommit => 1 };
}

1;

=head1 NAME

JobAd::Model - schema class for JobAd

=head1 SYNOPSIS

In your base module:

    use JobAd::Model;
    sub schema_base_class { return 'JobAd::Model'; }
    use Gantry::Plugins::DBIxClassConn qw( get_schema );
    use JobAd::Model::job qw( $JOB );
    use JobAd::Model::skill qw( $SKILL );
    use JobAd::Model::position qw( $POSITION );
    use JobAd::Model::job_skill qw( $JOB_SKILL );
    use JobAd::Model::auth_users qw( $AUTH_USERS );
    use JobAd::Model::auth_groups qw( $AUTH_GROUPS );
    use JobAd::Model::auth_group_members qw( $AUTH_GROUP_MEMBERS );
    use JobAd::Model::auth_pages qw( $AUTH_PAGES );

=head1 DESCRIPTION

This module was generated by Bigtop.  But, feel free to edit it.  You
might even want to update these docs.

=over 4

=item get_db_options

The generated version sets AutoCommit to 1, this assumes that you will
do all transaction work via the DBIx::Class API.

=back

=head1 DEPENDENCIES

    Gantry::Utils::DBIxClass
    JobAd::GENModel

=head1 AUTHOR

Phil Crow, E<lt>pcrow@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
