#!/bin/sh

# Fake the system time


dat="$1"
static=0


if [ "$dat" = "-s" -o "$dat" = "--static" ] ; then
	static=1
	shift
	dat="$1"
fi
if [ "$dat" = "-v" -o "$dat" = "--version" ] ; then
	echo "$0: Version @VERSION@"
	echo ""
	echo "For usage information, use '$0 --help'."
	exit 0
fi
if [ -z "$dat" -o "$dat" = "-h" -o "$dat" = "-?" -o "$dat" = "--help" ] ; then
	echo "Usage: $0 [-s|--static] date program args..."
	echo ""
	echo "Run 'program' with 'args'."
	echo "The program will believe that the current time is 'date'."
	if [ -z "$dat" ] ; then exit 1; else exit 0; fi
fi

shift

# Assume that 'date' already printed an error message
sec1=$(date -d "$dat" '+%s')
if [ $? -ne 0 ] ; then exit 1 ; fi

sec2=$(expr $(date '+%s') - $sec1)
if [ $? -ne 0 ] ; then exit 1 ; fi

export LD_PRELOAD="${LD_PRELOAD}${LD_PRELOAD:+:}/usr/lib/datefudge/datefudge.so"
if [ "$static" = "1" ]; then
	export DATEFUDGE=$sec1
	export DATEFUDGE_DOSTATIC="1"
else
	export DATEFUDGE=$sec2
	unset  DATEFUDGE_DOSTATIC
fi

exec "$@"
