/*
 * OWL (OpenedHand Widget Library) Colour Palette.
 *
 * Author: Rob Bradford  <rob@openedhand.com>
 *
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "owlcolourpalette.h"
#include "owlcolourswatch.h"

#include <gtk/gtk.h>

G_DEFINE_TYPE (OwlColourPalette, owl_colour_palette, GTK_TYPE_TABLE);

#define COLOUR_PALETTE_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), OWL_TYPE_COLOUR_PALETTE, OwlColourPalettePrivate))

typedef struct _OwlColourPalettePrivate OwlColourPalettePrivate;

struct _OwlColourPalettePrivate
{
};

enum {
        COLOUR_SELECTED,
        LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0 };

static void
owl_colour_palette_get_property (GObject *object, guint property_id,
                              GValue *value, GParamSpec *pspec)
{
  switch (property_id) {
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
  }
}

static void
owl_colour_palette_set_property (GObject *object, guint property_id,
                              const GValue *value, GParamSpec *pspec)
{
  switch (property_id) {
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
  }
}

static void
owl_colour_palette_dispose (GObject *object)
{
  if (G_OBJECT_CLASS (owl_colour_palette_parent_class)->dispose)
    G_OBJECT_CLASS (owl_colour_palette_parent_class)->dispose (object);
}

static void
owl_colour_palette_finalize (GObject *object)
{
  G_OBJECT_CLASS (owl_colour_palette_parent_class)->finalize (object);
}

static void
owl_colour_palette_class_init (OwlColourPaletteClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_class_add_private (klass, sizeof (OwlColourPalettePrivate));

  object_class->get_property = owl_colour_palette_get_property;
  object_class->set_property = owl_colour_palette_set_property;
  object_class->dispose = owl_colour_palette_dispose;
  object_class->finalize = owl_colour_palette_finalize;

  signals[COLOUR_SELECTED] = g_signal_new ("colour-selected",
                  G_OBJECT_CLASS_TYPE (object_class),
                  G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION,
                  G_STRUCT_OFFSET (OwlColourPaletteClass, colour_selected),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__OBJECT,
                  GTK_TYPE_NONE, 1,
                  OWL_TYPE_COLOUR_SWATCH);
}

static void
owl_colour_palette_init (OwlColourPalette *self)
{
}

static void 
button_clicked (GtkButton *widget, gpointer user_data)
{
  GtkWidget *swatch = gtk_bin_get_child (GTK_BIN (widget));
  g_signal_emit (user_data, signals[COLOUR_SELECTED], 0, OWL_COLOUR_SWATCH (swatch));
}

GtkWidget*
owl_colour_palette_new (guint n_rows, guint n_columns)
{
  GtkWidget *widget;
  guint i, j;

  widget = GTK_WIDGET(g_object_new (OWL_TYPE_COLOUR_PALETTE, NULL));

  gtk_table_resize (GTK_TABLE (widget), n_rows, n_columns);

  for (i = 0; i < n_rows; i++)
    {
      for (j = 0; j < n_columns ; j++)
       {
          GtkWidget *button;
          GtkWidget *swatch;
          swatch = owl_colour_swatch_new ();
          button = gtk_button_new ();
          gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
          g_signal_connect (button, "clicked", (GCallback)button_clicked, widget);
          gtk_container_add (GTK_CONTAINER (button), swatch);
          gtk_table_attach_defaults (GTK_TABLE(widget), button, i, i+1, j, j+1);
        }
    }

  return widget;
}

void
owl_colour_palette_set_colours (OwlColourPalette *palette, guint32 colours[], guint nr_colours)
{
  GList *cur_entry;
  guint pos = 0;

  for (cur_entry = GTK_TABLE(palette)->children; cur_entry != NULL; cur_entry = g_list_next (cur_entry))
    {
      GtkTableChild *child;
      GtkWidget *button;
      GtkWidget *swatch;

      if (nr_colours == pos)
        break;

      child = (GtkTableChild *)(cur_entry->data);
      button = child->widget;

      swatch = gtk_bin_get_child (GTK_BIN (button));

      owl_colour_swatch_set_colour (OWL_COLOUR_SWATCH (swatch), colours[pos]);
      pos++;
    }
}
