#!/usr/bin/env python
#
# Written by Henry 'Pi' James and Bram Cohen
# multitracker extensions by John Hoffman
# Modified by Cameron Dale
# see LICENSE.txt for license information
#
# $Id: btsetdebmirrors.py 78 2007-06-02 02:10:56Z camrdale-guest $

"""Change the deb_mirrors info in the metainfo file."""

from sys import argv,exit
from os.path import split
from DebTorrent.bencode import bencode, bdecode

if len(argv) < 3:
    a,b = split(argv[0])
    print ('Usage: ' + b + ' <deb_mirrors> file1.torrent [file2.torrent...]')
    print ('')
    print ('  Where:')
    print ('    deb_mirrors = list of mirror URLs, in the format:')
    print ('           url[|url...] or 0')
    print ('                if the list is a zero, any existing mirrors will be stripped.')
    print ('')
    exit(2) # common exit code for syntax error

seeds = argv[1]
if seeds == '0':
    seedlist = None
else:
    seedlist = seeds.split('|')

for f in argv[2:]:
    h = open(f, 'rb')
    metainfo = bdecode(h.read())
    h.close()
    if metainfo.has_key('deb_mirrors'):
        list = []
        for url in metainfo['deb_mirrors']:
            list += [url,'|']
        del list[-1]
        liststring = ''
        for i in list:
            liststring += i
        print 'old deb_mirrors list for %s: %s' % (f, liststring)
        if not seedlist:
            del metainfo['deb_mirrors']
    if seedlist:
        metainfo['deb_mirrors'] = seedlist

    h = open(f, 'wb')
    h.write(bencode(metainfo))
    h.close()
