#!/bin/sh
# This scripts builds the *.pot-files and copies them to right location and
# that's why Rosetta (the launchpad translation framework) can automatically
# import the translation templates after a commit.

set -e

if ! ./localbuild build; then
	echo "Error building DesktopNova!"
	exit 1
fi

if ! make -C build/ pots; then
	echo "Error building pots!"
	exit 1
fi

exitcode=0
for postfix in "" \
               "-module-gnome" \
               "-module-xfce" \
               "-tray"; do
	template="desktopnova$postfix"
	if ! cp "build/po/$template/$template.pot" "po/$template/$template.pot"; then
		echo "Error copying pot for template \"$i\""
		exitcode=1
	fi
done

exit "$exitcode"