"Utility functions for docstring manipulations."

# Copyright (C) 2010 Anders Logg
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
#
# Modified by Kristian B. Oelgaard, 2010.
# Modified by Marie E. Rognes, 2011.
#
# First added:  2010-08-26
# Last changed: 2011-05-10

import re

def indent(string, num_spaces):
    "Indent given text block given number of spaces"
    return "\n".join(num_spaces*" " + l for l in string.split("\n"))

def add_links(text, classnames, link_type):
    "Add crosslinks for classes"
    for classname in classnames:
        p = re.compile(r"\b_%s_\b" % classname)
        text = p.sub("%s`%s`" % (link_type, classname), text)

    # Escape pointer arguments: replace * by \* after class names
    text = text.replace("`*", "`\*")

    return text

