#!/usr/bin/python
import sys, os
if os.sep + 'dosage' in os.path.abspath(sys.argv[0]):
    sys.path.insert(0, os.path.normpath(os.path.join(os.path.abspath(sys.argv[0]), os.pardir, os.pardir)))

import dosage.modules
from sets import Set as set

'''
Iterates through all the available comic modules, that implement a 'fetchSubmodules'
classmethod and a 'submodules' sequence, to determine what comics have been added or removed.
'''

def reprset(modulename, s):
    if not s:
        return ''
    return ',\n'.join(['  ' + repr(module) for module in s])

def main():
    done = []

    for moduleName in dosage.modules.items(dosage.modules.__path__[0]):
        module = dosage.modules.get(moduleName)
        parentModuleName = moduleName.split('/')[0]
        if parentModuleName not in done and hasattr(module, 'fetchSubmodules') and hasattr(module, 'submodules'):
            done.append(parentModuleName)
            existing = set(module.submodules)
            new = set(module.fetchSubmodules())
            print 'Added to %r:' % (parentModuleName,)
            print reprset(parentModuleName, new - existing)
            print 'Removed from %r:' % (parentModuleName,)
            print reprset(parentModuleName, existing - new)

if __name__ == '__main__':
    main()
