from re import compile
from urllib import basejoin

from dosage.helpers import BasicScraper, constStarter, bounceStarter, indirectStarter
from dosage.util import getQueryParams, fetchUrl


class CandyCartoon(BasicScraper):
    latestUrl = 'http://www.candycartoon.com/'
    imageUrl = 'http://www.candycartoon.com/archives/%s.html'
    imageSearch = compile(r'<img alt="[^"]*" src="(http://www\.candycartoon\.com/archives/[^"]+)"')
    prevSearch = compile(r'<a href="(http://www\.candycartoon\.com/archives/\d{6}\.html)">prev')
    help = 'Index format: nnnnnn'


class CaptainSNES(BasicScraper):
    latestUrl = 'http://captainsnes.com/'
    imageUrl = 'http://captainsnes.com/?date=%s'
    imageSearch = compile(r'<img src="(Archive/.+?)"')
    prevSearch = compile(r'<a href="(\?date=\d+?)"><img border="0" src="images/previous_day.gif"')
    help = 'Index format: yyyymmdd'


class CaribbeanBlue(BasicScraper):
    latestUrl = 'http://www.katbox.net/cblueen/'
    imageUrl = 'http://www.katbox.net/cblueen/index.php?strip_id=%s'
    imageSearch = compile(r'="(.+?strips/.+?)"')
    prevSearch = compile(r'</a>.+?"(index.php.+?)".+?prev')
    help = 'Index format: n (unpadded)'


class Catharsis(BasicScraper):
    latestUrl = 'http://catharsiscomic.com/'
    imageUrl = 'http://catharsiscomic.com/archive.php?strip=%s'
    imageSearch = compile(r'<img src="(strips/.+?)"')
    prevSearch = compile(r'<a href="(.+?)".+"Previous')
    help = 'Index format: yymmdd-<your guess>.html'


class ChasingTheSunset(BasicScraper):
    latestUrl = 'http://www.fantasycomic.com/'
    imageUrl = 'http://www.fantasycomic.com/index.php?p=c%s'
    imageSearch = compile(r'(/cmsimg/.+?)".+?comic-img')
    prevSearch = compile(r'(/index.php\?p=.+?)".+?cn-prev')
    help = 'Index format: n'


class Chisuji(BasicScraper):
    latestUrl = 'http://www.chisuji.com/'
    imageUrl = 'http://www.chisuji.com/index.php?id=%s'
    imageSearch = compile(r'(comics/.+?)"')
    prevSearch = compile(r'/(archive.php\?comicID=.+?)".+?comicnav-prev')
    help = 'Index format: n (unpadded)'


class ChroniclesOfGaras(BasicScraper):
    latestUrl = 'http://www.chroniclesofgaras.com/default.php'
    imageUrl = 'http://www.chroniclesofgaras.com/archive_page.php?id=%s'
    imageSearch = compile(r'<TD ROWSPAN=3 ALIGN="CENTER" VALIGN="CENTER"><img src="(http://www.chroniclesofgaras.com/comics/\d{8}\..+?)"')
    prevSearch = compile(r'<a href="(http://www\.chroniclesofgaras\.com/archive_page\.php\?id=\d+?)"><img src="images/navbutton1_previous')
    help = 'Index format: n (unpadded)'


class ChugworthAcademy(BasicScraper):
    latestUrl = 'http://chugworth.com/'
    imageUrl = 'http://chugworth.com/?strip_id=%s'
    imageSearch = compile(r"<img src=(comics/\d+\..+?) width=\"700\" height=\"350\">")
    prevSearch = compile(r"<a href=\'(\?strip_id=\d+)\'><img src=\'images/previous\.gif\'")
    help = 'Index format: n (unpadded)'


class CombustibleOrange(BasicScraper):
    latestUrl = 'http://www.combustibleorange.com/'
    imageUrl = 'http://www.combustibleorange.com/index.php?current=%s'
    imageSearch = compile(r'<img src="(/images/comics/\d+?\.gif)"')
    prevSearch = compile(r'<a href="(index.php\?current=\d+?)"><img src="images/button_toplast.gif" border="0">')
    help = 'Index format: n (unpadded)'


class Comedity(BasicScraper):
    latestUrl = 'http://www.comedity.com/'
    imageUrl = 'http://www.comedity.com/index.php?strip_id=%s'
    imageSearch = compile(r'<img src="(Comedity_files/.+?)"')
    prevSearch = compile(r'<a href="(/?index.php\?strip_id=\d+?)"> *<img alt=\"Prior Strip')
    help = 'Index format: n (no padding)'


class Comet7(BasicScraper):
    latestUrl = 'http://www.comet7.com/'
    imageUrl = 'http://www.comet7.com/archive_page.php?id=%s'
    imageSearch = compile(r'"(.*?/strips/.*?)"')
    prevSearch = compile(r'"(.*?)".*?previous_stripf')
    help = 'Index format: n (unpadded)'


class Commissioned(BasicScraper):
    latestUrl = 'http://www.commissionedcomic.com/'
    imageUrl = 'http://www.commissionedcomic.com/index.php?strip=%s'
    imageSearch = compile(r'<img src="(strips/.+?)">')
    prevSearch = compile(r'<a href="(index.php\?strip=.+?)".+?arr-prev')
    help = 'Index format: n'


class CoolCatStudio(BasicScraper):
    latestUrl = 'http://www.coolcatstudio.com/'
    imageUrl = 'http://www.coolcatstudio.com/index.php?p=%s'
    imageSearch = compile(r'(/comics/.+?)"')
    prevSearch = compile(r"href='(.+?)'>PREV")
    help = 'Index format: n'


class CourtingDisaster(BasicScraper):
    latestUrl = 'http://www.courting-disaster.com/'
    imageUrl = 'http://www.courting-disaster.com/d/%s'
    imageSearch = compile(r'(/comics/.+?)"')
    prevSearch = compile(r'first_day.gif"></a> <a href="(.+?)"')
    help = 'Index format: yyyymmdd.html'


class CrapIDrewOnMyLunchBreak(BasicScraper):
    latestUrl = 'http://crap.jinwicked.com/'
    imageUrl = 'http://crap.jinwicked.com/imgs/comics/%s'
    imageSearch = compile(r'<img src="(imgs/comics/.+?)"')
    prevSearch = compile(r'<a href=\'(\?comic\=.*?)\'><img src="imgs/oldercrap.jpg"')
    help = 'Index format: yyyymmdd'


class CtrlAltDel(BasicScraper):
    latestUrl = 'http://www.ctrlaltdel-online.com/comic.php'
    imageUrl = 'http://www.ctrlaltdel-online.com/comic.php?d=%s'
    imageSearch = compile(r'<img src="(/comics/\d{8}\..+?)"')
    prevSearch = compile(r'<a href="(/comic.php\?d=\d{8})"><img src="/_common/images/comicnav/back1.jpg"')
    help = 'Index format: yyyymmdd'


def cloneManga(name, shortName, lastStrip=None):
    baseUrl = 'http://manga.clone-army.org/%s.php' % (shortName,)
    imageUrl = baseUrl + '?page=%s'
    if lastStrip is None:
        starter = bounceStarter(baseUrl, compile(r'<a href="([^"]+)"><img src="next\.gif"'))
    else:
        starter = constStarter(imageUrl % (lastStrip,))

    def namer(self, imageUrl, pageUrl):
        return '%03d' % (int(getQueryParams(pageUrl)['page'][0]),)

    return BasicScraper.make(
        'CloneManga/' + name,
        starter=starter,
        imageUrl=imageUrl,
        imageSearch=compile(r'<img src="(http://manga\.clone-army\.org/[^"]+)"'),
        prevSearch=compile(r'<a href="([^"]+)"><img src="previous\.gif"'),
        help='Index format: n',
        namer=namer)


anm = cloneManga('AprilAndMay', 'anm')
kanami = cloneManga('Kanami', 'kanami')
momoka = cloneManga('MomokaCorner', 'momoka')
nana = cloneManga('NanasEverydayLife', 'nana', '78')
pxi = cloneManga('PaperEleven', 'pxi', '311')
t42r = cloneManga('Tomoyo42sRoom', 't42r')
penny = cloneManga('PennyTribute', 'penny')


class CatAndGirl(BasicScraper):
    latestUrl = 'http://catandgirl.com/'
    imageUrl = 'http://catandgirl.com/view.php?loc=%s'
    imageSearch = compile(r'<img src="((?:http://catandgirl.com/)?archive/[^"\n]+)')
    prevSearch = compile(r'<a href="(view.php\?loc=\d+)"><img src="arrow_left.gif"')
    help = 'Index format: n'

    def namer(cls, imageUrl, pageUrl):
        filename = imageUrl.split('/')[-1].split('.')[0]
        assert filename.startswith('cg')
        index = int(filename[2:6])
        return '%03d-%s' % (index, filename[6:])


def comicsDotCom(name, section):
    baseUrl = 'http://www.comics.com/%s/%s/archive/' % (section, name)

    def namer(cls, imageUrl, pageUrl):
        htmlname = pageUrl.split('/')[-1]
        filename = htmlname.split('.')[0]
        return filename

    return BasicScraper.make(
        'ComicsDotCom/' + name,
        starter=indirectStarter(baseUrl, compile(r'<A HREF="(/[\w/]+?/archive/\w+?-\d{8}\.html)">(?:<IMG SRC="/[\w/]+?/images/arrow_right.gif|(?:<font[^>]*?>)?Next Day)')),
        imageUrl=baseUrl + 'name-%s.html',
        imageSearch=compile(r'SRC="(/[\w/]+?/archive/images/\w+?\d+\..+?)"'),
        prevSearch=compile(r'<A HREF="(/[\w/]+?/archive/\w+?-\d{8}\.html)">(?:<IMG SRC="/[\w/]+?/images/arrow_left.gif|(?:<font[^>]*?>)?Previous Day)'),
        help='Index format: yyyymmdd',
        namer=namer)


acaseinpoint = comicsDotCom('acaseinpoint', 'comics')
agnes = comicsDotCom('agnes', 'creators')
alleyoop = comicsDotCom('alleyoop', 'comics')
andycapp = comicsDotCom('andycapp', 'creators')
arlonjanis = comicsDotCom('arlonjanis', 'comics')
ballardst = comicsDotCom('ballardst', 'creators')
barkeaterlake = comicsDotCom('barkeaterlake', 'comics')
bc = comicsDotCom('bc', 'creators')
ben = comicsDotCom('ben', 'comics')
betty = comicsDotCom('betty', 'comics')
bignate = comicsDotCom('bignate', 'comics')
bonanas = comicsDotCom('bonanas', 'wash')
bornloser = comicsDotCom('bornloser', 'comics')
buckets = comicsDotCom('buckets', 'comics')
candorville = comicsDotCom('candorville', 'wash')
cheapthrills = comicsDotCom('cheapthrills', 'wash')
chickweed = comicsDotCom('chickweed', 'comics')
committed = comicsDotCom('committed', 'comics')
dilbert = comicsDotCom('dilbert', 'comics')
drabble = comicsDotCom('drabble', 'comics')
fatcats = comicsDotCom('fatcats', 'comics')
ferdnand = comicsDotCom('ferdnand', 'comics')
flightdeck = comicsDotCom('flightdeck', 'creators')
floandfriends = comicsDotCom('floandfriends', 'creators')
franknernest = comicsDotCom('franknernest', 'comics')
frazz = comicsDotCom('frazz', 'comics')
geech = comicsDotCom('geech', 'comics')
genepool = comicsDotCom('genepool', 'wash')
getfuzzy = comicsDotCom('getfuzzy', 'comics')
gofish = comicsDotCom('gofish', 'comics')
graffiti = comicsDotCom('graffiti', 'comics')
grandave = comicsDotCom('grandave', 'comics')
grizzwells = comicsDotCom('grizzwells', 'comics')
heathcliff = comicsDotCom('heathcliff', 'creators')
hedge = comicsDotCom('hedge', 'comics')
herbnjamaal = comicsDotCom('herbnjamaal', 'creators')
herman = comicsDotCom('herman', 'comics')
humblestumble = comicsDotCom('humblestumble', 'comics')
janesworld = comicsDotCom('janesworld', 'comics')
jumpstart = comicsDotCom('jumpstart', 'comics')
kitncarlyle = comicsDotCom('kitncarlyle', 'comics')
liberty = comicsDotCom('liberty', 'creators')
lilabner = comicsDotCom('lilabner', 'comics')
luann = comicsDotCom('luann', 'comics')
marmaduke = comicsDotCom('marmaduke', 'comics')
meg = comicsDotCom('meg', 'comics')
moderatelyconfused = comicsDotCom('moderatelyconfused', 'comics')
momma = comicsDotCom('momma', 'creators')
monty = comicsDotCom('monty', 'comics')
motley = comicsDotCom('motley', 'comics')
nancy = comicsDotCom('nancy', 'comics')
naturalselection = comicsDotCom('naturalselection', 'creators')
offthemark = comicsDotCom('offthemark', 'comics')
onebighappy = comicsDotCom('onebighappy', 'creators')
othercoast = comicsDotCom('othercoast', 'creators')
pcnpixel = comicsDotCom('pcnpixel', 'wash')
peanuts = comicsDotCom('peanuts', 'comics')
pearls = comicsDotCom('pearls', 'comics')
pibgorn = comicsDotCom('pibgorn', 'comics')
pickles = comicsDotCom('pickles', 'wash')
raisingduncan = comicsDotCom('raisingduncan', 'comics')
reality = comicsDotCom('reality', 'comics')
redandrover = comicsDotCom('redandrover', 'wash')
ripleys = comicsDotCom('ripleys', 'comics')
roseisrose = comicsDotCom('roseisrose', 'comics')
rubes = comicsDotCom('rubes', 'creators')
rudypark = comicsDotCom('rudypark', 'comics')
shirleynson = comicsDotCom('shirleynson', 'comics')
soup2nutz = comicsDotCom('soup2nutz', 'comics')
speedbump = comicsDotCom('speedbump', 'creators')
spotthefrog = comicsDotCom('spotthefrog', 'comics')
strangebrew = comicsDotCom('strangebrew', 'creators')
sunshineclub = comicsDotCom('sunshineclub', 'comics')
tarzan = comicsDotCom('tarzan', 'comics')
thatslife = comicsDotCom('thatslife', 'wash')
wizardofid = comicsDotCom('wizardofid', 'creators')
workingdaze = comicsDotCom('workingdaze', 'comics')
workingitout = comicsDotCom('workingitout', 'creators')


def creators(name, shortname):
    return BasicScraper.make(
        'Creators/' + name,
        latestUrl='http://www.creators.com/comics_show.cfm?ComicName=%s' % (shortname,),
        imageUrl=None,
        imageSearch=compile(r'<img alt="[^"]+" src="(\d{4}/.+?/.+?\..+?)">'),
        prevSearch=compile(r'<a href="(comics_show\.cfm\?next=\d+&ComicName=.+?)" Title="Previous Comic"'),
        help='Indexing unsupported')


arc = creators('Archie', 'arc')
shg = creators('AskShagg', 'shg')
hev = creators('ForHeavensSake', 'hev')
rug = creators('Rugrats', 'rug')
sou = creators('StateOfTheUnion', 'sou')
din = creators('TheDinetteSet', 'din')
lil = creators('TheMeaningOfLila', 'lil')
wee = creators('WeePals', 'wee')
zhi = creators('ZackHill', 'zhi')


class CyanideAndHappiness(BasicScraper):
    latestUrl = 'http://www.explosm.net/comics'
    imageUrl = 'http://www.explosm.net/comics/%s'
    imageSearch = compile(r'<img alt="Cyanide and Happiness, a daily webcomic" src="(http:\/\/www\.explosm\.net/db/files/Comics/\w+/\S+\.\w+)"')
    prevSearch = compile(r'<a href="(/comics/\d+/?)">< Previous</a>')
    help = 'Index format: n (unpadded)'
