------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick.ads,v 1.24 2007/11/21 14:14:06 vagul Exp $

with
   Ada.Finalization,
   Ada.Strings.Bounded,
   Ada.Task_Identification,
   System,
   OCI.Lib,
   OCI.Reference_Finalization;

package OCI.Thick is

   package RF renames Reference_Finalization;

   use Lib;
   use Ada.Task_Identification;

   package Bind_Names is new Ada.Strings.Bounded.Generic_Bounded_Length (30);

   subtype OCINumber is Lib.OCINumber;

   type Default_Mode is (Instead_Null, Instead_Not_Attached, Instead_Any);

   type Limited_Variable is tagged limited private;

   procedure Clear_Value (Var : in out Limited_Variable);

   function Is_Attached (Var : in Limited_Variable) return Boolean;
   pragma Inline (Is_Attached);

   function Is_Binded (Var : in Limited_Variable) return Boolean;
   pragma Inline (Is_Binded);

   function Is_Defined (Var : in Limited_Variable) return Boolean;
   pragma Inline (Is_Defined);

   function Is_Null (Var : in Limited_Variable) return Boolean;

   Invalid_Handle : exception;
   Lib_Error      : exception;
   Null_Value     : exception;

   Not_Attached   : exception;
   --  trying get not attached variable

   Too_Late_For_Dedicated_Environment : exception;

   function Last_Error_Code return Integer;

   function Last_Error_Message (Record_No : Integer := 1) return String;

   function Last_Error_Offset return Natural;
   --  Return position of last error in the DML statement.

   type Handle_Reference is abstract new RF.Controlled_Reference with private;

   procedure Check_Error (Code : SWord; Raise_Exception : Boolean := True);
   pragma Inline (Check_Error);

   procedure Ignore_Error (Code : SWord);
   pragma Inline (Ignore_Error);

   procedure Task_Dedicated_Environment;

   procedure Task_Done (T : Task_Id := Current_Task);
   --  Call it, when you are sure about using the task is done.

   procedure Set_Events_Support;
   --  Set the Event support.
   --  Should call before first OCI call.

   procedure Set_Objects_Support;
   --  Set the object support.
   --  Should call before first OCI call.

   function Is_Objects_Support return Boolean;
   pragma Inline (Is_Objects_Support);

   function Client_Version return String;

private

   function Handle (Ref : Handle_Reference'Class) return System.Address;
   pragma Inline (Handle);

   type Handle_Reference is abstract new RF.Controlled_Reference with record
      Handle : aliased OCIHandle := Empty_Handle;
   end record;

   package AF renames Ada.Finalization;

   type Limited_Variable is new AF.Limited_Controlled with record
      Indicator : aliased Sb2       := Null_Indicator;
      Bind      : aliased OCIBind   := OCIBind (Empty_Handle);
      Define    : aliased OCIDefine := OCIDefine (Empty_Handle);
   end record;

   procedure Free (H : in out OCIHandle; HType : in Ub4);
   function Alloc_Handle (Parent : in OCIEnv; Htype : in Ub4) return OCIHandle;
   function Alloc_Descriptor
     (Parent : in OCIEnv; Htype : in Ub4) return OCIHandle;

   function Get_Attr
     (Param : in OCIHandle;
      HType : in Ub4;
      Attr  : in Ub4) return String;

   generic
      type Result_Type is private;
   function Get_Attr_G
     (H     : in OCIHandle;
      HType : in Ub4;
      Attr  : in Ub4) return Result_Type;
   pragma Inline (Get_Attr_G);

   procedure Set_Attr
     (H     : in OCIHandle;
      HType : in Ub4;
      Attr  : in Ub4;
      Value : in String);

   procedure Set_Attr
     (H     : in OCIHandle;
      HType : in Ub4;
      Attr  : in Ub4;
      Value : in OCIHandle);

end OCI.Thick;
