// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package analyticsadmin provides access to the Google Analytics Admin API.
//
// For product documentation, see: http://code.google.com/apis/analytics/docs/mgmt/home.html
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/analyticsadmin/v1alpha"
//   ...
//   ctx := context.Background()
//   analyticsadminService, err := analyticsadmin.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithScopes(analyticsadmin.AnalyticsReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package analyticsadmin // import "google.golang.org/api/analyticsadmin/v1alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "analyticsadmin:v1alpha"
const apiName = "analyticsadmin"
const apiVersion = "v1alpha"
const basePath = "https://analyticsadmin.googleapis.com/"
const mtlsBasePath = "https://analyticsadmin.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Edit Google Analytics management entities
	AnalyticsEditScope = "https://www.googleapis.com/auth/analytics.edit"

	// Manage Google Analytics Account users by email address
	AnalyticsManageUsersScope = "https://www.googleapis.com/auth/analytics.manage.users"

	// View Google Analytics user permissions
	AnalyticsManageUsersReadonlyScope = "https://www.googleapis.com/auth/analytics.manage.users.readonly"

	// See and download your Google Analytics data
	AnalyticsReadonlyScope = "https://www.googleapis.com/auth/analytics.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/analytics.edit",
		"https://www.googleapis.com/auth/analytics.manage.users",
		"https://www.googleapis.com/auth/analytics.manage.users.readonly",
		"https://www.googleapis.com/auth/analytics.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.AccountSummaries = NewAccountSummariesService(s)
	s.Accounts = NewAccountsService(s)
	s.Properties = NewPropertiesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AccountSummaries *AccountSummariesService

	Accounts *AccountsService

	Properties *PropertiesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountSummariesService(s *Service) *AccountSummariesService {
	rs := &AccountSummariesService{s: s}
	return rs
}

type AccountSummariesService struct {
	s *Service
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.UserLinks = NewAccountsUserLinksService(s)
	return rs
}

type AccountsService struct {
	s *Service

	UserLinks *AccountsUserLinksService
}

func NewAccountsUserLinksService(s *Service) *AccountsUserLinksService {
	rs := &AccountsUserLinksService{s: s}
	return rs
}

type AccountsUserLinksService struct {
	s *Service
}

func NewPropertiesService(s *Service) *PropertiesService {
	rs := &PropertiesService{s: s}
	rs.AndroidAppDataStreams = NewPropertiesAndroidAppDataStreamsService(s)
	rs.FirebaseLinks = NewPropertiesFirebaseLinksService(s)
	rs.GoogleAdsLinks = NewPropertiesGoogleAdsLinksService(s)
	rs.IosAppDataStreams = NewPropertiesIosAppDataStreamsService(s)
	rs.UserLinks = NewPropertiesUserLinksService(s)
	rs.WebDataStreams = NewPropertiesWebDataStreamsService(s)
	return rs
}

type PropertiesService struct {
	s *Service

	AndroidAppDataStreams *PropertiesAndroidAppDataStreamsService

	FirebaseLinks *PropertiesFirebaseLinksService

	GoogleAdsLinks *PropertiesGoogleAdsLinksService

	IosAppDataStreams *PropertiesIosAppDataStreamsService

	UserLinks *PropertiesUserLinksService

	WebDataStreams *PropertiesWebDataStreamsService
}

func NewPropertiesAndroidAppDataStreamsService(s *Service) *PropertiesAndroidAppDataStreamsService {
	rs := &PropertiesAndroidAppDataStreamsService{s: s}
	return rs
}

type PropertiesAndroidAppDataStreamsService struct {
	s *Service
}

func NewPropertiesFirebaseLinksService(s *Service) *PropertiesFirebaseLinksService {
	rs := &PropertiesFirebaseLinksService{s: s}
	return rs
}

type PropertiesFirebaseLinksService struct {
	s *Service
}

func NewPropertiesGoogleAdsLinksService(s *Service) *PropertiesGoogleAdsLinksService {
	rs := &PropertiesGoogleAdsLinksService{s: s}
	return rs
}

type PropertiesGoogleAdsLinksService struct {
	s *Service
}

func NewPropertiesIosAppDataStreamsService(s *Service) *PropertiesIosAppDataStreamsService {
	rs := &PropertiesIosAppDataStreamsService{s: s}
	return rs
}

type PropertiesIosAppDataStreamsService struct {
	s *Service
}

func NewPropertiesUserLinksService(s *Service) *PropertiesUserLinksService {
	rs := &PropertiesUserLinksService{s: s}
	return rs
}

type PropertiesUserLinksService struct {
	s *Service
}

func NewPropertiesWebDataStreamsService(s *Service) *PropertiesWebDataStreamsService {
	rs := &PropertiesWebDataStreamsService{s: s}
	return rs
}

type PropertiesWebDataStreamsService struct {
	s *Service
}

// GoogleAnalyticsAdminV1alphaAccount: A resource message representing a
// Google Analytics account.
type GoogleAnalyticsAdminV1alphaAccount struct {
	// CreateTime: Output only. Time when this account was originally
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Deleted: Output only. Indicates whether this Account is soft-deleted
	// or not. Deleted accounts are excluded from List results unless
	// specifically requested.
	Deleted bool `json:"deleted,omitempty"`

	// DisplayName: Required. Human-readable display name for this account.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Output only. Resource name of this account. Format:
	// accounts/{account} Example: "accounts/100"
	Name string `json:"name,omitempty"`

	// RegionCode: Country of business. Must be a Unicode CLDR region code.
	RegionCode string `json:"regionCode,omitempty"`

	// UpdateTime: Output only. Time when account payload fields were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccountSummary: A virtual resource
// representing an overview of an account and all its child GA4
// properties.
type GoogleAnalyticsAdminV1alphaAccountSummary struct {
	// Account: Resource name of account referred to by this account summary
	// Format: accounts/{account_id} Example: "accounts/1000"
	Account string `json:"account,omitempty"`

	// DisplayName: Display name for the account referred to in this account
	// summary.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Resource name for this account summary. Format:
	// accountSummaries/{account_id} Example: "accountSummaries/1000"
	Name string `json:"name,omitempty"`

	// PropertySummaries: List of summaries for child accounts of this
	// account.
	PropertySummaries []*GoogleAnalyticsAdminV1alphaPropertySummary `json:"propertySummaries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccountSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccountSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAndroidAppDataStream: A resource message
// representing a Google Analytics Android app stream.
type GoogleAnalyticsAdminV1alphaAndroidAppDataStream struct {
	// CreateTime: Output only. Time when this stream was originally
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Human-readable display name for the Data Stream. The max
	// allowed display name length is 255 UTF-16 code units.
	DisplayName string `json:"displayName,omitempty"`

	// FirebaseAppId: Output only. ID of the corresponding Android app in
	// Firebase, if any. This ID can change if the Android app is deleted
	// and recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`

	// Name: Output only. Resource name of this Data Stream. Format:
	// properties/{property_id}/androidAppDataStreams/{stream_id} Example:
	// "properties/1000/androidAppDataStreams/2000"
	Name string `json:"name,omitempty"`

	// PackageName: Immutable. The package name for the app being measured.
	// Example: "com.example.myandroidapp"
	PackageName string `json:"packageName,omitempty"`

	// UpdateTime: Output only. Time when stream payload fields were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAndroidAppDataStream) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAndroidAppDataStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAuditUserLink: Read-only resource used to
// summarize a principal's effective roles.
type GoogleAnalyticsAdminV1alphaAuditUserLink struct {
	// DirectRoles: Roles directly assigned to this user for this entity.
	// Format: predefinedRoles/read Excludes roles that are inherited from
	// an account (if this is for a property), group, or organization admin
	// role.
	DirectRoles []string `json:"directRoles,omitempty"`

	// EffectiveRoles: Union of all permissions a user has at this account
	// or property (includes direct permissions, group-inherited
	// permissions, etc.). Format: predefinedRoles/read
	EffectiveRoles []string `json:"effectiveRoles,omitempty"`

	// EmailAddress: Email address of the linked user
	EmailAddress string `json:"emailAddress,omitempty"`

	// Name: Example format: properties/1234/userLinks/5678
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DirectRoles") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DirectRoles") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAuditUserLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAuditUserLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAuditUserLinksRequest: Request message for
// AuditUserLinks RPC.
type GoogleAnalyticsAdminV1alphaAuditUserLinksRequest struct {
	// PageSize: The maximum number of user links to return. The service may
	// return fewer than this value. If unspecified, at most 1000 user links
	// will be returned. The maximum value is 5000; values above 5000 will
	// be coerced to 5000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous `AuditUserLinks`
	// call. Provide this to retrieve the subsequent page. When paginating,
	// all other parameters provided to `AuditUserLinks` must match the call
	// that provided the page token.
	PageToken string `json:"pageToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAuditUserLinksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAuditUserLinksRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAuditUserLinksResponse: Response message
// for AuditUserLinks RPC.
type GoogleAnalyticsAdminV1alphaAuditUserLinksResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UserLinks: List of AuditUserLinks. These will be ordered stably, but
	// in an arbitrary order.
	UserLinks []*GoogleAnalyticsAdminV1alphaAuditUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAuditUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAuditUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest: Request
// message for BatchCreateUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest struct {
	// NotifyNewUsers: Optional. If set, then email the new users notifying
	// them that they've been granted permissions to the resource.
	// Regardless of whether this is set or not, notify_new_user field
	// inside each individual request is ignored.
	NotifyNewUsers bool `json:"notifyNewUsers,omitempty"`

	// Requests: Required. The requests specifying the user links to create.
	// A maximum of 1000 user links can be created in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaCreateUserLinkRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NotifyNewUsers") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NotifyNewUsers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse: Response
// message for BatchCreateUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse struct {
	// UserLinks: The user links created.
	UserLinks []*GoogleAnalyticsAdminV1alphaUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "UserLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserLinks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest: Request
// message for BatchDeleteUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest struct {
	// Requests: Required. The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse: Response
// message for BatchGetUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse struct {
	// UserLinks: The requested user links.
	UserLinks []*GoogleAnalyticsAdminV1alphaUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "UserLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserLinks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest: Request
// message for BatchUpdateUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest struct {
	// Requests: Required. The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse: Response
// message for BatchUpdateUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse struct {
	// UserLinks: The user links updated.
	UserLinks []*GoogleAnalyticsAdminV1alphaUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "UserLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserLinks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChangeHistoryChange: A description of a
// change to a single Google Analytics resource.
type GoogleAnalyticsAdminV1alphaChangeHistoryChange struct {
	// Action: The type of action that changed this resource.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Action type unknown or not specified.
	//   "CREATED" - Resource was created in this change.
	//   "UPDATED" - Resource was updated in this change.
	//   "DELETED" - Resource was deleted in this change.
	Action string `json:"action,omitempty"`

	// Resource: Resource name of the resource whose changes are described
	// by this entry.
	Resource string `json:"resource,omitempty"`

	// ResourceAfterChange: Resource contents from after the change was
	// made. If this resource was deleted in this change, this field will be
	// missing.
	ResourceAfterChange *GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource `json:"resourceAfterChange,omitempty"`

	// ResourceBeforeChange: Resource contents from before the change was
	// made. If this resource was created in this change, this field will be
	// missing.
	ResourceBeforeChange *GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource `json:"resourceBeforeChange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChangeHistoryChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChangeHistoryChange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource:
// A snapshot of a resource as before or after the result of a change in
// change history.
type GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource struct {
	// Account: A snapshot of an Account resource in change history.
	Account *GoogleAnalyticsAdminV1alphaAccount `json:"account,omitempty"`

	// AndroidAppDataStream: A snapshot of an AndroidAppDataStream resource
	// in change history.
	AndroidAppDataStream *GoogleAnalyticsAdminV1alphaAndroidAppDataStream `json:"androidAppDataStream,omitempty"`

	// FirebaseLink: A snapshot of a FirebaseLink resource in change
	// history.
	FirebaseLink *GoogleAnalyticsAdminV1alphaFirebaseLink `json:"firebaseLink,omitempty"`

	// GoogleAdsLink: A snapshot of a GoogleAdsLink resource in change
	// history.
	GoogleAdsLink *GoogleAnalyticsAdminV1alphaGoogleAdsLink `json:"googleAdsLink,omitempty"`

	// IosAppDataStream: A snapshot of an IosAppDataStream resource in
	// change history.
	IosAppDataStream *GoogleAnalyticsAdminV1alphaIosAppDataStream `json:"iosAppDataStream,omitempty"`

	// Property: A snapshot of a Property resource in change history.
	Property *GoogleAnalyticsAdminV1alphaProperty `json:"property,omitempty"`

	// WebDataStream: A snapshot of a WebDataStream resource in change
	// history.
	WebDataStream *GoogleAnalyticsAdminV1alphaWebDataStream `json:"webDataStream,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChangeHistoryEvent: A set of changes
// within a Google Analytics account or its child properties that
// resulted from the same cause. Common causes would be updates made in
// the Google Analytics UI, changes from customer support, or automatic
// Google Analytics system changes.
type GoogleAnalyticsAdminV1alphaChangeHistoryEvent struct {
	// ActorType: The type of actor that made this change.
	//
	// Possible values:
	//   "ACTOR_TYPE_UNSPECIFIED" - Unknown or unspecified actor type.
	//   "USER" - Changes made by the user specified in actor_email.
	//   "SYSTEM" - Changes made by the Google Analytics system.
	//   "SUPPORT" - Changes made by Google Analytics support team staff.
	ActorType string `json:"actorType,omitempty"`

	// ChangeTime: Time when change was made.
	ChangeTime string `json:"changeTime,omitempty"`

	// Changes: A list of changes made in this change history event that fit
	// the filters specified in SearchChangeHistoryEventsRequest.
	Changes []*GoogleAnalyticsAdminV1alphaChangeHistoryChange `json:"changes,omitempty"`

	// ChangesFiltered: If true, then the list of changes returned was
	// filtered, and does not represent all changes that occurred in this
	// event.
	ChangesFiltered bool `json:"changesFiltered,omitempty"`

	// Id: ID of this change history event. This ID is unique across Google
	// Analytics.
	Id string `json:"id,omitempty"`

	// UserActorEmail: Email address of the Google account that made the
	// change. This will be a valid email address if the actor field is set
	// to USER, and empty otherwise. Google accounts that have been deleted
	// will cause an error.
	UserActorEmail string `json:"userActorEmail,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActorType") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActorType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChangeHistoryEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChangeHistoryEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaCreateUserLinkRequest: Request message for
// CreateUserLink RPC. Users can have multiple email addresses
// associated with their Google account, and one of these email
// addresses is the "primary" email address. Any of the email addresses
// associated with a Google account may be used for a new UserLink, but
// the returned UserLink will always contain the "primary" email
// address. As a result, the input and output email address for this
// request may differ.
type GoogleAnalyticsAdminV1alphaCreateUserLinkRequest struct {
	// NotifyNewUser: Optional. If set, then email the new user notifying
	// them that they've been granted permissions to the resource.
	NotifyNewUser bool `json:"notifyNewUser,omitempty"`

	// Parent: Required. Example format: accounts/1234
	Parent string `json:"parent,omitempty"`

	// UserLink: Required. The user link to create.
	UserLink *GoogleAnalyticsAdminV1alphaUserLink `json:"userLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NotifyNewUser") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NotifyNewUser") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaCreateUserLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaCreateUserLinkRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDataSharingSettings: A resource message
// representing data sharing settings of a Google Analytics account.
type GoogleAnalyticsAdminV1alphaDataSharingSettings struct {
	// Name: Output only. Resource name. Format:
	// accounts/{account}/dataSharingSettings Example:
	// "accounts/1000/dataSharingSettings"
	Name string `json:"name,omitempty"`

	// SharingWithGoogleAnySalesEnabled: Allows any of Google sales to
	// access the data in order to suggest configuration changes to improve
	// results.
	SharingWithGoogleAnySalesEnabled bool `json:"sharingWithGoogleAnySalesEnabled,omitempty"`

	// SharingWithGoogleAssignedSalesEnabled: Allows Google sales teams that
	// are assigned to the customer to access the data in order to suggest
	// configuration changes to improve results. Sales team restrictions
	// still apply when enabled.
	SharingWithGoogleAssignedSalesEnabled bool `json:"sharingWithGoogleAssignedSalesEnabled,omitempty"`

	// SharingWithGoogleProductsEnabled: Allows Google to use the data to
	// improve other Google products or services.
	SharingWithGoogleProductsEnabled bool `json:"sharingWithGoogleProductsEnabled,omitempty"`

	// SharingWithGoogleSupportEnabled: Allows Google support to access the
	// data in order to help troubleshoot issues.
	SharingWithGoogleSupportEnabled bool `json:"sharingWithGoogleSupportEnabled,omitempty"`

	// SharingWithOthersEnabled: Allows Google to share the data anonymously
	// in aggregate form with others.
	SharingWithOthersEnabled bool `json:"sharingWithOthersEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDataSharingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDataSharingSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest: Request message for
// DeleteUserLink RPC.
type GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest struct {
	// Name: Required. Example format: accounts/1234/userLinks/5678
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings: Singleton
// resource under a WebDataStream, configuring measurement of additional
// site interactions and content.
type GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings struct {
	// FileDownloadsEnabled: If enabled, capture a file download event each
	// time a link is clicked with a common document, compressed file,
	// application, video, or audio extension.
	FileDownloadsEnabled bool `json:"fileDownloadsEnabled,omitempty"`

	// Name: Output only. Resource name of this Data Stream. Format:
	// properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasuremen
	// tSettings Example:
	// "properties/1000/webDataStreams/2000/enhancedMeasurementSettings"
	Name string `json:"name,omitempty"`

	// OutboundClicksEnabled: If enabled, capture an outbound click event
	// each time a visitor clicks a link that leads them away from your
	// domain.
	OutboundClicksEnabled bool `json:"outboundClicksEnabled,omitempty"`

	// PageChangesEnabled: If enabled, capture a page view event each time
	// the website changes the browser history state.
	PageChangesEnabled bool `json:"pageChangesEnabled,omitempty"`

	// PageLoadsEnabled: Output only. If enabled, capture a page view event
	// each time a page loads.
	PageLoadsEnabled bool `json:"pageLoadsEnabled,omitempty"`

	// PageViewsEnabled: Output only. If enabled, capture a page view event
	// each time a page loads or the website changes the browser history
	// state.
	PageViewsEnabled bool `json:"pageViewsEnabled,omitempty"`

	// ScrollsEnabled: If enabled, capture scroll events each time a visitor
	// gets to the bottom of a page.
	ScrollsEnabled bool `json:"scrollsEnabled,omitempty"`

	// SearchQueryParameter: Required. URL query parameters to interpret as
	// site search parameters. Max length is 1024 characters. Must not be
	// empty.
	SearchQueryParameter string `json:"searchQueryParameter,omitempty"`

	// SiteSearchEnabled: If enabled, capture a view search results event
	// each time a visitor performs a search on your site (based on a query
	// parameter).
	SiteSearchEnabled bool `json:"siteSearchEnabled,omitempty"`

	// StreamEnabled: Indicates whether Enhanced Measurement Settings will
	// be used to automatically measure interactions and content on this web
	// stream. Changing this value does not affect the settings themselves,
	// but determines whether they are respected.
	StreamEnabled bool `json:"streamEnabled,omitempty"`

	// UriQueryParameter: Additional URL query parameters. Max length is
	// 1024 characters.
	UriQueryParameter string `json:"uriQueryParameter,omitempty"`

	// VideoEngagementEnabled: If enabled, capture video play, progress, and
	// complete events as visitors view embedded videos on your site.
	VideoEngagementEnabled bool `json:"videoEngagementEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "FileDownloadsEnabled") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileDownloadsEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaFirebaseLink: A link between an GA4
// property and a Firebase project.
type GoogleAnalyticsAdminV1alphaFirebaseLink struct {
	// CreateTime: Output only. Time when this FirebaseLink was originally
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// MaximumUserAccess: Maximum user access to the GA4 property allowed to
	// admins of the linked Firebase project.
	//
	// Possible values:
	//   "MAXIMUM_USER_ACCESS_UNSPECIFIED" - Unspecified maximum user
	// access.
	//   "NO_ACCESS" - Firebase users have no access to the Analytics
	// property.
	//   "READ_AND_ANALYZE" - Firebase users have Read & Analyze access to
	// the Analytics property.
	//   "EDITOR_WITHOUT_LINK_MANAGEMENT" - Firebase users have edit access
	// to the Analytics property, but may not manage the Firebase link.
	//   "EDITOR_INCLUDING_LINK_MANAGEMENT" - Firebase users have edit
	// access to the Analytics property and may manage the Firebase link.
	MaximumUserAccess string `json:"maximumUserAccess,omitempty"`

	// Name: Output only. Example format: properties/1234/firebaseLinks/5678
	Name string `json:"name,omitempty"`

	// Project: Immutable. Firebase project resource name. When creating a
	// FirebaseLink, you may provide this resource name using either a
	// project number or project ID. Once this resource has been created,
	// returned FirebaseLinks will always have a project_name that contains
	// a project number. Format: 'projects/{project number}' Example:
	// 'projects/1234'
	Project string `json:"project,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaFirebaseLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaFirebaseLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaGlobalSiteTag: Read-only resource with the
// tag for sending data from a website to a WebDataStream.
type GoogleAnalyticsAdminV1alphaGlobalSiteTag struct {
	// Name: Output only. Resource name for this GlobalSiteTag resource.
	// Format: properties/{propertyId}/globalSiteTag
	Name string `json:"name,omitempty"`

	// Snippet: Immutable. JavaScript code snippet to be pasted as the first
	// item into the head tag of every webpage to measure.
	Snippet string `json:"snippet,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaGlobalSiteTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaGlobalSiteTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaGoogleAdsLink: A link between an GA4
// property and a Google Ads account.
type GoogleAnalyticsAdminV1alphaGoogleAdsLink struct {
	// AdsPersonalizationEnabled: Enable personalized advertising features
	// with this integration. Automatically publish my Google Analytics
	// audience lists and Google Analytics remarketing events/parameters to
	// the linked Google Ads account. If this field is not set on
	// create/update it will be defaulted to true.
	AdsPersonalizationEnabled bool `json:"adsPersonalizationEnabled,omitempty"`

	// CanManageClients: Output only. If true, this link is for a Google Ads
	// manager account.
	CanManageClients bool `json:"canManageClients,omitempty"`

	// CreateTime: Output only. Time when this link was originally created.
	CreateTime string `json:"createTime,omitempty"`

	// CustomerId: Immutable. Google Ads customer ID.
	CustomerId string `json:"customerId,omitempty"`

	// EmailAddress: Output only. Email address of the user that created the
	// link. An empty string will be returned if the email address can't be
	// retrieved.
	EmailAddress string `json:"emailAddress,omitempty"`

	// Name: Output only. Format:
	// properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
	// googleAdsLinkId is not the Google Ads customer ID.
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Time when this link was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaGoogleAdsLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaGoogleAdsLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaIosAppDataStream: A resource message
// representing a Google Analytics IOS app stream.
type GoogleAnalyticsAdminV1alphaIosAppDataStream struct {
	// BundleId: Required. Immutable. The Apple App Store Bundle ID for the
	// app Example: "com.example.myiosapp"
	BundleId string `json:"bundleId,omitempty"`

	// CreateTime: Output only. Time when this stream was originally
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Human-readable display name for the Data Stream. The max
	// allowed display name length is 255 UTF-16 code units.
	DisplayName string `json:"displayName,omitempty"`

	// FirebaseAppId: Output only. ID of the corresponding iOS app in
	// Firebase, if any. This ID can change if the iOS app is deleted and
	// recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`

	// Name: Output only. Resource name of this Data Stream. Format:
	// properties/{property_id}/iosAppDataStreams/{stream_id} Example:
	// "properties/1000/iosAppDataStreams/2000"
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Time when stream payload fields were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BundleId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BundleId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaIosAppDataStream) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaIosAppDataStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListAccountSummariesResponse: Response
// message for ListAccountSummaries RPC.
type GoogleAnalyticsAdminV1alphaListAccountSummariesResponse struct {
	// AccountSummaries: Account summaries of all accounts the caller has
	// access to.
	AccountSummaries []*GoogleAnalyticsAdminV1alphaAccountSummary `json:"accountSummaries,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountSummaries") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountSummaries") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListAccountSummariesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListAccountSummariesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListAccountsResponse: Request message for
// ListAccounts RPC.
type GoogleAnalyticsAdminV1alphaListAccountsResponse struct {
	// Accounts: Results that were accessible to the caller.
	Accounts []*GoogleAnalyticsAdminV1alphaAccount `json:"accounts,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Accounts") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accounts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse: Request
// message for ListAndroidDataStreams RPC.
type GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse struct {
	// AndroidAppDataStreams: Results that matched the filter criteria and
	// were accessible to the caller.
	AndroidAppDataStreams []*GoogleAnalyticsAdminV1alphaAndroidAppDataStream `json:"androidAppDataStreams,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AndroidAppDataStreams") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidAppDataStreams") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse: Response
// message for ListFirebaseLinks RPC
type GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse struct {
	// FirebaseLinks: List of FirebaseLinks. This will have at most one
	// value.
	FirebaseLinks []*GoogleAnalyticsAdminV1alphaFirebaseLink `json:"firebaseLinks,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages. Currently, Google Analytics supports only one FirebaseLink per
	// property, so this will never be populated.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FirebaseLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FirebaseLinks") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse: Response
// message for ListGoogleAdsLinks RPC.
type GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse struct {
	// GoogleAdsLinks: List of GoogleAdsLinks.
	GoogleAdsLinks []*GoogleAnalyticsAdminV1alphaGoogleAdsLink `json:"googleAdsLinks,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "GoogleAdsLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GoogleAdsLinks") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse: Request
// message for ListIosAppDataStreams RPC.
type GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse struct {
	// IosAppDataStreams: Results that matched the filter criteria and were
	// accessible to the caller.
	IosAppDataStreams []*GoogleAnalyticsAdminV1alphaIosAppDataStream `json:"iosAppDataStreams,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IosAppDataStreams")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IosAppDataStreams") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListPropertiesResponse: Response message
// for ListProperties RPC.
type GoogleAnalyticsAdminV1alphaListPropertiesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Properties: Results that matched the filter criteria and were
	// accessible to the caller.
	Properties []*GoogleAnalyticsAdminV1alphaProperty `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListPropertiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListPropertiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListUserLinksResponse: Response message
// for ListUserLinks RPC.
type GoogleAnalyticsAdminV1alphaListUserLinksResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UserLinks: List of UserLinks. These will be ordered stably, but in an
	// arbitrary order.
	UserLinks []*GoogleAnalyticsAdminV1alphaUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse: Request
// message for ListWebDataStreams RPC.
type GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// WebDataStreams: Results that matched the filter criteria and were
	// accessible to the caller.
	WebDataStreams []*GoogleAnalyticsAdminV1alphaWebDataStream `json:"webDataStreams,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaProperty: A resource message representing
// a Google Analytics GA4 property.
type GoogleAnalyticsAdminV1alphaProperty struct {
	// CreateTime: Output only. Time when the entity was originally created.
	CreateTime string `json:"createTime,omitempty"`

	// CurrencyCode: The currency type used in reports involving monetary
	// values. Format: https://en.wikipedia.org/wiki/ISO_4217 Examples:
	// "USD", "EUR", "JPY"
	CurrencyCode string `json:"currencyCode,omitempty"`

	// DeleteTime: Output only. If set, the time at which this property was
	// trashed. If not set, then this property is not currently in the trash
	// can.
	DeleteTime string `json:"deleteTime,omitempty"`

	// DisplayName: Required. Human-readable display name for this property.
	// The max allowed display name length is 100 UTF-16 code units.
	DisplayName string `json:"displayName,omitempty"`

	// ExpireTime: Output only. If set, the time at which this trashed
	// property will be permanently deleted. If not set, then this property
	// is not currently in the trash can and is not slated to be deleted.
	ExpireTime string `json:"expireTime,omitempty"`

	// IndustryCategory: Industry associated with this property Example:
	// AUTOMOTIVE, FOOD_AND_DRINK
	//
	// Possible values:
	//   "INDUSTRY_CATEGORY_UNSPECIFIED" - Industry category unspecified
	//   "AUTOMOTIVE" - Automotive
	//   "BUSINESS_AND_INDUSTRIAL_MARKETS" - Business and industrial markets
	//   "FINANCE" - Finance
	//   "HEALTHCARE" - Healthcare
	//   "TECHNOLOGY" - Technology
	//   "TRAVEL" - Travel
	//   "OTHER" - Other
	//   "ARTS_AND_ENTERTAINMENT" - Arts and entertainment
	//   "BEAUTY_AND_FITNESS" - Beauty and fitness
	//   "BOOKS_AND_LITERATURE" - Books and literature
	//   "FOOD_AND_DRINK" - Food and drink
	//   "GAMES" - Games
	//   "HOBBIES_AND_LEISURE" - Hobbies and leisure
	//   "HOME_AND_GARDEN" - Home and garden
	//   "INTERNET_AND_TELECOM" - Internet and telecom
	//   "LAW_AND_GOVERNMENT" - Law and government
	//   "NEWS" - News
	//   "ONLINE_COMMUNITIES" - Online communities
	//   "PEOPLE_AND_SOCIETY" - People and society
	//   "PETS_AND_ANIMALS" - Pets and animals
	//   "REAL_ESTATE" - Real estate
	//   "REFERENCE" - Reference
	//   "SCIENCE" - Science
	//   "SPORTS" - Sports
	//   "JOBS_AND_EDUCATION" - Jobs and education
	//   "SHOPPING" - Shopping
	IndustryCategory string `json:"industryCategory,omitempty"`

	// Name: Output only. Resource name of this property. Format:
	// properties/{property_id} Example: "properties/1000"
	Name string `json:"name,omitempty"`

	// Parent: Immutable. Resource name of this property's logical parent.
	// Note: The Property-Moving UI can be used to change the parent.
	// Format: accounts/{account} Example: "accounts/100"
	Parent string `json:"parent,omitempty"`

	// TimeZone: Required. Reporting Time Zone, used as the day boundary for
	// reports, regardless of where the data originates. If the time zone
	// honors DST, Analytics will automatically adjust for the changes.
	// NOTE: Changing the time zone only affects data going forward, and is
	// not applied retroactively. Format: https://www.iana.org/time-zones
	// Example: "America/Los_Angeles"
	TimeZone string `json:"timeZone,omitempty"`

	// UpdateTime: Output only. Time when entity payload fields were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaPropertySummary: A virtual resource
// representing metadata for an GA4 property.
type GoogleAnalyticsAdminV1alphaPropertySummary struct {
	// DisplayName: Display name for the property referred to in this
	// account summary.
	DisplayName string `json:"displayName,omitempty"`

	// Property: Resource name of property referred to by this property
	// summary Format: properties/{property_id} Example: "properties/1000"
	Property string `json:"property,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaPropertySummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaPropertySummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest: Request
// message for ProvisionAccountTicket RPC.
type GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest struct {
	// Account: The account to create.
	Account *GoogleAnalyticsAdminV1alphaAccount `json:"account,omitempty"`

	// RedirectUri: Redirect URI where the user will be sent after accepting
	// Terms of Service. Must be configured in Developers Console as a
	// Redirect URI
	RedirectUri string `json:"redirectUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse: Response
// message for ProvisionAccountTicket RPC.
type GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse struct {
	// AccountTicketId: The param to be passed in the ToS link.
	AccountTicketId string `json:"accountTicketId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountTicketId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountTicketId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest: Request
// message for SearchChangeHistoryEvents RPC.
type GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest struct {
	// Action: Optional. If set, only return changes that match one or more
	// of these types of actions.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Action type unknown or not specified.
	//   "CREATED" - Resource was created in this change.
	//   "UPDATED" - Resource was updated in this change.
	//   "DELETED" - Resource was deleted in this change.
	Action []string `json:"action,omitempty"`

	// ActorEmail: Optional. If set, only return changes if they are made by
	// a user in this list.
	ActorEmail []string `json:"actorEmail,omitempty"`

	// EarliestChangeTime: Optional. If set, only return changes made after
	// this time (inclusive).
	EarliestChangeTime string `json:"earliestChangeTime,omitempty"`

	// LatestChangeTime: Optional. If set, only return changes made before
	// this time (inclusive).
	LatestChangeTime string `json:"latestChangeTime,omitempty"`

	// PageSize: Optional. The maximum number of ChangeHistoryEvent items to
	// return. The service may return fewer than this value, even if there
	// are additional pages. If unspecified, at most 50 items will be
	// returned. The maximum value is 200 (higher values will be coerced to
	// the maximum).
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: Optional. A page token, received from a previous
	// `SearchChangeHistoryEvents` call. Provide this to retrieve the
	// subsequent page. When paginating, all other parameters provided to
	// `SearchChangeHistoryEvents` must match the call that provided the
	// page token.
	PageToken string `json:"pageToken,omitempty"`

	// Property: Optional. Resource name for a child property. If set, only
	// return changes made to this property or its child resources.
	Property string `json:"property,omitempty"`

	// ResourceType: Optional. If set, only return changes if they are for a
	// resource that matches at least one of these types.
	//
	// Possible values:
	//   "CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED" - Resource type unknown
	// or not specified.
	//   "ACCOUNT" - Account resource
	//   "PROPERTY" - Property resource
	//   "WEB_DATA_STREAM" - WebDataStream resource
	//   "ANDROID_APP_DATA_STREAM" - AndroidAppDataStream resource
	//   "IOS_APP_DATA_STREAM" - IosAppDataStream resource
	//   "FIREBASE_LINK" - FirebaseLink resource
	//   "GOOGLE_ADS_LINK" - GoogleAdsLink resource
	ResourceType []string `json:"resourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse:
// Response message for SearchAccounts RPC.
type GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse struct {
	// ChangeHistoryEvents: Results that were accessible to the caller.
	ChangeHistoryEvents []*GoogleAnalyticsAdminV1alphaChangeHistoryEvent `json:"changeHistoryEvents,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ChangeHistoryEvents")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChangeHistoryEvents") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest: Request message for
// UpdateUserLink RPC.
type GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest struct {
	// UserLink: Required. The user link to update.
	UserLink *GoogleAnalyticsAdminV1alphaUserLink `json:"userLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserLink") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserLink") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaUserLink: A resource message representing
// a user's permissions on an Account or Property resource.
type GoogleAnalyticsAdminV1alphaUserLink struct {
	// DirectRoles: Roles directly assigned to this user for this account or
	// property. Valid values: predefinedRoles/read
	// predefinedRoles/collaborate predefinedRoles/edit
	// predefinedRoles/manage-users Excludes roles that are inherited from a
	// higher-level entity, group, or organization admin role. A UserLink
	// that is updated to have an empty list of direct_roles will be
	// deleted.
	DirectRoles []string `json:"directRoles,omitempty"`

	// EmailAddress: Email address of the user to link
	EmailAddress string `json:"emailAddress,omitempty"`

	// Name: Example format: properties/1234/userLinks/5678
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DirectRoles") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DirectRoles") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaUserLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaUserLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaWebDataStream: A resource message
// representing a Google Analytics web stream.
type GoogleAnalyticsAdminV1alphaWebDataStream struct {
	// CreateTime: Output only. Time when this stream was originally
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DefaultUri: Immutable. Domain name of the web app being measured, or
	// empty. Example: "http://www.google.com", "https://www.google.com"
	DefaultUri string `json:"defaultUri,omitempty"`

	// DisplayName: Required. Human-readable display name for the Data
	// Stream. The max allowed display name length is 100 UTF-16 code units.
	DisplayName string `json:"displayName,omitempty"`

	// FirebaseAppId: Output only. ID of the corresponding web app in
	// Firebase, if any. This ID can change if the web app is deleted and
	// recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`

	// MeasurementId: Output only. Analytics "Measurement ID", without the
	// "G-" prefix. Example: "G-1A2BCD345E" would just be "1A2BCD345E"
	MeasurementId string `json:"measurementId,omitempty"`

	// Name: Output only. Resource name of this Data Stream. Format:
	// properties/{property_id}/webDataStreams/{stream_id} Example:
	// "properties/1000/webDataStreams/2000"
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Time when stream payload fields were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaWebDataStream) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaWebDataStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); } The JSON representation for
// `Empty` is empty JSON object `{}`.
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// method id "analyticsadmin.accountSummaries.list":

type AccountSummariesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns summaries of all accounts accessible by the caller.
func (r *AccountSummariesService) List() *AccountSummariesListCall {
	c := &AccountSummariesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of AccountSummary resources to return. The service may return fewer
// than this value, even if there are additional pages. If unspecified,
// at most 50 resources will be returned. The maximum value is 200;
// (higher values will be coerced to the maximum)
func (c *AccountSummariesListCall) PageSize(pageSize int64) *AccountSummariesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccountSummaries` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccountSummaries` must match the call that provided
// the page token.
func (c *AccountSummariesListCall) PageToken(pageToken string) *AccountSummariesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountSummariesListCall) Fields(s ...googleapi.Field) *AccountSummariesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountSummariesListCall) IfNoneMatch(entityTag string) *AccountSummariesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountSummariesListCall) Context(ctx context.Context) *AccountSummariesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountSummariesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountSummariesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/accountSummaries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accountSummaries.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListAccountSummariesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListAccountSummariesResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountSummariesListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListAccountSummariesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListAccountSummariesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns summaries of all accounts accessible by the caller.",
	//   "flatPath": "v1alpha/accountSummaries",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accountSummaries.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of AccountSummary resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccountSummaries` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccountSummaries` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/accountSummaries",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListAccountSummariesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountSummariesListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListAccountSummariesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.accounts.delete":

type AccountsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Marks target Account as soft-deleted (ie: "trashed") and
// returns it. This API does not have a method to restore soft-deleted
// accounts. However, they can be restored using the Trash Can UI. If
// the accounts are not restored before the expiration time, the account
// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
// UserLinks) will be permanently purged.
// https://support.google.com/analytics/answer/6154772 Returns an error
// if the target is not found.
//
// - name: The name of the Account to soft-delete. Format:
//   accounts/{account} Example: "accounts/100".
func (r *AccountsService) Delete(name string) *AccountsDeleteCall {
	c := &AccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsDeleteCall) Fields(s ...googleapi.Field) *AccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsDeleteCall) Context(ctx context.Context) *AccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks target Account as soft-deleted (ie: \"trashed\") and returns it. This API does not have a method to restore soft-deleted accounts. However, they can be restored using the Trash Can UI. If the accounts are not restored before the expiration time, the account and all child resources (eg: Properties, GoogleAdsLinks, Streams, UserLinks) will be permanently purged. https://support.google.com/analytics/answer/6154772 Returns an error if the target is not found.",
	//   "flatPath": "v1alpha/accounts/{accountsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.accounts.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the Account to soft-delete. Format: accounts/{account} Example: \"accounts/100\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.get":

type AccountsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single Account.
//
// - name: The name of the account to lookup. Format: accounts/{account}
//   Example: "accounts/100".
func (r *AccountsService) Get(name string) *AccountsGetCall {
	c := &AccountsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsGetCall) Fields(s ...googleapi.Field) *AccountsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsGetCall) IfNoneMatch(entityTag string) *AccountsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsGetCall) Context(ctx context.Context) *AccountsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccount or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaAccount.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccount, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaAccount{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single Account.",
	//   "flatPath": "v1alpha/accounts/{accountsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the account to lookup. Format: accounts/{account} Example: \"accounts/100\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccount"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.getDataSharingSettings":

type AccountsGetDataSharingSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDataSharingSettings: Get data sharing settings on an account. Data
// sharing settings are singletons.
//
// - name: The name of the settings to lookup. Format:
//   accounts/{account}/dataSharingSettings Example:
//   "accounts/1000/dataSharingSettings".
func (r *AccountsService) GetDataSharingSettings(name string) *AccountsGetDataSharingSettingsCall {
	c := &AccountsGetDataSharingSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsGetDataSharingSettingsCall) Fields(s ...googleapi.Field) *AccountsGetDataSharingSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsGetDataSharingSettingsCall) IfNoneMatch(entityTag string) *AccountsGetDataSharingSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsGetDataSharingSettingsCall) Context(ctx context.Context) *AccountsGetDataSharingSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsGetDataSharingSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetDataSharingSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.getDataSharingSettings" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaDataSharingSettings or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDataSharingSettings.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsGetDataSharingSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDataSharingSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaDataSharingSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get data sharing settings on an account. Data sharing settings are singletons.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/dataSharingSettings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.getDataSharingSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the settings to lookup. Format: accounts/{account}/dataSharingSettings Example: \"accounts/1000/dataSharingSettings\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/dataSharingSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataSharingSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.list":

type AccountsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all accounts accessible by the caller. Note that these
// accounts might not currently have GA4 properties. Soft-deleted (ie:
// "trashed") accounts are excluded by default. Returns an empty list if
// no relevant accounts are found.
func (r *AccountsService) List() *AccountsListCall {
	c := &AccountsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. The service may return fewer than this value,
// even if there are additional pages. If unspecified, at most 50
// resources will be returned. The maximum value is 200; (higher values
// will be coerced to the maximum)
func (c *AccountsListCall) PageSize(pageSize int64) *AccountsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccounts` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccounts` must match the call that provided the page
// token.
func (c *AccountsListCall) PageToken(pageToken string) *AccountsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Whether to
// include soft-deleted (ie: "trashed") Accounts in the results.
// Accounts can be inspected to determine whether they are deleted or
// not.
func (c *AccountsListCall) ShowDeleted(showDeleted bool) *AccountsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsListCall) Fields(s ...googleapi.Field) *AccountsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsListCall) IfNoneMatch(entityTag string) *AccountsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsListCall) Context(ctx context.Context) *AccountsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListAccountsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListAccountsResponse.ServerResponse.Header
//  or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns all accounts accessible by the caller. Note that these accounts might not currently have GA4 properties. Soft-deleted (ie: \"trashed\") accounts are excluded by default. Returns an empty list if no relevant accounts are found.",
	//   "flatPath": "v1alpha/accounts",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccounts` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccounts` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "showDeleted": {
	//       "description": "Whether to include soft-deleted (ie: \"trashed\") Accounts in the results. Accounts can be inspected to determine whether they are deleted or not.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1alpha/accounts",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListAccountsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListAccountsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.accounts.patch":

type AccountsPatchCall struct {
	s                                  *Service
	name                               string
	googleanalyticsadminv1alphaaccount *GoogleAnalyticsAdminV1alphaAccount
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Patch: Updates an account.
//
// - name: Output only. Resource name of this account. Format:
//   accounts/{account} Example: "accounts/100".
func (r *AccountsService) Patch(name string, googleanalyticsadminv1alphaaccount *GoogleAnalyticsAdminV1alphaAccount) *AccountsPatchCall {
	c := &AccountsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaaccount = googleanalyticsadminv1alphaaccount
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *AccountsPatchCall) UpdateMask(updateMask string) *AccountsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsPatchCall) Fields(s ...googleapi.Field) *AccountsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsPatchCall) Context(ctx context.Context) *AccountsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaccount)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccount or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaAccount.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccount, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaAccount{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an account.",
	//   "flatPath": "v1alpha/accounts/{accountsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.accounts.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this account. Format: accounts/{account} Example: \"accounts/100\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccount"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccount"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.provisionAccountTicket":

type AccountsProvisionAccountTicketCall struct {
	s                                                        *Service
	googleanalyticsadminv1alphaprovisionaccountticketrequest *GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// ProvisionAccountTicket: Requests a ticket for creating an account.
func (r *AccountsService) ProvisionAccountTicket(googleanalyticsadminv1alphaprovisionaccountticketrequest *GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest) *AccountsProvisionAccountTicketCall {
	c := &AccountsProvisionAccountTicketCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphaprovisionaccountticketrequest = googleanalyticsadminv1alphaprovisionaccountticketrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsProvisionAccountTicketCall) Fields(s ...googleapi.Field) *AccountsProvisionAccountTicketCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsProvisionAccountTicketCall) Context(ctx context.Context) *AccountsProvisionAccountTicketCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsProvisionAccountTicketCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProvisionAccountTicketCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaprovisionaccountticketrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/accounts:provisionAccountTicket")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.provisionAccountTicket" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsProvisionAccountTicketCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Requests a ticket for creating an account.",
	//   "flatPath": "v1alpha/accounts:provisionAccountTicket",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.provisionAccountTicket",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/accounts:provisionAccountTicket",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.searchChangeHistoryEvents":

type AccountsSearchChangeHistoryEventsCall struct {
	s                                                           *Service
	account                                                     string
	googleanalyticsadminv1alphasearchchangehistoryeventsrequest *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// SearchChangeHistoryEvents: Searches through all changes to an account
// or its children given the specified set of filters.
//
// - account: The account resource for which to return change history
//   resources.
func (r *AccountsService) SearchChangeHistoryEvents(account string, googleanalyticsadminv1alphasearchchangehistoryeventsrequest *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest) *AccountsSearchChangeHistoryEventsCall {
	c := &AccountsSearchChangeHistoryEventsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.account = account
	c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest = googleanalyticsadminv1alphasearchchangehistoryeventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsSearchChangeHistoryEventsCall) Fields(s ...googleapi.Field) *AccountsSearchChangeHistoryEventsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsSearchChangeHistoryEventsCall) Context(ctx context.Context) *AccountsSearchChangeHistoryEventsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsSearchChangeHistoryEventsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSearchChangeHistoryEventsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+account}:searchChangeHistoryEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"account": c.account,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.searchChangeHistoryEvents" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsSearchChangeHistoryEventsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Searches through all changes to an account or its children given the specified set of filters.",
	//   "flatPath": "v1alpha/accounts/{accountsId}:searchChangeHistoryEvents",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.searchChangeHistoryEvents",
	//   "parameterOrder": [
	//     "account"
	//   ],
	//   "parameters": {
	//     "account": {
	//       "description": "Required. The account resource for which to return change history resources.",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+account}:searchChangeHistoryEvents",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsSearchChangeHistoryEventsCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest.PageToken = pt }(c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest.PageToken = x.NextPageToken
	}
}

// method id "analyticsadmin.accounts.userLinks.audit":

type AccountsUserLinksAuditCall struct {
	s                                                *Service
	parent                                           string
	googleanalyticsadminv1alphaaudituserlinksrequest *GoogleAnalyticsAdminV1alphaAuditUserLinksRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Audit: Lists all user links on an account or property, including
// implicit ones that come from effective permissions granted by groups
// or organization admin roles. If a returned user link does not have
// direct permissions, they cannot be removed from the account or
// property directly with the DeleteUserLink command. They have to be
// removed from the group/etc that gives them permissions, which is
// currently only usable/discoverable in the GA or GMP UIs.
//
// - parent: Example format: accounts/1234.
func (r *AccountsUserLinksService) Audit(parent string, googleanalyticsadminv1alphaaudituserlinksrequest *GoogleAnalyticsAdminV1alphaAuditUserLinksRequest) *AccountsUserLinksAuditCall {
	c := &AccountsUserLinksAuditCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaaudituserlinksrequest = googleanalyticsadminv1alphaaudituserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksAuditCall) Fields(s ...googleapi.Field) *AccountsUserLinksAuditCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksAuditCall) Context(ctx context.Context) *AccountsUserLinksAuditCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksAuditCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksAuditCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaudituserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:audit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.audit" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAuditUserLinksResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAuditUserLinksResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksAuditCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAuditUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaAuditUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all user links on an account or property, including implicit ones that come from effective permissions granted by groups or organization admin roles. If a returned user link does not have direct permissions, they cannot be removed from the account or property directly with the DeleteUserLink command. They have to be removed from the group/etc that gives them permissions, which is currently only usable/discoverable in the GA or GMP UIs.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:audit",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.audit",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:audit",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAuditUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAuditUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsUserLinksAuditCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaAuditUserLinksResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken = pt }(c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken = x.NextPageToken
	}
}

// method id "analyticsadmin.accounts.userLinks.batchCreate":

type AccountsUserLinksBatchCreateCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchcreateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchCreate: Creates information about multiple users' links to an
// account or property. This method is transactional. If any UserLink
// cannot be created, none of the UserLinks will be created.
//
// - parent: The account or property that all user links in the request
//   are for. This field is required. The parent field in the
//   CreateUserLinkRequest messages must either be empty or match this
//   field. Example format: accounts/1234.
func (r *AccountsUserLinksService) BatchCreate(parent string, googleanalyticsadminv1alphabatchcreateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest) *AccountsUserLinksBatchCreateCall {
	c := &AccountsUserLinksBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchcreateuserlinksrequest = googleanalyticsadminv1alphabatchcreateuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksBatchCreateCall) Fields(s ...googleapi.Field) *AccountsUserLinksBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksBatchCreateCall) Context(ctx context.Context) *AccountsUserLinksBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchcreateuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.batchCreate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates information about multiple users' links to an account or property. This method is transactional. If any UserLink cannot be created, none of the UserLinks will be created.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:batchCreate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.batchCreate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. This field is required. The parent field in the CreateUserLinkRequest messages must either be empty or match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchCreate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.batchDelete":

type AccountsUserLinksBatchDeleteCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchdeleteuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchDelete: Deletes information about multiple users' links to an
// account or property.
//
// - parent: The account or property that all user links in the request
//   are for. The parent of all values for user link names to delete
//   must match this field. Example format: accounts/1234.
func (r *AccountsUserLinksService) BatchDelete(parent string, googleanalyticsadminv1alphabatchdeleteuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest) *AccountsUserLinksBatchDeleteCall {
	c := &AccountsUserLinksBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchdeleteuserlinksrequest = googleanalyticsadminv1alphabatchdeleteuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksBatchDeleteCall) Fields(s ...googleapi.Field) *AccountsUserLinksBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksBatchDeleteCall) Context(ctx context.Context) *AccountsUserLinksBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchdeleteuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.batchDelete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsUserLinksBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:batchDelete",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.batchDelete",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent of all values for user link names to delete must match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchDelete",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.batchGet":

type AccountsUserLinksBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets information about multiple users' links to an account
// or property.
//
// - parent: The account or property that all user links in the request
//   are for. The parent of all provided values for the 'names' field
//   must match this field. Example format: accounts/1234.
func (r *AccountsUserLinksService) BatchGet(parent string) *AccountsUserLinksBatchGetCall {
	c := &AccountsUserLinksBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The names of the
// user links to retrieve. A maximum of 1000 user links can be retrieved
// in a batch. Format: accounts/{accountId}/userLinks/{userLinkId}
func (c *AccountsUserLinksBatchGetCall) Names(names ...string) *AccountsUserLinksBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksBatchGetCall) Fields(s ...googleapi.Field) *AccountsUserLinksBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsUserLinksBatchGetCall) IfNoneMatch(entityTag string) *AccountsUserLinksBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksBatchGetCall) Context(ctx context.Context) *AccountsUserLinksBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.batchGet" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:batchGet",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.userLinks.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The names of the user links to retrieve. A maximum of 1000 user links can be retrieved in a batch. Format: accounts/{accountId}/userLinks/{userLinkId}",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent of all provided values for the 'names' field must match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchGet",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.batchUpdate":

type AccountsUserLinksBatchUpdateCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchupdateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchUpdate: Updates information about multiple users' links to an
// account or property.
//
// - parent: The account or property that all user links in the request
//   are for. The parent field in the UpdateUserLinkRequest messages
//   must either be empty or match this field. Example format:
//   accounts/1234.
func (r *AccountsUserLinksService) BatchUpdate(parent string, googleanalyticsadminv1alphabatchupdateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest) *AccountsUserLinksBatchUpdateCall {
	c := &AccountsUserLinksBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchupdateuserlinksrequest = googleanalyticsadminv1alphabatchupdateuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksBatchUpdateCall) Fields(s ...googleapi.Field) *AccountsUserLinksBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksBatchUpdateCall) Context(ctx context.Context) *AccountsUserLinksBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchupdateuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.batchUpdate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.batchUpdate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent field in the UpdateUserLinkRequest messages must either be empty or match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchUpdate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.create":

type AccountsUserLinksCreateCall struct {
	s                                   *Service
	parent                              string
	googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates a user link on an account or property. If the user
// with the specified email already has permissions on the account or
// property, then the user's existing permissions will be unioned with
// the permissions specified in the new UserLink.
//
// - parent: Example format: accounts/1234.
func (r *AccountsUserLinksService) Create(parent string, googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink) *AccountsUserLinksCreateCall {
	c := &AccountsUserLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphauserlink = googleanalyticsadminv1alphauserlink
	return c
}

// NotifyNewUser sets the optional parameter "notifyNewUser": If set,
// then email the new user notifying them that they've been granted
// permissions to the resource.
func (c *AccountsUserLinksCreateCall) NotifyNewUser(notifyNewUser bool) *AccountsUserLinksCreateCall {
	c.urlParams_.Set("notifyNewUser", fmt.Sprint(notifyNewUser))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksCreateCall) Fields(s ...googleapi.Field) *AccountsUserLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksCreateCall) Context(ctx context.Context) *AccountsUserLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphauserlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a user link on an account or property. If the user with the specified email already has permissions on the account or property, then the user's existing permissions will be unioned with the permissions specified in the new UserLink.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "notifyNewUser": {
	//       "description": "Optional. If set, then email the new user notifying them that they've been granted permissions to the resource.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.delete":

type AccountsUserLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a user link on an account or property.
//
// - name: Example format: accounts/1234/userLinks/5678.
func (r *AccountsUserLinksService) Delete(name string) *AccountsUserLinksDeleteCall {
	c := &AccountsUserLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksDeleteCall) Fields(s ...googleapi.Field) *AccountsUserLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksDeleteCall) Context(ctx context.Context) *AccountsUserLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsUserLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a user link on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks/{userLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.accounts.userLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: accounts/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.get":

type AccountsUserLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a user's link to an account or property.
//
// - name: Example format: accounts/1234/userLinks/5678.
func (r *AccountsUserLinksService) Get(name string) *AccountsUserLinksGetCall {
	c := &AccountsUserLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksGetCall) Fields(s ...googleapi.Field) *AccountsUserLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsUserLinksGetCall) IfNoneMatch(entityTag string) *AccountsUserLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksGetCall) Context(ctx context.Context) *AccountsUserLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a user's link to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks/{userLinksId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.userLinks.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: accounts/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.list":

type AccountsUserLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all user links on an account or property.
//
// - parent: Example format: accounts/1234.
func (r *AccountsUserLinksService) List(parent string) *AccountsUserLinksListCall {
	c := &AccountsUserLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of user links to return. The service may return fewer than this
// value. If unspecified, at most 200 user links will be returned. The
// maximum value is 500; values above 500 will be coerced to 500.
func (c *AccountsUserLinksListCall) PageSize(pageSize int64) *AccountsUserLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListUserLinks` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListUserLinks` must match the call that provided the
// page token.
func (c *AccountsUserLinksListCall) PageToken(pageToken string) *AccountsUserLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksListCall) Fields(s ...googleapi.Field) *AccountsUserLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsUserLinksListCall) IfNoneMatch(entityTag string) *AccountsUserLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksListCall) Context(ctx context.Context) *AccountsUserLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListUserLinksResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListUserLinksResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all user links on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.userLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of user links to return. The service may return fewer than this value. If unspecified, at most 200 user links will be returned. The maximum value is 500; values above 500 will be coerced to 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListUserLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListUserLinks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsUserLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListUserLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.accounts.userLinks.patch":

type AccountsUserLinksPatchCall struct {
	s                                   *Service
	name                                string
	googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates a user link on an account or property.
//
// - name: Example format: properties/1234/userLinks/5678.
func (r *AccountsUserLinksService) Patch(name string, googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink) *AccountsUserLinksPatchCall {
	c := &AccountsUserLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphauserlink = googleanalyticsadminv1alphauserlink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksPatchCall) Fields(s ...googleapi.Field) *AccountsUserLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksPatchCall) Context(ctx context.Context) *AccountsUserLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphauserlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a user link on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks/{userLinksId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.accounts.userLinks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Example format: properties/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.create":

type PropertiesCreateCall struct {
	s                                   *Service
	googleanalyticsadminv1alphaproperty *GoogleAnalyticsAdminV1alphaProperty
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates an "GA4" property with the specified location and
// attributes.
func (r *PropertiesService) Create(googleanalyticsadminv1alphaproperty *GoogleAnalyticsAdminV1alphaProperty) *PropertiesCreateCall {
	c := &PropertiesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphaproperty = googleanalyticsadminv1alphaproperty
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCreateCall) Fields(s ...googleapi.Field) *PropertiesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCreateCall) Context(ctx context.Context) *PropertiesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaproperty)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaProperty or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaProperty.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an \"GA4\" property with the specified location and attributes.",
	//   "flatPath": "v1alpha/properties",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.create",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/properties",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.delete":

type PropertiesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Marks target Property as soft-deleted (ie: "trashed") and
// returns it. This API does not have a method to restore soft-deleted
// properties. However, they can be restored using the Trash Can UI. If
// the properties are not restored before the expiration time, the
// Property and all child resources (eg: GoogleAdsLinks, Streams,
// UserLinks) will be permanently purged.
// https://support.google.com/analytics/answer/6154772 Returns an error
// if the target is not found, or is not an GA4 Property.
//
// - name: The name of the Property to soft-delete. Format:
//   properties/{property_id} Example: "properties/1000".
func (r *PropertiesService) Delete(name string) *PropertiesDeleteCall {
	c := &PropertiesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDeleteCall) Fields(s ...googleapi.Field) *PropertiesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDeleteCall) Context(ctx context.Context) *PropertiesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.delete" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaProperty or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaProperty.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks target Property as soft-deleted (ie: \"trashed\") and returns it. This API does not have a method to restore soft-deleted properties. However, they can be restored using the Trash Can UI. If the properties are not restored before the expiration time, the Property and all child resources (eg: GoogleAdsLinks, Streams, UserLinks) will be permanently purged. https://support.google.com/analytics/answer/6154772 Returns an error if the target is not found, or is not an GA4 Property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the Property to soft-delete. Format: properties/{property_id} Example: \"properties/1000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.get":

type PropertiesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single "GA4" Property.
//
// - name: The name of the property to lookup. Format:
//   properties/{property_id} Example: "properties/1000".
func (r *PropertiesService) Get(name string) *PropertiesGetCall {
	c := &PropertiesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGetCall) Fields(s ...googleapi.Field) *PropertiesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesGetCall) IfNoneMatch(entityTag string) *PropertiesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGetCall) Context(ctx context.Context) *PropertiesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaProperty or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaProperty.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single \"GA4\" Property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the property to lookup. Format: properties/{property_id} Example: \"properties/1000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.list":

type PropertiesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns child Properties under the specified parent Account.
// Only "GA4" properties will be returned. Properties will be excluded
// if the caller does not have access. Soft-deleted (ie: "trashed")
// properties are excluded by default. Returns an empty list if no
// relevant properties are found.
func (r *PropertiesService) List() *PropertiesListCall {
	c := &PropertiesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": Required. An expression
// for filtering the results of the request. Fields eligible for
// filtering are: `parent:`(The resource name of the parent account) or
// `firebase_project:`(The id or number of the linked firebase project).
// Some examples of filters: ``` | Filter | Description |
// |-----------------------------|---------------------------------------
// ----| | parent:accounts/123 | The account with account id: 123. | |
// firebase_project:project-id | The firebase project with id:
// project-id. | | firebase_project:123 | The firebase project with
// number: 123. | ```
func (c *PropertiesListCall) Filter(filter string) *PropertiesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. The service may return fewer than this value,
// even if there are additional pages. If unspecified, at most 50
// resources will be returned. The maximum value is 200; (higher values
// will be coerced to the maximum)
func (c *PropertiesListCall) PageSize(pageSize int64) *PropertiesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListProperties` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListProperties` must match the call that provided the
// page token.
func (c *PropertiesListCall) PageToken(pageToken string) *PropertiesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Whether to
// include soft-deleted (ie: "trashed") Properties in the results.
// Properties can be inspected to determine whether they are deleted or
// not.
func (c *PropertiesListCall) ShowDeleted(showDeleted bool) *PropertiesListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesListCall) Fields(s ...googleapi.Field) *PropertiesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesListCall) IfNoneMatch(entityTag string) *PropertiesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesListCall) Context(ctx context.Context) *PropertiesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListPropertiesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListPropertiesResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListPropertiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListPropertiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns child Properties under the specified parent Account. Only \"GA4\" properties will be returned. Properties will be excluded if the caller does not have access. Soft-deleted (ie: \"trashed\") properties are excluded by default. Returns an empty list if no relevant properties are found.",
	//   "flatPath": "v1alpha/properties",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "filter": {
	//       "description": "Required. An expression for filtering the results of the request. Fields eligible for filtering are: `parent:`(The resource name of the parent account) or `firebase_project:`(The id or number of the linked firebase project). Some examples of filters: ``` | Filter | Description | |-----------------------------|-------------------------------------------| | parent:accounts/123 | The account with account id: 123. | | firebase_project:project-id | The firebase project with id: project-id. | | firebase_project:123 | The firebase project with number: 123. | ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListProperties` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListProperties` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "showDeleted": {
	//       "description": "Whether to include soft-deleted (ie: \"trashed\") Properties in the results. Properties can be inspected to determine whether they are deleted or not.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1alpha/properties",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListPropertiesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListPropertiesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.patch":

type PropertiesPatchCall struct {
	s                                   *Service
	name                                string
	googleanalyticsadminv1alphaproperty *GoogleAnalyticsAdminV1alphaProperty
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates a property.
//
// - name: Output only. Resource name of this property. Format:
//   properties/{property_id} Example: "properties/1000".
func (r *PropertiesService) Patch(name string, googleanalyticsadminv1alphaproperty *GoogleAnalyticsAdminV1alphaProperty) *PropertiesPatchCall {
	c := &PropertiesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaproperty = googleanalyticsadminv1alphaproperty
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesPatchCall) UpdateMask(updateMask string) *PropertiesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesPatchCall) Fields(s ...googleapi.Field) *PropertiesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesPatchCall) Context(ctx context.Context) *PropertiesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaproperty)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaProperty or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaProperty.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this property. Format: properties/{property_id} Example: \"properties/1000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.androidAppDataStreams.create":

type PropertiesAndroidAppDataStreamsCreateCall struct {
	s                                               *Service
	parent                                          string
	googleanalyticsadminv1alphaandroidappdatastream *GoogleAnalyticsAdminV1alphaAndroidAppDataStream
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Create: Creates an Android app stream with the specified location and
// attributes. Note that an Android app stream must be linked to a
// Firebase app to receive traffic. To create a working app stream, make
// sure your property is linked to a Firebase project. Then, use the
// Firebase API to create a Firebase app, which will also create an
// appropriate data stream in Analytics (may take up to 24 hours).
//
// - parent: The parent resource where this android app data stream will
//   be created. Format: properties/123.
func (r *PropertiesAndroidAppDataStreamsService) Create(parent string, googleanalyticsadminv1alphaandroidappdatastream *GoogleAnalyticsAdminV1alphaAndroidAppDataStream) *PropertiesAndroidAppDataStreamsCreateCall {
	c := &PropertiesAndroidAppDataStreamsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaandroidappdatastream = googleanalyticsadminv1alphaandroidappdatastream
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAndroidAppDataStreamsCreateCall) Fields(s ...googleapi.Field) *PropertiesAndroidAppDataStreamsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAndroidAppDataStreamsCreateCall) Context(ctx context.Context) *PropertiesAndroidAppDataStreamsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAndroidAppDataStreamsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAndroidAppDataStreamsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaandroidappdatastream)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/androidAppDataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.androidAppDataStreams.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAndroidAppDataStream or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAndroidAppDataStream.ServerResponse.Header
//  or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAndroidAppDataStreamsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAndroidAppDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaAndroidAppDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an Android app stream with the specified location and attributes. Note that an Android app stream must be linked to a Firebase app to receive traffic. To create a working app stream, make sure your property is linked to a Firebase project. Then, use the Firebase API to create a Firebase app, which will also create an appropriate data stream in Analytics (may take up to 24 hours).",
	//   "flatPath": "v1alpha/properties/{propertiesId}/androidAppDataStreams",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.androidAppDataStreams.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource where this android app data stream will be created. Format: properties/123",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/androidAppDataStreams",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAndroidAppDataStream"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAndroidAppDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.androidAppDataStreams.delete":

type PropertiesAndroidAppDataStreamsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an android app stream on a property.
//
// - name: The name of the android app data stream to delete. Format:
//   properties/{property_id}/androidAppDataStreams/{stream_id} Example:
//   "properties/123/androidAppDataStreams/456".
func (r *PropertiesAndroidAppDataStreamsService) Delete(name string) *PropertiesAndroidAppDataStreamsDeleteCall {
	c := &PropertiesAndroidAppDataStreamsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAndroidAppDataStreamsDeleteCall) Fields(s ...googleapi.Field) *PropertiesAndroidAppDataStreamsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAndroidAppDataStreamsDeleteCall) Context(ctx context.Context) *PropertiesAndroidAppDataStreamsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAndroidAppDataStreamsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAndroidAppDataStreamsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.androidAppDataStreams.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesAndroidAppDataStreamsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an android app stream on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/androidAppDataStreams/{androidAppDataStreamsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.androidAppDataStreams.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the android app data stream to delete. Format: properties/{property_id}/androidAppDataStreams/{stream_id} Example: \"properties/123/androidAppDataStreams/456\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/androidAppDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.androidAppDataStreams.get":

type PropertiesAndroidAppDataStreamsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single AndroidAppDataStream
//
// - name: The name of the android app data stream to lookup. Format:
//   properties/{property_id}/androidAppDataStreams/{stream_id} Example:
//   "properties/123/androidAppDataStreams/456".
func (r *PropertiesAndroidAppDataStreamsService) Get(name string) *PropertiesAndroidAppDataStreamsGetCall {
	c := &PropertiesAndroidAppDataStreamsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAndroidAppDataStreamsGetCall) Fields(s ...googleapi.Field) *PropertiesAndroidAppDataStreamsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesAndroidAppDataStreamsGetCall) IfNoneMatch(entityTag string) *PropertiesAndroidAppDataStreamsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAndroidAppDataStreamsGetCall) Context(ctx context.Context) *PropertiesAndroidAppDataStreamsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAndroidAppDataStreamsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAndroidAppDataStreamsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.androidAppDataStreams.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAndroidAppDataStream or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAndroidAppDataStream.ServerResponse.Header
//  or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAndroidAppDataStreamsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAndroidAppDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaAndroidAppDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single AndroidAppDataStream",
	//   "flatPath": "v1alpha/properties/{propertiesId}/androidAppDataStreams/{androidAppDataStreamsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.androidAppDataStreams.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the android app data stream to lookup. Format: properties/{property_id}/androidAppDataStreams/{stream_id} Example: \"properties/123/androidAppDataStreams/456\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/androidAppDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAndroidAppDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.androidAppDataStreams.list":

type PropertiesAndroidAppDataStreamsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns child android app streams under the specified parent
// property. Android app streams will be excluded if the caller does not
// have access. Returns an empty list if no relevant android app streams
// are found.
//
// - parent: The name of the parent property. For example, to limit
//   results to app streams under the property with Id 123:
//   "properties/123".
func (r *PropertiesAndroidAppDataStreamsService) List(parent string) *PropertiesAndroidAppDataStreamsListCall {
	c := &PropertiesAndroidAppDataStreamsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200; (higher values will be coerced to
// the maximum)
func (c *PropertiesAndroidAppDataStreamsListCall) PageSize(pageSize int64) *PropertiesAndroidAppDataStreamsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListAndroidAppDataStreams` must match the call that provided the
// page token.
func (c *PropertiesAndroidAppDataStreamsListCall) PageToken(pageToken string) *PropertiesAndroidAppDataStreamsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAndroidAppDataStreamsListCall) Fields(s ...googleapi.Field) *PropertiesAndroidAppDataStreamsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesAndroidAppDataStreamsListCall) IfNoneMatch(entityTag string) *PropertiesAndroidAppDataStreamsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAndroidAppDataStreamsListCall) Context(ctx context.Context) *PropertiesAndroidAppDataStreamsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAndroidAppDataStreamsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAndroidAppDataStreamsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/androidAppDataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.androidAppDataStreams.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAndroidAppDataStreamsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns child android app streams under the specified parent property. Android app streams will be excluded if the caller does not have access. Returns an empty list if no relevant android app streams are found.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/androidAppDataStreams",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.androidAppDataStreams.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAndroidAppDataStreams` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the parent property. For example, to limit results to app streams under the property with Id 123: \"properties/123\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/androidAppDataStreams",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesAndroidAppDataStreamsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListAndroidAppDataStreamsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.androidAppDataStreams.patch":

type PropertiesAndroidAppDataStreamsPatchCall struct {
	s                                               *Service
	name                                            string
	googleanalyticsadminv1alphaandroidappdatastream *GoogleAnalyticsAdminV1alphaAndroidAppDataStream
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Patch: Updates an android app stream on a property.
//
// - name: Output only. Resource name of this Data Stream. Format:
//   properties/{property_id}/androidAppDataStreams/{stream_id} Example:
//   "properties/1000/androidAppDataStreams/2000".
func (r *PropertiesAndroidAppDataStreamsService) Patch(name string, googleanalyticsadminv1alphaandroidappdatastream *GoogleAnalyticsAdminV1alphaAndroidAppDataStream) *PropertiesAndroidAppDataStreamsPatchCall {
	c := &PropertiesAndroidAppDataStreamsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaandroidappdatastream = googleanalyticsadminv1alphaandroidappdatastream
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesAndroidAppDataStreamsPatchCall) UpdateMask(updateMask string) *PropertiesAndroidAppDataStreamsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAndroidAppDataStreamsPatchCall) Fields(s ...googleapi.Field) *PropertiesAndroidAppDataStreamsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAndroidAppDataStreamsPatchCall) Context(ctx context.Context) *PropertiesAndroidAppDataStreamsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAndroidAppDataStreamsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAndroidAppDataStreamsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaandroidappdatastream)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.androidAppDataStreams.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAndroidAppDataStream or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAndroidAppDataStream.ServerResponse.Header
//  or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAndroidAppDataStreamsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAndroidAppDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaAndroidAppDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an android app stream on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/androidAppDataStreams/{androidAppDataStreamsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.androidAppDataStreams.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this Data Stream. Format: properties/{property_id}/androidAppDataStreams/{stream_id} Example: \"properties/1000/androidAppDataStreams/2000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/androidAppDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAndroidAppDataStream"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAndroidAppDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.firebaseLinks.create":

type PropertiesFirebaseLinksCreateCall struct {
	s                                       *Service
	parent                                  string
	googleanalyticsadminv1alphafirebaselink *GoogleAnalyticsAdminV1alphaFirebaseLink
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Create: Creates a FirebaseLink. Properties can have at most one
// FirebaseLink.
//
// - parent: Format: properties/{property_id} Example: properties/1234.
func (r *PropertiesFirebaseLinksService) Create(parent string, googleanalyticsadminv1alphafirebaselink *GoogleAnalyticsAdminV1alphaFirebaseLink) *PropertiesFirebaseLinksCreateCall {
	c := &PropertiesFirebaseLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphafirebaselink = googleanalyticsadminv1alphafirebaselink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFirebaseLinksCreateCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFirebaseLinksCreateCall) Context(ctx context.Context) *PropertiesFirebaseLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFirebaseLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphafirebaselink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/firebaseLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaFirebaseLink or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaFirebaseLink.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesFirebaseLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaFirebaseLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaFirebaseLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a FirebaseLink. Properties can have at most one FirebaseLink.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/firebaseLinks",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.firebaseLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Format: properties/{property_id} Example: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/firebaseLinks",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFirebaseLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFirebaseLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.firebaseLinks.delete":

type PropertiesFirebaseLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a FirebaseLink on a property
//
// - name: Format:
//   properties/{property_id}/firebaseLinks/{firebase_link_id} Example:
//   properties/1234/firebaseLinks/5678.
func (r *PropertiesFirebaseLinksService) Delete(name string) *PropertiesFirebaseLinksDeleteCall {
	c := &PropertiesFirebaseLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFirebaseLinksDeleteCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFirebaseLinksDeleteCall) Context(ctx context.Context) *PropertiesFirebaseLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFirebaseLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesFirebaseLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a FirebaseLink on a property",
	//   "flatPath": "v1alpha/properties/{propertiesId}/firebaseLinks/{firebaseLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.firebaseLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id} Example: properties/1234/firebaseLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/firebaseLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.firebaseLinks.list":

type PropertiesFirebaseLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists FirebaseLinks on a property. Properties can have at most
// one FirebaseLink.
//
// - parent: Format: properties/{property_id} Example: properties/1234.
func (r *PropertiesFirebaseLinksService) List(parent string) *PropertiesFirebaseLinksListCall {
	c := &PropertiesFirebaseLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. The service may return fewer than this value,
// even if there are additional pages. If unspecified, at most 50
// resources will be returned. The maximum value is 200; (higher values
// will be coerced to the maximum)
func (c *PropertiesFirebaseLinksListCall) PageSize(pageSize int64) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListFirebaseLinks` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListProperties` must match the call that provided the
// page token.
func (c *PropertiesFirebaseLinksListCall) PageToken(pageToken string) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFirebaseLinksListCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesFirebaseLinksListCall) IfNoneMatch(entityTag string) *PropertiesFirebaseLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFirebaseLinksListCall) Context(ctx context.Context) *PropertiesFirebaseLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFirebaseLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/firebaseLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesFirebaseLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists FirebaseLinks on a property. Properties can have at most one FirebaseLink.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/firebaseLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.firebaseLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListFirebaseLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListProperties` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Format: properties/{property_id} Example: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/firebaseLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesFirebaseLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.firebaseLinks.patch":

type PropertiesFirebaseLinksPatchCall struct {
	s                                       *Service
	name                                    string
	googleanalyticsadminv1alphafirebaselink *GoogleAnalyticsAdminV1alphaFirebaseLink
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Updates a FirebaseLink on a property
//
// - name: Output only. Example format:
//   properties/1234/firebaseLinks/5678.
func (r *PropertiesFirebaseLinksService) Patch(name string, googleanalyticsadminv1alphafirebaselink *GoogleAnalyticsAdminV1alphaFirebaseLink) *PropertiesFirebaseLinksPatchCall {
	c := &PropertiesFirebaseLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphafirebaselink = googleanalyticsadminv1alphafirebaselink
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesFirebaseLinksPatchCall) UpdateMask(updateMask string) *PropertiesFirebaseLinksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFirebaseLinksPatchCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFirebaseLinksPatchCall) Context(ctx context.Context) *PropertiesFirebaseLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFirebaseLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphafirebaselink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaFirebaseLink or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaFirebaseLink.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesFirebaseLinksPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaFirebaseLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaFirebaseLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a FirebaseLink on a property",
	//   "flatPath": "v1alpha/properties/{propertiesId}/firebaseLinks/{firebaseLinksId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.firebaseLinks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Example format: properties/1234/firebaseLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/firebaseLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFirebaseLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFirebaseLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.googleAdsLinks.create":

type PropertiesGoogleAdsLinksCreateCall struct {
	s                                        *Service
	parent                                   string
	googleanalyticsadminv1alphagoogleadslink *GoogleAnalyticsAdminV1alphaGoogleAdsLink
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates a GoogleAdsLink.
//
// - parent: Example format: properties/1234.
func (r *PropertiesGoogleAdsLinksService) Create(parent string, googleanalyticsadminv1alphagoogleadslink *GoogleAnalyticsAdminV1alphaGoogleAdsLink) *PropertiesGoogleAdsLinksCreateCall {
	c := &PropertiesGoogleAdsLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphagoogleadslink = googleanalyticsadminv1alphagoogleadslink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGoogleAdsLinksCreateCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGoogleAdsLinksCreateCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGoogleAdsLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphagoogleadslink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/googleAdsLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaGoogleAdsLink or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaGoogleAdsLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGoogleAdsLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaGoogleAdsLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaGoogleAdsLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a GoogleAdsLink.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleAdsLinks",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.googleAdsLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/googleAdsLinks",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleAdsLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleAdsLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.googleAdsLinks.delete":

type PropertiesGoogleAdsLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a GoogleAdsLink on a property
//
// - name: Example format: properties/1234/googleAdsLinks/5678.
func (r *PropertiesGoogleAdsLinksService) Delete(name string) *PropertiesGoogleAdsLinksDeleteCall {
	c := &PropertiesGoogleAdsLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGoogleAdsLinksDeleteCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGoogleAdsLinksDeleteCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGoogleAdsLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesGoogleAdsLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a GoogleAdsLink on a property",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleAdsLinks/{googleAdsLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.googleAdsLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: properties/1234/googleAdsLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/googleAdsLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.googleAdsLinks.list":

type PropertiesGoogleAdsLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists GoogleAdsLinks on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesGoogleAdsLinksService) List(parent string) *PropertiesGoogleAdsLinksListCall {
	c := &PropertiesGoogleAdsLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesGoogleAdsLinksListCall) PageSize(pageSize int64) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListGoogleAdsLinks` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListGoogleAdsLinks` must match the call that provided
// the page token.
func (c *PropertiesGoogleAdsLinksListCall) PageToken(pageToken string) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGoogleAdsLinksListCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesGoogleAdsLinksListCall) IfNoneMatch(entityTag string) *PropertiesGoogleAdsLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGoogleAdsLinksListCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGoogleAdsLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/googleAdsLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGoogleAdsLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists GoogleAdsLinks on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleAdsLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.googleAdsLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListGoogleAdsLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListGoogleAdsLinks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/googleAdsLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesGoogleAdsLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.googleAdsLinks.patch":

type PropertiesGoogleAdsLinksPatchCall struct {
	s                                        *Service
	name                                     string
	googleanalyticsadminv1alphagoogleadslink *GoogleAnalyticsAdminV1alphaGoogleAdsLink
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates a GoogleAdsLink on a property
//
// - name: Output only. Format:
//   properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
//   googleAdsLinkId is not the Google Ads customer ID.
func (r *PropertiesGoogleAdsLinksService) Patch(name string, googleanalyticsadminv1alphagoogleadslink *GoogleAnalyticsAdminV1alphaGoogleAdsLink) *PropertiesGoogleAdsLinksPatchCall {
	c := &PropertiesGoogleAdsLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphagoogleadslink = googleanalyticsadminv1alphagoogleadslink
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesGoogleAdsLinksPatchCall) UpdateMask(updateMask string) *PropertiesGoogleAdsLinksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGoogleAdsLinksPatchCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGoogleAdsLinksPatchCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGoogleAdsLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphagoogleadslink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaGoogleAdsLink or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaGoogleAdsLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGoogleAdsLinksPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaGoogleAdsLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaGoogleAdsLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a GoogleAdsLink on a property",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleAdsLinks/{googleAdsLinksId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.googleAdsLinks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note: googleAdsLinkId is not the Google Ads customer ID.",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/googleAdsLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleAdsLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleAdsLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.iosAppDataStreams.create":

type PropertiesIosAppDataStreamsCreateCall struct {
	s                                           *Service
	parent                                      string
	googleanalyticsadminv1alphaiosappdatastream *GoogleAnalyticsAdminV1alphaIosAppDataStream
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Create: Creates an iOS app stream with the specified location and
// attributes. Note that an iOS app stream must be linked to a Firebase
// app to receive traffic. To create a working app stream, make sure
// your property is linked to a Firebase project. Then, use the Firebase
// API to create a Firebase app, which will also create an appropriate
// data stream in Analytics (may take up to 24 hours).
//
// - parent: The parent resource where this ios app data stream will be
//   created. Format: properties/123.
func (r *PropertiesIosAppDataStreamsService) Create(parent string, googleanalyticsadminv1alphaiosappdatastream *GoogleAnalyticsAdminV1alphaIosAppDataStream) *PropertiesIosAppDataStreamsCreateCall {
	c := &PropertiesIosAppDataStreamsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaiosappdatastream = googleanalyticsadminv1alphaiosappdatastream
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesIosAppDataStreamsCreateCall) Fields(s ...googleapi.Field) *PropertiesIosAppDataStreamsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesIosAppDataStreamsCreateCall) Context(ctx context.Context) *PropertiesIosAppDataStreamsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesIosAppDataStreamsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesIosAppDataStreamsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaiosappdatastream)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/iosAppDataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.iosAppDataStreams.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaIosAppDataStream or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaIosAppDataStream.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesIosAppDataStreamsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaIosAppDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaIosAppDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an iOS app stream with the specified location and attributes. Note that an iOS app stream must be linked to a Firebase app to receive traffic. To create a working app stream, make sure your property is linked to a Firebase project. Then, use the Firebase API to create a Firebase app, which will also create an appropriate data stream in Analytics (may take up to 24 hours).",
	//   "flatPath": "v1alpha/properties/{propertiesId}/iosAppDataStreams",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.iosAppDataStreams.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource where this ios app data stream will be created. Format: properties/123",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/iosAppDataStreams",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaIosAppDataStream"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaIosAppDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.iosAppDataStreams.delete":

type PropertiesIosAppDataStreamsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an iOS app stream on a property.
//
// - name: The name of the iOS app data stream to delete. Format:
//   properties/{property_id}/iosAppDataStreams/{stream_id} Example:
//   "properties/123/iosAppDataStreams/456".
func (r *PropertiesIosAppDataStreamsService) Delete(name string) *PropertiesIosAppDataStreamsDeleteCall {
	c := &PropertiesIosAppDataStreamsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesIosAppDataStreamsDeleteCall) Fields(s ...googleapi.Field) *PropertiesIosAppDataStreamsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesIosAppDataStreamsDeleteCall) Context(ctx context.Context) *PropertiesIosAppDataStreamsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesIosAppDataStreamsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesIosAppDataStreamsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.iosAppDataStreams.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesIosAppDataStreamsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an iOS app stream on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/iosAppDataStreams/{iosAppDataStreamsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.iosAppDataStreams.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the iOS app data stream to delete. Format: properties/{property_id}/iosAppDataStreams/{stream_id} Example: \"properties/123/iosAppDataStreams/456\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/iosAppDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.iosAppDataStreams.get":

type PropertiesIosAppDataStreamsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single IosAppDataStream
//
// - name: The name of the iOS app data stream to lookup. Format:
//   properties/{property_id}/iosAppDataStreams/{stream_id} Example:
//   "properties/123/iosAppDataStreams/456".
func (r *PropertiesIosAppDataStreamsService) Get(name string) *PropertiesIosAppDataStreamsGetCall {
	c := &PropertiesIosAppDataStreamsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesIosAppDataStreamsGetCall) Fields(s ...googleapi.Field) *PropertiesIosAppDataStreamsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesIosAppDataStreamsGetCall) IfNoneMatch(entityTag string) *PropertiesIosAppDataStreamsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesIosAppDataStreamsGetCall) Context(ctx context.Context) *PropertiesIosAppDataStreamsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesIosAppDataStreamsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesIosAppDataStreamsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.iosAppDataStreams.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaIosAppDataStream or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaIosAppDataStream.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesIosAppDataStreamsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaIosAppDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaIosAppDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single IosAppDataStream",
	//   "flatPath": "v1alpha/properties/{propertiesId}/iosAppDataStreams/{iosAppDataStreamsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.iosAppDataStreams.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the iOS app data stream to lookup. Format: properties/{property_id}/iosAppDataStreams/{stream_id} Example: \"properties/123/iosAppDataStreams/456\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/iosAppDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaIosAppDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.iosAppDataStreams.list":

type PropertiesIosAppDataStreamsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns child iOS app data streams under the specified parent
// property. iOS app data streams will be excluded if the caller does
// not have access. Returns an empty list if no relevant iOS app data
// streams are found.
//
// - parent: The name of the parent property. For example, to list
//   results of app streams under the property with Id 123:
//   "properties/123".
func (r *PropertiesIosAppDataStreamsService) List(parent string) *PropertiesIosAppDataStreamsListCall {
	c := &PropertiesIosAppDataStreamsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200; (higher values will be coerced to
// the maximum)
func (c *PropertiesIosAppDataStreamsListCall) PageSize(pageSize int64) *PropertiesIosAppDataStreamsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListIosAppDataStreams` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListIosAppDataStreams` must match the call
// that provided the page token.
func (c *PropertiesIosAppDataStreamsListCall) PageToken(pageToken string) *PropertiesIosAppDataStreamsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesIosAppDataStreamsListCall) Fields(s ...googleapi.Field) *PropertiesIosAppDataStreamsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesIosAppDataStreamsListCall) IfNoneMatch(entityTag string) *PropertiesIosAppDataStreamsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesIosAppDataStreamsListCall) Context(ctx context.Context) *PropertiesIosAppDataStreamsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesIosAppDataStreamsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesIosAppDataStreamsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/iosAppDataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.iosAppDataStreams.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesIosAppDataStreamsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns child iOS app data streams under the specified parent property. iOS app data streams will be excluded if the caller does not have access. Returns an empty list if no relevant iOS app data streams are found.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/iosAppDataStreams",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.iosAppDataStreams.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListIosAppDataStreams` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListIosAppDataStreams` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the parent property. For example, to list results of app streams under the property with Id 123: \"properties/123\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/iosAppDataStreams",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesIosAppDataStreamsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListIosAppDataStreamsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.iosAppDataStreams.patch":

type PropertiesIosAppDataStreamsPatchCall struct {
	s                                           *Service
	name                                        string
	googleanalyticsadminv1alphaiosappdatastream *GoogleAnalyticsAdminV1alphaIosAppDataStream
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates an iOS app stream on a property.
//
// - name: Output only. Resource name of this Data Stream. Format:
//   properties/{property_id}/iosAppDataStreams/{stream_id} Example:
//   "properties/1000/iosAppDataStreams/2000".
func (r *PropertiesIosAppDataStreamsService) Patch(name string, googleanalyticsadminv1alphaiosappdatastream *GoogleAnalyticsAdminV1alphaIosAppDataStream) *PropertiesIosAppDataStreamsPatchCall {
	c := &PropertiesIosAppDataStreamsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaiosappdatastream = googleanalyticsadminv1alphaiosappdatastream
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesIosAppDataStreamsPatchCall) UpdateMask(updateMask string) *PropertiesIosAppDataStreamsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesIosAppDataStreamsPatchCall) Fields(s ...googleapi.Field) *PropertiesIosAppDataStreamsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesIosAppDataStreamsPatchCall) Context(ctx context.Context) *PropertiesIosAppDataStreamsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesIosAppDataStreamsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesIosAppDataStreamsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaiosappdatastream)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.iosAppDataStreams.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaIosAppDataStream or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaIosAppDataStream.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesIosAppDataStreamsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaIosAppDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaIosAppDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an iOS app stream on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/iosAppDataStreams/{iosAppDataStreamsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.iosAppDataStreams.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this Data Stream. Format: properties/{property_id}/iosAppDataStreams/{stream_id} Example: \"properties/1000/iosAppDataStreams/2000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/iosAppDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaIosAppDataStream"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaIosAppDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.userLinks.audit":

type PropertiesUserLinksAuditCall struct {
	s                                                *Service
	parent                                           string
	googleanalyticsadminv1alphaaudituserlinksrequest *GoogleAnalyticsAdminV1alphaAuditUserLinksRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Audit: Lists all user links on an account or property, including
// implicit ones that come from effective permissions granted by groups
// or organization admin roles. If a returned user link does not have
// direct permissions, they cannot be removed from the account or
// property directly with the DeleteUserLink command. They have to be
// removed from the group/etc that gives them permissions, which is
// currently only usable/discoverable in the GA or GMP UIs.
//
// - parent: Example format: accounts/1234.
func (r *PropertiesUserLinksService) Audit(parent string, googleanalyticsadminv1alphaaudituserlinksrequest *GoogleAnalyticsAdminV1alphaAuditUserLinksRequest) *PropertiesUserLinksAuditCall {
	c := &PropertiesUserLinksAuditCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaaudituserlinksrequest = googleanalyticsadminv1alphaaudituserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksAuditCall) Fields(s ...googleapi.Field) *PropertiesUserLinksAuditCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksAuditCall) Context(ctx context.Context) *PropertiesUserLinksAuditCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksAuditCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksAuditCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaudituserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:audit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.audit" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAuditUserLinksResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAuditUserLinksResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUserLinksAuditCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAuditUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaAuditUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all user links on an account or property, including implicit ones that come from effective permissions granted by groups or organization admin roles. If a returned user link does not have direct permissions, they cannot be removed from the account or property directly with the DeleteUserLink command. They have to be removed from the group/etc that gives them permissions, which is currently only usable/discoverable in the GA or GMP UIs.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks:audit",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.userLinks.audit",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:audit",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAuditUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAuditUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesUserLinksAuditCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaAuditUserLinksResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken = pt }(c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken = x.NextPageToken
	}
}

// method id "analyticsadmin.properties.userLinks.batchCreate":

type PropertiesUserLinksBatchCreateCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchcreateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchCreate: Creates information about multiple users' links to an
// account or property. This method is transactional. If any UserLink
// cannot be created, none of the UserLinks will be created.
//
// - parent: The account or property that all user links in the request
//   are for. This field is required. The parent field in the
//   CreateUserLinkRequest messages must either be empty or match this
//   field. Example format: accounts/1234.
func (r *PropertiesUserLinksService) BatchCreate(parent string, googleanalyticsadminv1alphabatchcreateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest) *PropertiesUserLinksBatchCreateCall {
	c := &PropertiesUserLinksBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchcreateuserlinksrequest = googleanalyticsadminv1alphabatchcreateuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksBatchCreateCall) Fields(s ...googleapi.Field) *PropertiesUserLinksBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksBatchCreateCall) Context(ctx context.Context) *PropertiesUserLinksBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchcreateuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.batchCreate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUserLinksBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates information about multiple users' links to an account or property. This method is transactional. If any UserLink cannot be created, none of the UserLinks will be created.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks:batchCreate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.userLinks.batchCreate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. This field is required. The parent field in the CreateUserLinkRequest messages must either be empty or match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchCreate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.userLinks.batchDelete":

type PropertiesUserLinksBatchDeleteCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchdeleteuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchDelete: Deletes information about multiple users' links to an
// account or property.
//
// - parent: The account or property that all user links in the request
//   are for. The parent of all values for user link names to delete
//   must match this field. Example format: accounts/1234.
func (r *PropertiesUserLinksService) BatchDelete(parent string, googleanalyticsadminv1alphabatchdeleteuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest) *PropertiesUserLinksBatchDeleteCall {
	c := &PropertiesUserLinksBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchdeleteuserlinksrequest = googleanalyticsadminv1alphabatchdeleteuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksBatchDeleteCall) Fields(s ...googleapi.Field) *PropertiesUserLinksBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksBatchDeleteCall) Context(ctx context.Context) *PropertiesUserLinksBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchdeleteuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.batchDelete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesUserLinksBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks:batchDelete",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.userLinks.batchDelete",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent of all values for user link names to delete must match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchDelete",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.userLinks.batchGet":

type PropertiesUserLinksBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets information about multiple users' links to an account
// or property.
//
// - parent: The account or property that all user links in the request
//   are for. The parent of all provided values for the 'names' field
//   must match this field. Example format: accounts/1234.
func (r *PropertiesUserLinksService) BatchGet(parent string) *PropertiesUserLinksBatchGetCall {
	c := &PropertiesUserLinksBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The names of the
// user links to retrieve. A maximum of 1000 user links can be retrieved
// in a batch. Format: accounts/{accountId}/userLinks/{userLinkId}
func (c *PropertiesUserLinksBatchGetCall) Names(names ...string) *PropertiesUserLinksBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksBatchGetCall) Fields(s ...googleapi.Field) *PropertiesUserLinksBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesUserLinksBatchGetCall) IfNoneMatch(entityTag string) *PropertiesUserLinksBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksBatchGetCall) Context(ctx context.Context) *PropertiesUserLinksBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.batchGet" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUserLinksBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks:batchGet",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.userLinks.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The names of the user links to retrieve. A maximum of 1000 user links can be retrieved in a batch. Format: accounts/{accountId}/userLinks/{userLinkId}",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent of all provided values for the 'names' field must match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchGet",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.userLinks.batchUpdate":

type PropertiesUserLinksBatchUpdateCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchupdateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchUpdate: Updates information about multiple users' links to an
// account or property.
//
// - parent: The account or property that all user links in the request
//   are for. The parent field in the UpdateUserLinkRequest messages
//   must either be empty or match this field. Example format:
//   accounts/1234.
func (r *PropertiesUserLinksService) BatchUpdate(parent string, googleanalyticsadminv1alphabatchupdateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest) *PropertiesUserLinksBatchUpdateCall {
	c := &PropertiesUserLinksBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchupdateuserlinksrequest = googleanalyticsadminv1alphabatchupdateuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksBatchUpdateCall) Fields(s ...googleapi.Field) *PropertiesUserLinksBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksBatchUpdateCall) Context(ctx context.Context) *PropertiesUserLinksBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchupdateuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.batchUpdate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUserLinksBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.userLinks.batchUpdate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent field in the UpdateUserLinkRequest messages must either be empty or match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchUpdate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.userLinks.create":

type PropertiesUserLinksCreateCall struct {
	s                                   *Service
	parent                              string
	googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates a user link on an account or property. If the user
// with the specified email already has permissions on the account or
// property, then the user's existing permissions will be unioned with
// the permissions specified in the new UserLink.
//
// - parent: Example format: accounts/1234.
func (r *PropertiesUserLinksService) Create(parent string, googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink) *PropertiesUserLinksCreateCall {
	c := &PropertiesUserLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphauserlink = googleanalyticsadminv1alphauserlink
	return c
}

// NotifyNewUser sets the optional parameter "notifyNewUser": If set,
// then email the new user notifying them that they've been granted
// permissions to the resource.
func (c *PropertiesUserLinksCreateCall) NotifyNewUser(notifyNewUser bool) *PropertiesUserLinksCreateCall {
	c.urlParams_.Set("notifyNewUser", fmt.Sprint(notifyNewUser))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksCreateCall) Fields(s ...googleapi.Field) *PropertiesUserLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksCreateCall) Context(ctx context.Context) *PropertiesUserLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphauserlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUserLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a user link on an account or property. If the user with the specified email already has permissions on the account or property, then the user's existing permissions will be unioned with the permissions specified in the new UserLink.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.userLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "notifyNewUser": {
	//       "description": "Optional. If set, then email the new user notifying them that they've been granted permissions to the resource.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.userLinks.delete":

type PropertiesUserLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a user link on an account or property.
//
// - name: Example format: accounts/1234/userLinks/5678.
func (r *PropertiesUserLinksService) Delete(name string) *PropertiesUserLinksDeleteCall {
	c := &PropertiesUserLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksDeleteCall) Fields(s ...googleapi.Field) *PropertiesUserLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksDeleteCall) Context(ctx context.Context) *PropertiesUserLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesUserLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a user link on an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks/{userLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.userLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: accounts/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.userLinks.get":

type PropertiesUserLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a user's link to an account or property.
//
// - name: Example format: accounts/1234/userLinks/5678.
func (r *PropertiesUserLinksService) Get(name string) *PropertiesUserLinksGetCall {
	c := &PropertiesUserLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksGetCall) Fields(s ...googleapi.Field) *PropertiesUserLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesUserLinksGetCall) IfNoneMatch(entityTag string) *PropertiesUserLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksGetCall) Context(ctx context.Context) *PropertiesUserLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUserLinksGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a user's link to an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks/{userLinksId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.userLinks.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: accounts/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.userLinks.list":

type PropertiesUserLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all user links on an account or property.
//
// - parent: Example format: accounts/1234.
func (r *PropertiesUserLinksService) List(parent string) *PropertiesUserLinksListCall {
	c := &PropertiesUserLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of user links to return. The service may return fewer than this
// value. If unspecified, at most 200 user links will be returned. The
// maximum value is 500; values above 500 will be coerced to 500.
func (c *PropertiesUserLinksListCall) PageSize(pageSize int64) *PropertiesUserLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListUserLinks` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListUserLinks` must match the call that provided the
// page token.
func (c *PropertiesUserLinksListCall) PageToken(pageToken string) *PropertiesUserLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksListCall) Fields(s ...googleapi.Field) *PropertiesUserLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesUserLinksListCall) IfNoneMatch(entityTag string) *PropertiesUserLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksListCall) Context(ctx context.Context) *PropertiesUserLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListUserLinksResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListUserLinksResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUserLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all user links on an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.userLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of user links to return. The service may return fewer than this value. If unspecified, at most 200 user links will be returned. The maximum value is 500; values above 500 will be coerced to 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListUserLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListUserLinks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesUserLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListUserLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.userLinks.patch":

type PropertiesUserLinksPatchCall struct {
	s                                   *Service
	name                                string
	googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates a user link on an account or property.
//
// - name: Example format: properties/1234/userLinks/5678.
func (r *PropertiesUserLinksService) Patch(name string, googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink) *PropertiesUserLinksPatchCall {
	c := &PropertiesUserLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphauserlink = googleanalyticsadminv1alphauserlink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUserLinksPatchCall) Fields(s ...googleapi.Field) *PropertiesUserLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUserLinksPatchCall) Context(ctx context.Context) *PropertiesUserLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUserLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUserLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphauserlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.userLinks.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUserLinksPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a user link on an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/userLinks/{userLinksId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.userLinks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Example format: properties/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.webDataStreams.create":

type PropertiesWebDataStreamsCreateCall struct {
	s                                        *Service
	parent                                   string
	googleanalyticsadminv1alphawebdatastream *GoogleAnalyticsAdminV1alphaWebDataStream
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates a web stream with the specified location and
// attributes.
//
// - parent: The parent resource where this web data stream will be
//   created. Format: properties/123.
func (r *PropertiesWebDataStreamsService) Create(parent string, googleanalyticsadminv1alphawebdatastream *GoogleAnalyticsAdminV1alphaWebDataStream) *PropertiesWebDataStreamsCreateCall {
	c := &PropertiesWebDataStreamsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphawebdatastream = googleanalyticsadminv1alphawebdatastream
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesWebDataStreamsCreateCall) Fields(s ...googleapi.Field) *PropertiesWebDataStreamsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesWebDataStreamsCreateCall) Context(ctx context.Context) *PropertiesWebDataStreamsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesWebDataStreamsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesWebDataStreamsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphawebdatastream)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/webDataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.webDataStreams.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaWebDataStream or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaWebDataStream.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesWebDataStreamsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaWebDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaWebDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a web stream with the specified location and attributes.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/webDataStreams",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.webDataStreams.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource where this web data stream will be created. Format: properties/123",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/webDataStreams",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaWebDataStream"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaWebDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.webDataStreams.delete":

type PropertiesWebDataStreamsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a web stream on a property.
//
// - name: The name of the web data stream to delete. Format:
//   properties/{property_id}/webDataStreams/{stream_id} Example:
//   "properties/123/webDataStreams/456".
func (r *PropertiesWebDataStreamsService) Delete(name string) *PropertiesWebDataStreamsDeleteCall {
	c := &PropertiesWebDataStreamsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesWebDataStreamsDeleteCall) Fields(s ...googleapi.Field) *PropertiesWebDataStreamsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesWebDataStreamsDeleteCall) Context(ctx context.Context) *PropertiesWebDataStreamsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesWebDataStreamsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesWebDataStreamsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.webDataStreams.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesWebDataStreamsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a web stream on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/webDataStreams/{webDataStreamsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.webDataStreams.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the web data stream to delete. Format: properties/{property_id}/webDataStreams/{stream_id} Example: \"properties/123/webDataStreams/456\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/webDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.webDataStreams.get":

type PropertiesWebDataStreamsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single WebDataStream
//
// - name: The name of the web data stream to lookup. Format:
//   properties/{property_id}/webDataStreams/{stream_id} Example:
//   "properties/123/webDataStreams/456".
func (r *PropertiesWebDataStreamsService) Get(name string) *PropertiesWebDataStreamsGetCall {
	c := &PropertiesWebDataStreamsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesWebDataStreamsGetCall) Fields(s ...googleapi.Field) *PropertiesWebDataStreamsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesWebDataStreamsGetCall) IfNoneMatch(entityTag string) *PropertiesWebDataStreamsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesWebDataStreamsGetCall) Context(ctx context.Context) *PropertiesWebDataStreamsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesWebDataStreamsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesWebDataStreamsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.webDataStreams.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaWebDataStream or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaWebDataStream.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesWebDataStreamsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaWebDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaWebDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single WebDataStream",
	//   "flatPath": "v1alpha/properties/{propertiesId}/webDataStreams/{webDataStreamsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.webDataStreams.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the web data stream to lookup. Format: properties/{property_id}/webDataStreams/{stream_id} Example: \"properties/123/webDataStreams/456\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/webDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaWebDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.webDataStreams.getEnhancedMeasurementSettings":

type PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEnhancedMeasurementSettings: Returns the singleton enhanced
// measurement settings for this web stream. Note that the stream must
// enable enhanced measurement for these settings to take effect.
//
// - name: The name of the settings to lookup. Format:
//   properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasurem
//   entSettings Example:
//   "properties/1000/webDataStreams/2000/enhancedMeasurementSettings".
func (r *PropertiesWebDataStreamsService) GetEnhancedMeasurementSettings(name string) *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall {
	c := &PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall) Fields(s ...googleapi.Field) *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall) IfNoneMatch(entityTag string) *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall) Context(ctx context.Context) *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.webDataStreams.getEnhancedMeasurementSettings" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesWebDataStreamsGetEnhancedMeasurementSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the singleton enhanced measurement settings for this web stream. Note that the stream must enable enhanced measurement for these settings to take effect.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/webDataStreams/{webDataStreamsId}/enhancedMeasurementSettings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.webDataStreams.getEnhancedMeasurementSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the settings to lookup. Format: properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasurementSettings Example: \"properties/1000/webDataStreams/2000/enhancedMeasurementSettings\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/webDataStreams/[^/]+/enhancedMeasurementSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.webDataStreams.getGlobalSiteTag":

type PropertiesWebDataStreamsGetGlobalSiteTagCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetGlobalSiteTag: Returns the Site Tag for the specified web stream.
// Site Tags are immutable singletons.
//
// - name: The name of the site tag to lookup. Note that site tags are
//   singletons and do not have unique IDs. Format:
//   properties/{property_id}/webDataStreams/{stream_id}/globalSiteTag
//   Example: "properties/123/webDataStreams/456/globalSiteTag".
func (r *PropertiesWebDataStreamsService) GetGlobalSiteTag(name string) *PropertiesWebDataStreamsGetGlobalSiteTagCall {
	c := &PropertiesWebDataStreamsGetGlobalSiteTagCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesWebDataStreamsGetGlobalSiteTagCall) Fields(s ...googleapi.Field) *PropertiesWebDataStreamsGetGlobalSiteTagCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesWebDataStreamsGetGlobalSiteTagCall) IfNoneMatch(entityTag string) *PropertiesWebDataStreamsGetGlobalSiteTagCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesWebDataStreamsGetGlobalSiteTagCall) Context(ctx context.Context) *PropertiesWebDataStreamsGetGlobalSiteTagCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesWebDataStreamsGetGlobalSiteTagCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesWebDataStreamsGetGlobalSiteTagCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.webDataStreams.getGlobalSiteTag" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaGlobalSiteTag or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaGlobalSiteTag.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesWebDataStreamsGetGlobalSiteTagCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaGlobalSiteTag, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaGlobalSiteTag{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the Site Tag for the specified web stream. Site Tags are immutable singletons.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/webDataStreams/{webDataStreamsId}/globalSiteTag",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.webDataStreams.getGlobalSiteTag",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the site tag to lookup. Note that site tags are singletons and do not have unique IDs. Format: properties/{property_id}/webDataStreams/{stream_id}/globalSiteTag Example: \"properties/123/webDataStreams/456/globalSiteTag\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/webDataStreams/[^/]+/globalSiteTag$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGlobalSiteTag"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.webDataStreams.list":

type PropertiesWebDataStreamsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns child web data streams under the specified parent
// property. Web data streams will be excluded if the caller does not
// have access. Returns an empty list if no relevant web data streams
// are found.
//
// - parent: The name of the parent property. For example, to list
//   results of web streams under the property with Id 123:
//   "properties/123".
func (r *PropertiesWebDataStreamsService) List(parent string) *PropertiesWebDataStreamsListCall {
	c := &PropertiesWebDataStreamsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200; (higher values will be coerced to
// the maximum)
func (c *PropertiesWebDataStreamsListCall) PageSize(pageSize int64) *PropertiesWebDataStreamsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListWebDataStreams` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListWebDataStreams` must match the call that provided
// the page token.
func (c *PropertiesWebDataStreamsListCall) PageToken(pageToken string) *PropertiesWebDataStreamsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesWebDataStreamsListCall) Fields(s ...googleapi.Field) *PropertiesWebDataStreamsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesWebDataStreamsListCall) IfNoneMatch(entityTag string) *PropertiesWebDataStreamsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesWebDataStreamsListCall) Context(ctx context.Context) *PropertiesWebDataStreamsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesWebDataStreamsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesWebDataStreamsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/webDataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.webDataStreams.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesWebDataStreamsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns child web data streams under the specified parent property. Web data streams will be excluded if the caller does not have access. Returns an empty list if no relevant web data streams are found.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/webDataStreams",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.webDataStreams.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListWebDataStreams` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListWebDataStreams` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the parent property. For example, to list results of web streams under the property with Id 123: \"properties/123\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/webDataStreams",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesWebDataStreamsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListWebDataStreamsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.webDataStreams.patch":

type PropertiesWebDataStreamsPatchCall struct {
	s                                        *Service
	name                                     string
	googleanalyticsadminv1alphawebdatastream *GoogleAnalyticsAdminV1alphaWebDataStream
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates a web stream on a property.
//
// - name: Output only. Resource name of this Data Stream. Format:
//   properties/{property_id}/webDataStreams/{stream_id} Example:
//   "properties/1000/webDataStreams/2000".
func (r *PropertiesWebDataStreamsService) Patch(name string, googleanalyticsadminv1alphawebdatastream *GoogleAnalyticsAdminV1alphaWebDataStream) *PropertiesWebDataStreamsPatchCall {
	c := &PropertiesWebDataStreamsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphawebdatastream = googleanalyticsadminv1alphawebdatastream
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesWebDataStreamsPatchCall) UpdateMask(updateMask string) *PropertiesWebDataStreamsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesWebDataStreamsPatchCall) Fields(s ...googleapi.Field) *PropertiesWebDataStreamsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesWebDataStreamsPatchCall) Context(ctx context.Context) *PropertiesWebDataStreamsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesWebDataStreamsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesWebDataStreamsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphawebdatastream)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.webDataStreams.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaWebDataStream or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaWebDataStream.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesWebDataStreamsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaWebDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaWebDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a web stream on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/webDataStreams/{webDataStreamsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.webDataStreams.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this Data Stream. Format: properties/{property_id}/webDataStreams/{stream_id} Example: \"properties/1000/webDataStreams/2000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/webDataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaWebDataStream"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaWebDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.webDataStreams.updateEnhancedMeasurementSettings":

type PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall struct {
	s                                                      *Service
	name                                                   string
	googleanalyticsadminv1alphaenhancedmeasurementsettings *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// UpdateEnhancedMeasurementSettings: Updates the singleton enhanced
// measurement settings for this web stream. Note that the stream must
// enable enhanced measurement for these settings to take effect.
//
// - name: Output only. Resource name of this Data Stream. Format:
//   properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasurem
//   entSettings Example:
//   "properties/1000/webDataStreams/2000/enhancedMeasurementSettings".
func (r *PropertiesWebDataStreamsService) UpdateEnhancedMeasurementSettings(name string, googleanalyticsadminv1alphaenhancedmeasurementsettings *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings) *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall {
	c := &PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaenhancedmeasurementsettings = googleanalyticsadminv1alphaenhancedmeasurementsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall) UpdateMask(updateMask string) *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall) Fields(s ...googleapi.Field) *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall) Context(ctx context.Context) *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210410")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaenhancedmeasurementsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.webDataStreams.updateEnhancedMeasurementSettings" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesWebDataStreamsUpdateEnhancedMeasurementSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the singleton enhanced measurement settings for this web stream. Note that the stream must enable enhanced measurement for these settings to take effect.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/webDataStreams/{webDataStreamsId}/enhancedMeasurementSettings",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.webDataStreams.updateEnhancedMeasurementSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this Data Stream. Format: properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasurementSettings Example: \"properties/1000/webDataStreams/2000/enhancedMeasurementSettings\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/webDataStreams/[^/]+/enhancedMeasurementSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}
