// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/ml/v1beta1/model_service.proto
// DO NOT EDIT!

package google_cloud_ml_v1beta1 // import "google.golang.org/genproto/googleapis/cloud/ml/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import _ "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Represents a machine learning solution.
//
// A model can have multiple versions, each of which is a deployed, trained
// model ready to receive prediction requests. The model itself is just a
// container.
type Model struct {
	// Required. The name specified for the model when it was created.
	//
	// The model name must be unique within the project it is created in.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. The description specified for the model when it was created.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Output only. The default version of the model. This version will be used to
	// handle prediction requests that do not specify a version.
	//
	// You can change the default version by calling
	// [projects.methods.versions.setDefault](/ml/reference/rest/v1beta1/projects.models.versions/setDefault).
	DefaultVersion *Version `protobuf:"bytes,3,opt,name=default_version,json=defaultVersion" json:"default_version,omitempty"`
}

func (m *Model) Reset()                    { *m = Model{} }
func (m *Model) String() string            { return proto.CompactTextString(m) }
func (*Model) ProtoMessage()               {}
func (*Model) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Model) GetDefaultVersion() *Version {
	if m != nil {
		return m.DefaultVersion
	}
	return nil
}

// Represents a version of the model.
//
// Each version is a trained model deployed in the cloud, ready to handle
// prediction requests. A model can have multiple versions. You can get
// information about all of the versions of a given model by calling
// [projects.models.versions.list](/ml/reference/rest/v1beta1/projects.models.versions/list).
type Version struct {
	// Required.The name specified for the version when it was created.
	//
	// The version name must be unique within the model it is created in.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. The description specified for the version when it was created.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Output only. If true, this version will be used to handle prediction
	// requests that do not specify a version.
	//
	// You can change the default version by calling
	// [projects.methods.versions.setDefault](/ml/reference/rest/v1beta1/projects.models.versions/setDefault).
	IsDefault bool `protobuf:"varint,3,opt,name=is_default,json=isDefault" json:"is_default,omitempty"`
	// Required. The Google Cloud Storage location of the trained model used to
	// create the version. See the
	// [overview of model deployment](/ml/docs/concepts/deployment-overview) for
	// more informaiton.
	//
	// When passing Version to
	// [projects.models.versions.create](/ml/reference/rest/v1beta1/projects.models.versions/create)
	// the model service uses the specified location as the source of the model.
	// Once deployed, the model version is hosted by the prediction service, so
	// this location is useful only as a historical record.
	DeploymentUri string `protobuf:"bytes,4,opt,name=deployment_uri,json=deploymentUri" json:"deployment_uri,omitempty"`
	// Output only. The time the version was created.
	CreateTime *google_protobuf2.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time the version was last used for prediction.
	LastUseTime *google_protobuf2.Timestamp `protobuf:"bytes,6,opt,name=last_use_time,json=lastUseTime" json:"last_use_time,omitempty"`
}

func (m *Version) Reset()                    { *m = Version{} }
func (m *Version) String() string            { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()               {}
func (*Version) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *Version) GetCreateTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Version) GetLastUseTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.LastUseTime
	}
	return nil
}

// Request message for the CreateModel method.
type CreateModelRequest struct {
	// Required. The project name.
	//
	// Authorization: requires `Editor` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The model to create.
	Model *Model `protobuf:"bytes,2,opt,name=model" json:"model,omitempty"`
}

func (m *CreateModelRequest) Reset()                    { *m = CreateModelRequest{} }
func (m *CreateModelRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateModelRequest) ProtoMessage()               {}
func (*CreateModelRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *CreateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

// Request message for the ListModels method.
type ListModelsRequest struct {
	// Required. The name of the project whose models are to be listed.
	//
	// Authorization: requires `Viewer` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. A page token to request the next page of results.
	//
	// You get the token from the `next_page_token` field of the response from
	// the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional. The number of models to retrieve per "page" of results. If there
	// are more remaining results than this number, the response message will
	// contain a valid value in the `next_page_token` field.
	//
	// The default value is 20, and the maximum page size is 100.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListModelsRequest) Reset()                    { *m = ListModelsRequest{} }
func (m *ListModelsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListModelsRequest) ProtoMessage()               {}
func (*ListModelsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

// Response message for the ListModels method.
type ListModelsResponse struct {
	// The list of models.
	Models []*Model `protobuf:"bytes,1,rep,name=models" json:"models,omitempty"`
	// Optional. Pass this token as the `page_token` field of the request for a
	// subsequent call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListModelsResponse) Reset()                    { *m = ListModelsResponse{} }
func (m *ListModelsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListModelsResponse) ProtoMessage()               {}
func (*ListModelsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *ListModelsResponse) GetModels() []*Model {
	if m != nil {
		return m.Models
	}
	return nil
}

// Request message for the GetModel method.
type GetModelRequest struct {
	// Required. The name of the model.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetModelRequest) Reset()                    { *m = GetModelRequest{} }
func (m *GetModelRequest) String() string            { return proto.CompactTextString(m) }
func (*GetModelRequest) ProtoMessage()               {}
func (*GetModelRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

// Request message for the DeleteModel method.
type DeleteModelRequest struct {
	// Required. The name of the model.
	//
	// Authorization: requires `Editor` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteModelRequest) Reset()                    { *m = DeleteModelRequest{} }
func (m *DeleteModelRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteModelRequest) ProtoMessage()               {}
func (*DeleteModelRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

// Uploads the provided trained model version to Cloud Machine Learning.
type CreateVersionRequest struct {
	// Required. The name of the model.
	//
	// Authorization: requires `Editor` role on the parent project.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The version details.
	Version *Version `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
}

func (m *CreateVersionRequest) Reset()                    { *m = CreateVersionRequest{} }
func (m *CreateVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVersionRequest) ProtoMessage()               {}
func (*CreateVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *CreateVersionRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

// Request message for the ListVersions method.
type ListVersionsRequest struct {
	// Required. The name of the model for which to list the version.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. A page token to request the next page of results.
	//
	// You get the token from the `next_page_token` field of the response from
	// the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional. The number of versions to retrieve per "page" of results. If
	// there are more remaining results than this number, the response message
	// will contain a valid value in the `next_page_token` field.
	//
	// The default value is 20, and the maximum page size is 100.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListVersionsRequest) Reset()                    { *m = ListVersionsRequest{} }
func (m *ListVersionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVersionsRequest) ProtoMessage()               {}
func (*ListVersionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

// Response message for the ListVersions method.
type ListVersionsResponse struct {
	// The list of versions.
	Versions []*Version `protobuf:"bytes,1,rep,name=versions" json:"versions,omitempty"`
	// Optional. Pass this token as the `page_token` field of the request for a
	// subsequent call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListVersionsResponse) Reset()                    { *m = ListVersionsResponse{} }
func (m *ListVersionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListVersionsResponse) ProtoMessage()               {}
func (*ListVersionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *ListVersionsResponse) GetVersions() []*Version {
	if m != nil {
		return m.Versions
	}
	return nil
}

// Request message for the GetVersion method.
type GetVersionRequest struct {
	// Required. The name of the version.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetVersionRequest) Reset()                    { *m = GetVersionRequest{} }
func (m *GetVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVersionRequest) ProtoMessage()               {}
func (*GetVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

// Request message for the DeleteVerionRequest method.
type DeleteVersionRequest struct {
	// Required. The name of the version. You can get the names of all the
	// versions of a model by calling
	// [projects.models.versions.list](/ml/reference/rest/v1beta1/projects.models.versions/list).
	//
	// Authorization: requires `Editor` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteVersionRequest) Reset()                    { *m = DeleteVersionRequest{} }
func (m *DeleteVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVersionRequest) ProtoMessage()               {}
func (*DeleteVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

// Request message for the SetDefaultVersion request.
type SetDefaultVersionRequest struct {
	// Required. The name of the version to make the default for the model. You
	// can get the names of all the versions of a model by calling
	// [projects.models.versions.list](/ml/reference/rest/v1beta1/projects.models.versions/list).
	//
	// Authorization: requires `Editor` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *SetDefaultVersionRequest) Reset()                    { *m = SetDefaultVersionRequest{} }
func (m *SetDefaultVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*SetDefaultVersionRequest) ProtoMessage()               {}
func (*SetDefaultVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func init() {
	proto.RegisterType((*Model)(nil), "google.cloud.ml.v1beta1.Model")
	proto.RegisterType((*Version)(nil), "google.cloud.ml.v1beta1.Version")
	proto.RegisterType((*CreateModelRequest)(nil), "google.cloud.ml.v1beta1.CreateModelRequest")
	proto.RegisterType((*ListModelsRequest)(nil), "google.cloud.ml.v1beta1.ListModelsRequest")
	proto.RegisterType((*ListModelsResponse)(nil), "google.cloud.ml.v1beta1.ListModelsResponse")
	proto.RegisterType((*GetModelRequest)(nil), "google.cloud.ml.v1beta1.GetModelRequest")
	proto.RegisterType((*DeleteModelRequest)(nil), "google.cloud.ml.v1beta1.DeleteModelRequest")
	proto.RegisterType((*CreateVersionRequest)(nil), "google.cloud.ml.v1beta1.CreateVersionRequest")
	proto.RegisterType((*ListVersionsRequest)(nil), "google.cloud.ml.v1beta1.ListVersionsRequest")
	proto.RegisterType((*ListVersionsResponse)(nil), "google.cloud.ml.v1beta1.ListVersionsResponse")
	proto.RegisterType((*GetVersionRequest)(nil), "google.cloud.ml.v1beta1.GetVersionRequest")
	proto.RegisterType((*DeleteVersionRequest)(nil), "google.cloud.ml.v1beta1.DeleteVersionRequest")
	proto.RegisterType((*SetDefaultVersionRequest)(nil), "google.cloud.ml.v1beta1.SetDefaultVersionRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ModelService service

type ModelServiceClient interface {
	// Creates a model which will later contain one or more versions.
	//
	// You must add at least one version before you can request predictions from
	// the model. Add versions by calling
	// [projects.models.versions.create](/ml/reference/rest/v1beta1/projects.models.versions/create).
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists the models in a project.
	//
	// Each project can contain multiple models, and each model can have multiple
	// versions.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Gets information about a model, including its name, the description (if
	// set), and the default version (if at least one version of the model has
	// been deployed).
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deletes a model.
	//
	// You can only delete a model if there are no versions in it. You can delete
	// versions by calling
	// [projects.models.versions.delete](/ml/reference/rest/v1beta1/projects.models.versions/delete).
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Creates a new version of a model from a trained TensorFlow model.
	//
	// If the version created in the cloud by this call is the first deployed
	// version of the specified model, it will be made the default version of the
	// model. When you add a version to a model that already has one or more
	// versions, the default version does not automatically change. If you want a
	// new version to be the default, you must call
	// [projects.models.versions.setDefault](/ml/reference/rest/v1beta1/projects.models.versions/setDefault).
	CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets basic information about all the versions of a model.
	//
	// If you expect that a model has a lot of versions, or if you need to handle
	// only a limited number of results at a time, you can request that the list
	// be retrieved in batches (called pages):
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
	// Gets information about a model version.
	//
	// Models can have multiple versions. You can call
	// [projects.models.versions.list](/ml/reference/rest/v1beta1/projects.models.versions/list)
	// to get the same information that this method returns for all of the
	// versions of a model.
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Deletes a model version.
	//
	// Each model can have multiple versions deployed and in use at any given
	// time. Use this method to remove a single version.
	//
	// Note: You cannot delete the version that is set as the default version
	// of the model unless it is the only remaining version.
	DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Designates a version to be the default for the model.
	//
	// The default version is used for prediction requests made against the model
	// that don't specify a version.
	//
	// The first version to be created for a model is automatically set as the
	// default. You must make any subsequent changes to the default version
	// setting manually using this method.
	SetDefaultVersion(ctx context.Context, in *SetDefaultVersionRequest, opts ...grpc.CallOption) (*Version, error)
}

type modelServiceClient struct {
	cc *grpc.ClientConn
}

func NewModelServiceClient(cc *grpc.ClientConn) ModelServiceClient {
	return &modelServiceClient{cc}
}

func (c *modelServiceClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/CreateModel", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/ListModels", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/GetModel", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/DeleteModel", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/CreateVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	out := new(ListVersionsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/ListVersions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/GetVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/DeleteVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) SetDefaultVersion(ctx context.Context, in *SetDefaultVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.ModelService/SetDefaultVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ModelService service

type ModelServiceServer interface {
	// Creates a model which will later contain one or more versions.
	//
	// You must add at least one version before you can request predictions from
	// the model. Add versions by calling
	// [projects.models.versions.create](/ml/reference/rest/v1beta1/projects.models.versions/create).
	CreateModel(context.Context, *CreateModelRequest) (*Model, error)
	// Lists the models in a project.
	//
	// Each project can contain multiple models, and each model can have multiple
	// versions.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Gets information about a model, including its name, the description (if
	// set), and the default version (if at least one version of the model has
	// been deployed).
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Deletes a model.
	//
	// You can only delete a model if there are no versions in it. You can delete
	// versions by calling
	// [projects.models.versions.delete](/ml/reference/rest/v1beta1/projects.models.versions/delete).
	DeleteModel(context.Context, *DeleteModelRequest) (*google_longrunning.Operation, error)
	// Creates a new version of a model from a trained TensorFlow model.
	//
	// If the version created in the cloud by this call is the first deployed
	// version of the specified model, it will be made the default version of the
	// model. When you add a version to a model that already has one or more
	// versions, the default version does not automatically change. If you want a
	// new version to be the default, you must call
	// [projects.models.versions.setDefault](/ml/reference/rest/v1beta1/projects.models.versions/setDefault).
	CreateVersion(context.Context, *CreateVersionRequest) (*google_longrunning.Operation, error)
	// Gets basic information about all the versions of a model.
	//
	// If you expect that a model has a lot of versions, or if you need to handle
	// only a limited number of results at a time, you can request that the list
	// be retrieved in batches (called pages):
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
	// Gets information about a model version.
	//
	// Models can have multiple versions. You can call
	// [projects.models.versions.list](/ml/reference/rest/v1beta1/projects.models.versions/list)
	// to get the same information that this method returns for all of the
	// versions of a model.
	GetVersion(context.Context, *GetVersionRequest) (*Version, error)
	// Deletes a model version.
	//
	// Each model can have multiple versions deployed and in use at any given
	// time. Use this method to remove a single version.
	//
	// Note: You cannot delete the version that is set as the default version
	// of the model unless it is the only remaining version.
	DeleteVersion(context.Context, *DeleteVersionRequest) (*google_longrunning.Operation, error)
	// Designates a version to be the default for the model.
	//
	// The default version is used for prediction requests made against the model
	// that don't specify a version.
	//
	// The first version to be created for a model is automatically set as the
	// default. You must make any subsequent changes to the default version
	// setting manually using this method.
	SetDefaultVersion(context.Context, *SetDefaultVersionRequest) (*Version, error)
}

func RegisterModelServiceServer(s *grpc.Server, srv ModelServiceServer) {
	s.RegisterService(&_ModelService_serviceDesc, srv)
}

func _ModelService_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/CreateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_CreateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).CreateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/CreateVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).CreateVersion(ctx, req.(*CreateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/GetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/DeleteVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteVersion(ctx, req.(*DeleteVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_SetDefaultVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).SetDefaultVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.ModelService/SetDefaultVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).SetDefaultVersion(ctx, req.(*SetDefaultVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ModelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.ml.v1beta1.ModelService",
	HandlerType: (*ModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateModel",
			Handler:    _ModelService_CreateModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _ModelService_ListModels_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _ModelService_GetModel_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _ModelService_DeleteModel_Handler,
		},
		{
			MethodName: "CreateVersion",
			Handler:    _ModelService_CreateVersion_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _ModelService_ListVersions_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _ModelService_GetVersion_Handler,
		},
		{
			MethodName: "DeleteVersion",
			Handler:    _ModelService_DeleteVersion_Handler,
		},
		{
			MethodName: "SetDefaultVersion",
			Handler:    _ModelService_SetDefaultVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/ml/v1beta1/model_service.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/ml/v1beta1/model_service.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 921 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x56, 0x4f, 0x6f, 0xdc, 0x44,
	0x14, 0x97, 0xd3, 0x26, 0x4d, 0xde, 0x76, 0x1b, 0x65, 0x88, 0x60, 0xb5, 0x28, 0xb0, 0x32, 0x0a,
	0x44, 0x9b, 0xd6, 0x43, 0x52, 0x14, 0xa9, 0x5b, 0x28, 0x52, 0x88, 0x54, 0x15, 0x81, 0x88, 0x36,
	0x2d, 0x57, 0xcb, 0xbb, 0xfb, 0x62, 0xa6, 0xd8, 0x33, 0xc6, 0x33, 0x1b, 0x91, 0x42, 0x0f, 0xf4,
	0x80, 0x38, 0x71, 0x00, 0x71, 0xe5, 0xc2, 0x9d, 0x2f, 0xc3, 0x57, 0x40, 0x7c, 0x0e, 0xe4, 0x99,
	0x71, 0xd6, 0xfb, 0xc7, 0x6b, 0x07, 0x89, 0xcb, 0xca, 0x7e, 0x7e, 0x7f, 0x7e, 0xf3, 0xfb, 0xbd,
	0xf7, 0x66, 0xe1, 0xd3, 0x50, 0x88, 0x30, 0x42, 0x2f, 0x14, 0x51, 0xc0, 0x43, 0x4f, 0xa4, 0x21,
	0x0d, 0x91, 0x27, 0xa9, 0x50, 0x82, 0x9a, 0x4f, 0x41, 0xc2, 0x24, 0x1d, 0x46, 0x62, 0x3c, 0xa2,
	0x71, 0x44, 0x2f, 0x0e, 0x06, 0xa8, 0x82, 0x03, 0x1a, 0x8b, 0x11, 0x46, 0xbe, 0xc4, 0xf4, 0x82,
	0x0d, 0xd1, 0xd3, 0xfe, 0xe4, 0x0d, 0x9b, 0x4b, 0x3b, 0x7b, 0x71, 0xe4, 0x59, 0xe7, 0xf6, 0x93,
	0x7a, 0x45, 0x82, 0x84, 0x51, 0x9b, 0x71, 0x28, 0xf8, 0x39, 0x0b, 0x69, 0xc0, 0xb9, 0x50, 0x81,
	0x62, 0x82, 0x4b, 0x53, 0xa3, 0x7d, 0x5c, 0x2f, 0x55, 0x24, 0x78, 0x98, 0x8e, 0x39, 0x67, 0x3c,
	0xa4, 0x22, 0xc1, 0x74, 0x2a, 0xc7, 0xfd, 0x90, 0xa9, 0xaf, 0xc6, 0x03, 0x6f, 0x28, 0x62, 0x6a,
	0xf2, 0x50, 0xfd, 0x61, 0x30, 0x3e, 0xa7, 0x89, 0xba, 0x4c, 0x50, 0x52, 0x8c, 0x13, 0x75, 0x69,
	0x7e, 0x6d, 0xd0, 0xc3, 0xea, 0x20, 0xc5, 0x62, 0x94, 0x2a, 0x88, 0x93, 0xc9, 0x93, 0x09, 0x76,
	0x7f, 0x72, 0x60, 0xf5, 0xf3, 0x8c, 0x31, 0x42, 0xe0, 0x26, 0x0f, 0x62, 0x6c, 0x39, 0x1d, 0x67,
	0x6f, 0xa3, 0xaf, 0x9f, 0x49, 0x07, 0x1a, 0x23, 0x94, 0xc3, 0x94, 0x25, 0x19, 0xca, 0xd6, 0x8a,
	0xfe, 0x54, 0x34, 0x91, 0x27, 0xb0, 0x39, 0xc2, 0xf3, 0x60, 0x1c, 0x29, 0xff, 0x02, 0x53, 0x99,
	0x79, 0xdd, 0xe8, 0x38, 0x7b, 0x8d, 0xc3, 0x8e, 0x57, 0xc2, 0xb9, 0xf7, 0xa5, 0xf1, 0xeb, 0xdf,
	0xb1, 0x81, 0xf6, 0xdd, 0x7d, 0xb5, 0x02, 0xb7, 0xec, 0xf3, 0x7f, 0x04, 0xb3, 0x03, 0xc0, 0xa4,
	0x6f, 0xd3, 0x6a, 0x1c, 0xeb, 0xfd, 0x0d, 0x26, 0x4f, 0x8c, 0x81, 0xec, 0xc2, 0x9d, 0x11, 0x26,
	0x91, 0xb8, 0x8c, 0x91, 0x2b, 0x7f, 0x9c, 0xb2, 0xd6, 0x4d, 0x9d, 0xa3, 0x39, 0xb1, 0x3e, 0x4b,
	0x19, 0x79, 0x08, 0x8d, 0x61, 0x8a, 0x81, 0x42, 0x3f, 0x23, 0xab, 0xb5, 0xaa, 0x8f, 0xd3, 0xce,
	0x8f, 0x93, 0x53, 0xeb, 0x3d, 0xcd, 0x99, 0xec, 0x83, 0x71, 0xcf, 0x0c, 0xe4, 0x11, 0x34, 0xa3,
	0x40, 0x2a, 0x7f, 0x2c, 0x6d, 0xf8, 0x5a, 0x65, 0x78, 0x23, 0x0b, 0x78, 0x26, 0x75, 0xbc, 0x3b,
	0x00, 0xf2, 0x89, 0xce, 0xa6, 0x45, 0xe9, 0xe3, 0x37, 0x63, 0x94, 0x8a, 0xbc, 0x0e, 0x6b, 0x49,
	0x90, 0x22, 0x57, 0x96, 0x10, 0xfb, 0x46, 0x3e, 0x80, 0x55, 0xdd, 0xee, 0x9a, 0x8c, 0xc6, 0xe1,
	0x5b, 0xa5, 0x9c, 0x9b, 0x6c, 0xc6, 0xd9, 0x0d, 0x61, 0xeb, 0x33, 0x26, 0x95, 0xb6, 0xc9, 0xaa,
	0x12, 0x3b, 0x00, 0x49, 0x10, 0xa2, 0xaf, 0xc4, 0xd7, 0xc8, 0x2d, 0x61, 0x1b, 0x99, 0xe5, 0x69,
	0x66, 0x20, 0x6f, 0x82, 0x7e, 0xf1, 0x25, 0x7b, 0x61, 0xa8, 0x5a, 0xed, 0xaf, 0x67, 0x86, 0x33,
	0xf6, 0x02, 0x5d, 0x05, 0xa4, 0x58, 0x48, 0x26, 0x82, 0x4b, 0x24, 0x47, 0xb0, 0xa6, 0x71, 0xc8,
	0x96, 0xd3, 0xb9, 0x51, 0x03, 0xb5, 0xf5, 0x26, 0xef, 0xc2, 0x26, 0xc7, 0x6f, 0x95, 0x5f, 0x80,
	0x63, 0x7a, 0xa0, 0x99, 0x99, 0x4f, 0x73, 0x48, 0xee, 0x2e, 0x6c, 0x3e, 0x46, 0x35, 0xc5, 0xdf,
	0x82, 0x76, 0x72, 0xf7, 0x80, 0x9c, 0x60, 0x84, 0x33, 0x4c, 0x2f, 0xf2, 0x7c, 0x0e, 0xdb, 0x46,
	0x93, 0xbc, 0x73, 0x2b, 0x28, 0xeb, 0xc1, 0xad, 0x7c, 0x16, 0x56, 0x6a, 0xce, 0x42, 0x1e, 0xe0,
	0x32, 0x78, 0x2d, 0xa3, 0xcc, 0xda, 0xff, 0x57, 0x75, 0xbe, 0x87, 0xed, 0xe9, 0x52, 0x56, 0x9f,
	0x0f, 0x61, 0xdd, 0xa2, 0xc9, 0x15, 0xaa, 0xc6, 0x7f, 0x15, 0x51, 0x5b, 0xa5, 0xf7, 0x60, 0xeb,
	0x31, 0xaa, 0x19, 0x46, 0x17, 0xb1, 0xdf, 0x85, 0x6d, 0xa3, 0x53, 0x0d, 0x5f, 0x0f, 0x5a, 0x67,
	0xa8, 0x4e, 0xa6, 0xf6, 0xca, 0x12, 0xff, 0xc3, 0x7f, 0x00, 0x6e, 0x6b, 0xf9, 0xcf, 0xcc, 0x72,
	0x27, 0x3f, 0x3b, 0xd0, 0x28, 0xcc, 0x1f, 0xd9, 0x2f, 0x3d, 0xf9, 0xfc, 0x94, 0xb6, 0x2b, 0x1a,
	0xd9, 0x3d, 0x7c, 0xf5, 0xd7, 0xdf, 0xbf, 0xae, 0xdc, 0x75, 0xdf, 0xb9, 0xba, 0xab, 0xbe, 0x33,
	0x32, 0x7e, 0x94, 0xa4, 0xe2, 0x39, 0x0e, 0x95, 0xa4, 0xdd, 0x97, 0xe6, 0xfe, 0x92, 0x3d, 0x33,
	0xab, 0xe4, 0x17, 0x07, 0x60, 0x32, 0x43, 0xa4, 0x5b, 0x5a, 0x62, 0x6e, 0xa2, 0xdb, 0xfb, 0xb5,
	0x7c, 0x8d, 0xe8, 0xee, 0xbe, 0xc6, 0xb6, 0x4b, 0xea, 0x60, 0x23, 0x3f, 0x38, 0xb0, 0x9e, 0x8f,
	0x18, 0xd9, 0x2b, 0x2d, 0x33, 0x33, 0x85, 0x95, 0xfc, 0x2c, 0xc0, 0x90, 0xa9, 0x54, 0x40, 0x60,
	0x01, 0xd0, 0xee, 0x4b, 0xf2, 0xa3, 0x03, 0x8d, 0xc2, 0xfc, 0x2e, 0x51, 0x6a, 0x7e, 0xca, 0xdb,
	0x3b, 0xb9, 0x73, 0xe1, 0x36, 0xf6, 0xbe, 0xc8, 0x6f, 0xe3, 0x1c, 0x48, 0xb7, 0x16, 0x90, 0xdf,
	0x1d, 0x68, 0x4e, 0xad, 0x07, 0x72, 0xaf, 0xa2, 0x69, 0xa6, 0x1b, 0xb3, 0x0a, 0xcc, 0xc7, 0x1a,
	0xcc, 0x03, 0xd7, 0x5b, 0xa2, 0xcc, 0x04, 0x0e, 0xcd, 0x07, 0xb1, 0x97, 0xaf, 0x14, 0xf2, 0x87,
	0x03, 0xb7, 0x8b, 0x83, 0x4e, 0xee, 0x2e, 0x6d, 0x8c, 0x99, 0xd5, 0xd3, 0xbe, 0x57, 0xd3, 0xdb,
	0x36, 0xd2, 0x91, 0x86, 0xfb, 0x3e, 0xb9, 0x26, 0x5c, 0xdd, 0xe8, 0x93, 0x85, 0xb0, 0xa4, 0xd1,
	0xe7, 0xb6, 0x46, 0xbb, 0x72, 0x3d, 0x2d, 0x02, 0x55, 0x26, 0xe8, 0x15, 0xa2, 0x4c, 0xdb, 0xdf,
	0x1c, 0x68, 0x4e, 0x2d, 0x9f, 0x25, 0xda, 0x2e, 0x5a, 0x52, 0x55, 0xda, 0x5a, 0x5c, 0xdd, 0xeb,
	0xe2, 0xfa, 0xd3, 0x81, 0xad, 0xb9, 0x45, 0x47, 0x0e, 0x4a, 0xb1, 0x95, 0x2d, 0xc5, 0x1a, 0xd4,
	0x9d, 0x68, 0x88, 0x8f, 0xdc, 0x07, 0xd7, 0x83, 0xd8, 0x93, 0x57, 0x25, 0x7b, 0x4e, 0xf7, 0xf8,
	0x08, 0xde, 0x1e, 0x8a, 0x78, 0xae, 0x58, 0x90, 0xb0, 0xbc, 0xe0, 0xf1, 0x56, 0x71, 0x11, 0x9f,
	0x66, 0x7f, 0x93, 0x4e, 0x9d, 0xc1, 0x9a, 0xfe, 0xbf, 0x74, 0xff, 0xdf, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xb6, 0xdd, 0x81, 0x3c, 0x0d, 0x0c, 0x00, 0x00,
}
