// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/container/v1/cluster_service.proto
// DO NOT EDIT!

/*
Package google_container_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/container/v1/cluster_service.proto

It has these top-level messages:
	NodeConfig
	MasterAuth
	AddonsConfig
	HttpLoadBalancing
	HorizontalPodAutoscaling
	Cluster
	ClusterUpdate
	Operation
	CreateClusterRequest
	GetClusterRequest
	UpdateClusterRequest
	DeleteClusterRequest
	ListClustersRequest
	ListClustersResponse
	GetOperationRequest
	ListOperationsRequest
	ListOperationsResponse
	GetServerConfigRequest
	ServerConfig
*/
package google_container_v1 // import "google.golang.org/genproto/googleapis/container/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The current status of the cluster.
type Cluster_Status int32

const (
	// Not set.
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// The PROVISIONING state indicates the cluster is being created.
	Cluster_PROVISIONING Cluster_Status = 1
	// The RUNNING state indicates the cluster has been created and is fully usable.
	Cluster_RUNNING Cluster_Status = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the master or node software. Details can
	// be found in the `statusMessage` field.
	Cluster_RECONCILING Cluster_Status = 3
	// The STOPPING state indicates the cluster is being deleted.
	Cluster_STOPPING Cluster_Status = 4
	// The ERROR state indicates the cluster may be unusable. Details
	// can be found in the `statusMessage` field.
	Cluster_ERROR Cluster_Status = 5
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RECONCILING",
	4: "STOPPING",
	5: "ERROR",
}
var Cluster_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RECONCILING":        3,
	"STOPPING":           4,
	"ERROR":              5,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}
func (Cluster_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{5, 0} }

// Current status of the operation.
type Operation_Status int32

const (
	// Not set.
	Operation_STATUS_UNSPECIFIED Operation_Status = 0
	// The operation has been created.
	Operation_PENDING Operation_Status = 1
	// The operation is currently running.
	Operation_RUNNING Operation_Status = 2
	// The operation is done, either cancelled or completed.
	Operation_DONE Operation_Status = 3
)

var Operation_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
}
var Operation_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PENDING":            1,
	"RUNNING":            2,
	"DONE":               3,
}

func (x Operation_Status) String() string {
	return proto.EnumName(Operation_Status_name, int32(x))
}
func (Operation_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

// Operation type.
type Operation_Type int32

const (
	// Not set.
	Operation_TYPE_UNSPECIFIED Operation_Type = 0
	// Cluster create.
	Operation_CREATE_CLUSTER Operation_Type = 1
	// Cluster delete.
	Operation_DELETE_CLUSTER Operation_Type = 2
	// A master upgrade.
	Operation_UPGRADE_MASTER Operation_Type = 3
	// A node upgrade.
	Operation_UPGRADE_NODES Operation_Type = 4
	// Cluster repair.
	Operation_REPAIR_CLUSTER Operation_Type = 5
	// Cluster update.
	Operation_UPDATE_CLUSTER Operation_Type = 6
	// Node pool create.
	Operation_CREATE_NODE_POOL Operation_Type = 7
	// Node pool delete.
	Operation_DELETE_NODE_POOL Operation_Type = 8
)

var Operation_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CREATE_CLUSTER",
	2: "DELETE_CLUSTER",
	3: "UPGRADE_MASTER",
	4: "UPGRADE_NODES",
	5: "REPAIR_CLUSTER",
	6: "UPDATE_CLUSTER",
	7: "CREATE_NODE_POOL",
	8: "DELETE_NODE_POOL",
}
var Operation_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"CREATE_CLUSTER":   1,
	"DELETE_CLUSTER":   2,
	"UPGRADE_MASTER":   3,
	"UPGRADE_NODES":    4,
	"REPAIR_CLUSTER":   5,
	"UPDATE_CLUSTER":   6,
	"CREATE_NODE_POOL": 7,
	"DELETE_NODE_POOL": 8,
}

func (x Operation_Type) String() string {
	return proto.EnumName(Operation_Type_name, int32(x))
}
func (Operation_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 1} }

// Parameters that describe the nodes in a cluster.
type NodeConfig struct {
	// The name of a Google Compute Engine [machine type](/compute/docs/machine-types) (e.g.
	// `n1-standard-1`).
	//
	// If unspecified, the default machine type is
	// `n1-standard-1`.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType" json:"machine_type,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb" json:"disk_size_gb,omitempty"`
	// The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account.
	//
	// The following scopes are recommended, but not required, and by default are
	// not included:
	//
	// * `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes.
	// * `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io**
	// (the [Google Container Registry](/container-registry/)).
	//
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `protobuf:"bytes,3,rep,name=oauth_scopes,json=oauthScopes" json:"oauth_scopes,omitempty"`
	// The metadata key/value pairs assigned to instances in the cluster.
	//
	// Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less than 128 bytes
	// in length. These are reflected as part of a URL in the metadata server.
	// Additionally, to avoid ambiguity, keys must not conflict with any other
	// metadata keys for the project or be one of the four reserved keys:
	// "instance-template", "kube-env", "startup-script", and "user-data"
	//
	// Values are free-form strings, and only have meaning as interpreted by
	// the image running in the instance. The only restriction placed on them is
	// that each value's size must be less than or equal to 32 KB.
	//
	// The total size of all keys and values must be less than 512 KB.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *NodeConfig) Reset()                    { *m = NodeConfig{} }
func (m *NodeConfig) String() string            { return proto.CompactTextString(m) }
func (*NodeConfig) ProtoMessage()               {}
func (*NodeConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *NodeConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// The authentication information for accessing the master endpoint.
// Authentication can be done using HTTP basic auth or using client
// certificates.
type MasterAuth struct {
	// The username to use for HTTP basic authentication to the master endpoint.
	Username string `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	// The password to use for HTTP basic authentication to the master endpoint.
	// Because the master endpoint is open to the Internet, you should create a
	// strong password.
	Password string `protobuf:"bytes,2,opt,name=password" json:"password,omitempty"`
	// [Output only] Base64-encoded public certificate that is the root of
	// trust for the cluster.
	ClusterCaCertificate string `protobuf:"bytes,100,opt,name=cluster_ca_certificate,json=clusterCaCertificate" json:"cluster_ca_certificate,omitempty"`
	// [Output only] Base64-encoded public certificate used by clients to
	// authenticate to the cluster endpoint.
	ClientCertificate string `protobuf:"bytes,101,opt,name=client_certificate,json=clientCertificate" json:"client_certificate,omitempty"`
	// [Output only] Base64-encoded private key used by clients to authenticate
	// to the cluster endpoint.
	ClientKey string `protobuf:"bytes,102,opt,name=client_key,json=clientKey" json:"client_key,omitempty"`
}

func (m *MasterAuth) Reset()                    { *m = MasterAuth{} }
func (m *MasterAuth) String() string            { return proto.CompactTextString(m) }
func (*MasterAuth) ProtoMessage()               {}
func (*MasterAuth) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Configuration for the addons that can be automatically spun up in the
// cluster, enabling additional functionality.
type AddonsConfig struct {
	// Configuration for the HTTP (L7) load balancing controller addon, which
	// makes it easy to set up HTTP load balancers for services in a cluster.
	HttpLoadBalancing *HttpLoadBalancing `protobuf:"bytes,1,opt,name=http_load_balancing,json=httpLoadBalancing" json:"http_load_balancing,omitempty"`
	// Configuration for the horizontal pod autoscaling feature, which
	// increases or decreases the number of replica pods a replication controller
	// has based on the resource usage of the existing pods.
	HorizontalPodAutoscaling *HorizontalPodAutoscaling `protobuf:"bytes,2,opt,name=horizontal_pod_autoscaling,json=horizontalPodAutoscaling" json:"horizontal_pod_autoscaling,omitempty"`
}

func (m *AddonsConfig) Reset()                    { *m = AddonsConfig{} }
func (m *AddonsConfig) String() string            { return proto.CompactTextString(m) }
func (*AddonsConfig) ProtoMessage()               {}
func (*AddonsConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *AddonsConfig) GetHttpLoadBalancing() *HttpLoadBalancing {
	if m != nil {
		return m.HttpLoadBalancing
	}
	return nil
}

func (m *AddonsConfig) GetHorizontalPodAutoscaling() *HorizontalPodAutoscaling {
	if m != nil {
		return m.HorizontalPodAutoscaling
	}
	return nil
}

// Configuration options for the HTTP (L7) load balancing controller addon,
// which makes it easy to set up HTTP load balancers for services in a cluster.
type HttpLoadBalancing struct {
	// Whether the HTTP Load Balancing controller is enabled in the cluster.
	// When enabled, it runs a small pod in the cluster that manages the load
	// balancers.
	Disabled bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *HttpLoadBalancing) Reset()                    { *m = HttpLoadBalancing{} }
func (m *HttpLoadBalancing) String() string            { return proto.CompactTextString(m) }
func (*HttpLoadBalancing) ProtoMessage()               {}
func (*HttpLoadBalancing) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Configuration options for the horizontal pod autoscaling feature, which
// increases or decreases the number of replica pods a replication controller
// has based on the resource usage of the existing pods.
type HorizontalPodAutoscaling struct {
	// Whether the Horizontal Pod Autoscaling feature is enabled in the cluster.
	// When enabled, it ensures that a Heapster pod is running in the cluster,
	// which is also used by the Cloud Monitoring service.
	Disabled bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *HorizontalPodAutoscaling) Reset()                    { *m = HorizontalPodAutoscaling{} }
func (m *HorizontalPodAutoscaling) String() string            { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscaling) ProtoMessage()               {}
func (*HorizontalPodAutoscaling) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// A Google Container Engine cluster.
type Cluster struct {
	// The name of this cluster. The name must be unique within this project
	// and zone, and can be up to 40 characters with the following restrictions:
	//
	// * Lowercase letters, numbers, and hyphens only.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// An optional description of this cluster.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// The number of nodes to create in this cluster. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "node_config") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount" json:"initial_node_count,omitempty"`
	// Parameters used in creating the cluster's nodes.
	// See `nodeConfig` for the description of its properties.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "initial_node_count") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	// For responses, this field will be populated with the node configuration of
	// the first node pool.
	//
	// If unspecified, the defaults are used.
	NodeConfig *NodeConfig `protobuf:"bytes,4,opt,name=node_config,json=nodeConfig" json:"node_config,omitempty"`
	// The authentication information for accessing the master endpoint.
	MasterAuth *MasterAuth `protobuf:"bytes,5,opt,name=master_auth,json=masterAuth" json:"master_auth,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com` - the Google Cloud Logging service.
	// * `none` - no logs will be exported from the cluster.
	// * if left as an empty string,`logging.googleapis.com` will be used.
	LoggingService string `protobuf:"bytes,6,opt,name=logging_service,json=loggingService" json:"logging_service,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * `monitoring.googleapis.com` - the Google Cloud Monitoring service.
	// * `none` - no metrics will be exported from the cluster.
	// * if left as an empty string, `monitoring.googleapis.com` will be used.
	MonitoringService string `protobuf:"bytes,7,opt,name=monitoring_service,json=monitoringService" json:"monitoring_service,omitempty"`
	// The name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// cluster is connected. If left unspecified, the `default` network
	// will be used.
	Network string `protobuf:"bytes,8,opt,name=network" json:"network,omitempty"`
	// The IP address range of the container pods in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`). Leave blank to have
	// one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
	ClusterIpv4Cidr string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr" json:"cluster_ipv4_cidr,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,10,opt,name=addons_config,json=addonsConfig" json:"addons_config,omitempty"`
	// The name of the Google Compute Engine
	// [subnetwork](/compute/docs/subnetworks) to which the
	// cluster is connected.  Specification of subnetworks is an alpha feature,
	// and require that the Google Compute Engine alpha API be enabled.
	Subnetwork string `protobuf:"bytes,11,opt,name=subnetwork" json:"subnetwork,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink" json:"self_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,101,opt,name=zone" json:"zone,omitempty"`
	// [Output only] The IP address of this cluster's master endpoint.
	// The endpoint can be accessed from the internet at
	// `https://username:password@endpoint/`.
	//
	// See the `masterAuth` property of this resource for username and
	// password information.
	Endpoint string `protobuf:"bytes,102,opt,name=endpoint" json:"endpoint,omitempty"`
	// [Output only] The software version of the master endpoint and kubelets used
	// in the cluster when it was first created. The version can be upgraded over
	// time.
	//
	InitialClusterVersion string `protobuf:"bytes,103,opt,name=initial_cluster_version,json=initialClusterVersion" json:"initial_cluster_version,omitempty"`
	// [Output only] The current software version of the master endpoint.
	CurrentMasterVersion string `protobuf:"bytes,104,opt,name=current_master_version,json=currentMasterVersion" json:"current_master_version,omitempty"`
	// [Output only] The current version of the node software components.
	// If they are currently at multiple versions because they're in the process
	// of being upgraded, this reflects the minimum version of all nodes.
	CurrentNodeVersion string `protobuf:"bytes,105,opt,name=current_node_version,json=currentNodeVersion" json:"current_node_version,omitempty"`
	// [Output only] The time the cluster was created, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `protobuf:"bytes,106,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// [Output only] The current status of this cluster.
	Status Cluster_Status `protobuf:"varint,107,opt,name=status,enum=google.container.v1.Cluster_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// cluster, if available.
	StatusMessage string `protobuf:"bytes,108,opt,name=status_message,json=statusMessage" json:"status_message,omitempty"`
	// [Output only] The size of the address space on each node for hosting
	// containers. This is provisioned from within the `container_ipv4_cidr` range.
	NodeIpv4CidrSize int32 `protobuf:"varint,109,opt,name=node_ipv4_cidr_size,json=nodeIpv4CidrSize" json:"node_ipv4_cidr_size,omitempty"`
	// [Output only] The IP address range of the Kubernetes services in
	// this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`). Service addresses are
	// typically put in the last `/16` from the container CIDR.
	ServicesIpv4Cidr string `protobuf:"bytes,110,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr" json:"services_ipv4_cidr,omitempty"`
	// [Output only] The resource URLs of [instance
	// groups](/compute/docs/instance-groups/) associated with this
	// cluster.
	InstanceGroupUrls []string `protobuf:"bytes,111,rep,name=instance_group_urls,json=instanceGroupUrls" json:"instance_group_urls,omitempty"`
	// [Output only] The number of nodes currently in the cluster.
	CurrentNodeCount int32 `protobuf:"varint,112,opt,name=current_node_count,json=currentNodeCount" json:"current_node_count,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Cluster) GetNodeConfig() *NodeConfig {
	if m != nil {
		return m.NodeConfig
	}
	return nil
}

func (m *Cluster) GetMasterAuth() *MasterAuth {
	if m != nil {
		return m.MasterAuth
	}
	return nil
}

func (m *Cluster) GetAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.AddonsConfig
	}
	return nil
}

// ClusterUpdate describes an update to the cluster. Exactly one update can
// be applied to a cluster with each request, so at most one field can be
// provided.
type ClusterUpdate struct {
	// The Kubernetes version to change the nodes to (typically an
	// upgrade). Use `-` to upgrade to the latest version supported by
	// the server.
	DesiredNodeVersion string `protobuf:"bytes,4,opt,name=desired_node_version,json=desiredNodeVersion" json:"desired_node_version,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com" - the Google Cloud Monitoring service
	// * "none" - no metrics will be exported from the cluster
	DesiredMonitoringService string `protobuf:"bytes,5,opt,name=desired_monitoring_service,json=desiredMonitoringService" json:"desired_monitoring_service,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	DesiredAddonsConfig *AddonsConfig `protobuf:"bytes,6,opt,name=desired_addons_config,json=desiredAddonsConfig" json:"desired_addons_config,omitempty"`
	// The Kubernetes version to change the master to. The only valid value is the
	// latest supported version. Use "-" to have the server automatically select
	// the latest version.
	DesiredMasterVersion string `protobuf:"bytes,100,opt,name=desired_master_version,json=desiredMasterVersion" json:"desired_master_version,omitempty"`
}

func (m *ClusterUpdate) Reset()                    { *m = ClusterUpdate{} }
func (m *ClusterUpdate) String() string            { return proto.CompactTextString(m) }
func (*ClusterUpdate) ProtoMessage()               {}
func (*ClusterUpdate) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ClusterUpdate) GetDesiredAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.DesiredAddonsConfig
	}
	return nil
}

// This operation resource represents operations that may have happened or are
// happening on the cluster. All fields are output only.
type Operation struct {
	// The server-assigned ID for the operation.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation
	// is taking place.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The operation type.
	OperationType Operation_Type `protobuf:"varint,3,opt,name=operation_type,json=operationType,enum=google.container.v1.Operation_Type" json:"operation_type,omitempty"`
	// The current status of the operation.
	Status Operation_Status `protobuf:"varint,4,opt,name=status,enum=google.container.v1.Operation_Status" json:"status,omitempty"`
	// Detailed operation progress, if available.
	Detail string `protobuf:"bytes,8,opt,name=detail" json:"detail,omitempty"`
	// If an error has occurred, a textual description of the error.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage" json:"status_message,omitempty"`
	// Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,6,opt,name=self_link,json=selfLink" json:"self_link,omitempty"`
	// Server-defined URL for the target of the operation.
	TargetLink string `protobuf:"bytes,7,opt,name=target_link,json=targetLink" json:"target_link,omitempty"`
}

func (m *Operation) Reset()                    { *m = Operation{} }
func (m *Operation) String() string            { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()               {}
func (*Operation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// CreateClusterRequest creates a cluster.
type CreateClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// A [cluster resource](/container-engine/reference/rest/v1/projects.zones.clusters)
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// GetClusterRequest gets the settings of a cluster.
type GetClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to retrieve.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// UpdateClusterRequest updates the settings of a cluster.
type UpdateClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// A description of the update.
	Update *ClusterUpdate `protobuf:"bytes,4,opt,name=update" json:"update,omitempty"`
}

func (m *UpdateClusterRequest) Reset()                    { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()               {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *UpdateClusterRequest) GetUpdate() *ClusterUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

// DeleteClusterRequest deletes a cluster.
type DeleteClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to delete.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

// ListClustersRequest lists clusters.
type ListClustersRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides, or "-" for all zones.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

// ListClustersResponse is the result of ListClustersRequest.
type ListClustersResponse struct {
	// A list of clusters in the project in the specified zone, or
	// across all ones.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// If any zones are listed here, the list of clusters returned
	// may be missing those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones" json:"missing_zones,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

// GetOperationRequest gets a single operation.
type GetOperationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The server-assigned `name` of the operation.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
}

func (m *GetOperationRequest) Reset()                    { *m = GetOperationRequest{} }
func (m *GetOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOperationRequest) ProtoMessage()               {}
func (*GetOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

// ListOperationsRequest lists operations.
type ListOperationsRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine [zone](/compute/docs/zones#available)
	// to return operations for, or `-` for all zones.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
}

func (m *ListOperationsRequest) Reset()                    { *m = ListOperationsRequest{} }
func (m *ListOperationsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListOperationsRequest) ProtoMessage()               {}
func (*ListOperationsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

// ListOperationsResponse is the result of ListOperationsRequest.
type ListOperationsResponse struct {
	// A list of operations in the project in the specified zone.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations" json:"operations,omitempty"`
	// If any zones are listed here, the list of operations returned
	// may be missing the operations from those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones" json:"missing_zones,omitempty"`
}

func (m *ListOperationsResponse) Reset()                    { *m = ListOperationsResponse{} }
func (m *ListOperationsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListOperationsResponse) ProtoMessage()               {}
func (*ListOperationsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ListOperationsResponse) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// Gets the current Container Engine service configuration.
type GetServerConfigRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine [zone](/compute/docs/zones#available)
	// to return operations for.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
}

func (m *GetServerConfigRequest) Reset()                    { *m = GetServerConfigRequest{} }
func (m *GetServerConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServerConfigRequest) ProtoMessage()               {}
func (*GetServerConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

// Container Engine service configuration.
type ServerConfig struct {
	// Version of Kubernetes the service deploys by default.
	DefaultClusterVersion string `protobuf:"bytes,1,opt,name=default_cluster_version,json=defaultClusterVersion" json:"default_cluster_version,omitempty"`
	// List of valid node upgrade target versions.
	ValidNodeVersions []string `protobuf:"bytes,3,rep,name=valid_node_versions,json=validNodeVersions" json:"valid_node_versions,omitempty"`
}

func (m *ServerConfig) Reset()                    { *m = ServerConfig{} }
func (m *ServerConfig) String() string            { return proto.CompactTextString(m) }
func (*ServerConfig) ProtoMessage()               {}
func (*ServerConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func init() {
	proto.RegisterType((*NodeConfig)(nil), "google.container.v1.NodeConfig")
	proto.RegisterType((*MasterAuth)(nil), "google.container.v1.MasterAuth")
	proto.RegisterType((*AddonsConfig)(nil), "google.container.v1.AddonsConfig")
	proto.RegisterType((*HttpLoadBalancing)(nil), "google.container.v1.HttpLoadBalancing")
	proto.RegisterType((*HorizontalPodAutoscaling)(nil), "google.container.v1.HorizontalPodAutoscaling")
	proto.RegisterType((*Cluster)(nil), "google.container.v1.Cluster")
	proto.RegisterType((*ClusterUpdate)(nil), "google.container.v1.ClusterUpdate")
	proto.RegisterType((*Operation)(nil), "google.container.v1.Operation")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.container.v1.CreateClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.container.v1.GetClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.container.v1.UpdateClusterRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.container.v1.DeleteClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.container.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.container.v1.ListClustersResponse")
	proto.RegisterType((*GetOperationRequest)(nil), "google.container.v1.GetOperationRequest")
	proto.RegisterType((*ListOperationsRequest)(nil), "google.container.v1.ListOperationsRequest")
	proto.RegisterType((*ListOperationsResponse)(nil), "google.container.v1.ListOperationsResponse")
	proto.RegisterType((*GetServerConfigRequest)(nil), "google.container.v1.GetServerConfigRequest")
	proto.RegisterType((*ServerConfig)(nil), "google.container.v1.ServerConfig")
	proto.RegisterEnum("google.container.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("google.container.v1.Operation_Status", Operation_Status_name, Operation_Status_value)
	proto.RegisterEnum("google.container.v1.Operation_Type", Operation_Type_name, Operation_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterManager service

type ClusterManagerClient interface {
	// Lists all clusters owned by a project in either the specified zone or all zones.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details of a specific cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the cluster creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range is being used by the cluster.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the settings of a specific cluster.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster
	// (e.g. load balancer resources) will not be deleted if they weren't present
	// at the initial create time.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all operations in a project in a specific zone or all zones.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns configuration info about the Container Engine service.
	GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error)
}

type clusterManagerClient struct {
	cc *grpc.ClientConn
}

func NewClusterManagerClient(cc *grpc.ClientConn) ClusterManagerClient {
	return &clusterManagerClient{cc}
}

func (c *clusterManagerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	out := new(ListOperationsResponse)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/ListOperations", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/GetOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error) {
	out := new(ServerConfig)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/GetServerConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterManager service

type ClusterManagerServer interface {
	// Lists all clusters owned by a project in either the specified zone or all zones.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details of a specific cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the cluster creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range is being used by the cluster.
	CreateCluster(context.Context, *CreateClusterRequest) (*Operation, error)
	// Updates the settings of a specific cluster.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster
	// (e.g. load balancer resources) will not be deleted if they weren't present
	// at the initial create time.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*Operation, error)
	// Lists all operations in a project in a specific zone or all zones.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(context.Context, *GetOperationRequest) (*Operation, error)
	// Returns configuration info about the Container Engine service.
	GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error)
}

func RegisterClusterManagerServer(s *grpc.Server, srv ClusterManagerServer) {
	s.RegisterService(&_ClusterManager_serviceDesc, srv)
}

func _ClusterManager_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetOperation(ctx, req.(*GetOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, req.(*GetServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.container.v1.ClusterManager",
	HandlerType: (*ClusterManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _ClusterManager_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterManager_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterManager_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterManager_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterManager_DeleteCluster_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterManager_ListOperations_Handler,
		},
		{
			MethodName: "GetOperation",
			Handler:    _ClusterManager_GetOperation_Handler,
		},
		{
			MethodName: "GetServerConfig",
			Handler:    _ClusterManager_GetServerConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/container/v1/cluster_service.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/container/v1/cluster_service.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1889 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x58, 0x4f, 0x6f, 0x23, 0x49,
	0x15, 0xa7, 0x13, 0xe7, 0xdf, 0xb3, 0x9d, 0x71, 0x2a, 0x99, 0x6c, 0xcb, 0xc0, 0x4e, 0xb6, 0x57,
	0x0b, 0x61, 0x96, 0xb1, 0x27, 0x99, 0x30, 0x2c, 0x33, 0xcb, 0x6a, 0x32, 0xb6, 0x37, 0xf1, 0x6e,
	0x12, 0x5b, 0xed, 0x64, 0x24, 0xb8, 0xb4, 0x2a, 0xee, 0x8a, 0x5d, 0x9b, 0x76, 0x57, 0xd3, 0x55,
	0xf6, 0x2a, 0x33, 0xca, 0x01, 0xce, 0x48, 0x1c, 0x90, 0x10, 0x48, 0x08, 0x21, 0xd8, 0xef, 0xc1,
	0x81, 0x0b, 0xf7, 0xfd, 0x0a, 0x7c, 0x0c, 0x0e, 0xa8, 0xaa, 0xab, 0xdb, 0xed, 0xa4, 0xf3, 0x67,
	0x36, 0x9a, 0x53, 0x5c, 0xef, 0x5f, 0xbd, 0x7a, 0xf5, 0x7b, 0xbf, 0x57, 0x1d, 0xd8, 0xed, 0x31,
	0xd6, 0xf3, 0x48, 0xa5, 0xc7, 0x3c, 0xec, 0xf7, 0x2a, 0x2c, 0xec, 0x55, 0x7b, 0xc4, 0x0f, 0x42,
	0x26, 0x58, 0x35, 0x52, 0xe1, 0x80, 0xf2, 0x6a, 0x97, 0xf9, 0x02, 0x53, 0x9f, 0x84, 0xd5, 0xd1,
	0x46, 0xb5, 0xeb, 0x0d, 0xb9, 0x20, 0xa1, 0xc3, 0x49, 0x38, 0xa2, 0x5d, 0x52, 0x51, 0xd6, 0x68,
	0x59, 0x47, 0x4a, 0x4c, 0x2b, 0xa3, 0x8d, 0x72, 0xf3, 0x76, 0xe1, 0x71, 0x40, 0xab, 0x3a, 0x5a,
	0x97, 0xf9, 0x27, 0xb4, 0x57, 0xc5, 0xbe, 0xcf, 0x04, 0x16, 0x94, 0xf9, 0x3c, 0x8a, 0x6f, 0xfd,
	0xcf, 0x00, 0x38, 0x60, 0x2e, 0xa9, 0x29, 0x03, 0xf4, 0x01, 0x14, 0x06, 0xb8, 0xdb, 0xa7, 0x3e,
	0x71, 0xc4, 0x59, 0x40, 0x4c, 0x63, 0xcd, 0x58, 0x5f, 0xb0, 0xf3, 0x5a, 0x76, 0x78, 0x16, 0x10,
	0xb4, 0x06, 0x05, 0x97, 0xf2, 0x53, 0x87, 0xd3, 0xd7, 0xc4, 0xe9, 0x1d, 0x9b, 0x53, 0x6b, 0xc6,
	0xfa, 0x8c, 0x0d, 0x52, 0xd6, 0xa1, 0xaf, 0xc9, 0xce, 0xb1, 0x0c, 0xc2, 0xf0, 0x50, 0xf4, 0x1d,
	0xde, 0x65, 0x01, 0xe1, 0xe6, 0xf4, 0xda, 0xb4, 0x0c, 0xa2, 0x64, 0x1d, 0x25, 0x42, 0x4d, 0x98,
	0x1f, 0x10, 0x81, 0x5d, 0x2c, 0xb0, 0x99, 0x5b, 0x9b, 0x5e, 0xcf, 0x6f, 0x3e, 0xaa, 0x64, 0x9c,
	0xb4, 0x32, 0x4e, 0xad, 0xb2, 0xaf, 0xed, 0x1b, 0xbe, 0x08, 0xcf, 0xec, 0xc4, 0xbd, 0xfc, 0x1c,
	0x8a, 0x13, 0x2a, 0x54, 0x82, 0xe9, 0x53, 0x72, 0xa6, 0x53, 0x97, 0x3f, 0xd1, 0x0a, 0xcc, 0x8c,
	0xb0, 0x37, 0x24, 0x2a, 0xd7, 0x05, 0x3b, 0x5a, 0x3c, 0x9b, 0xfa, 0xc4, 0xb0, 0xfe, 0x63, 0x00,
	0xec, 0x63, 0x59, 0xf7, 0xed, 0xa1, 0xe8, 0xa3, 0x32, 0xcc, 0x0f, 0x39, 0x09, 0x7d, 0x3c, 0x88,
	0x8f, 0x9e, 0xac, 0xa5, 0x2e, 0xc0, 0x9c, 0x7f, 0xcd, 0x42, 0x57, 0xc7, 0x49, 0xd6, 0x68, 0x0b,
	0x56, 0xe3, 0xeb, 0xeb, 0x62, 0xa7, 0x4b, 0x42, 0x41, 0x4f, 0x68, 0x17, 0x0b, 0x62, 0xba, 0xca,
	0x72, 0x45, 0x6b, 0x6b, 0xb8, 0x36, 0xd6, 0xa1, 0x47, 0x80, 0xba, 0x1e, 0x25, 0xbe, 0x98, 0xf0,
	0x20, 0xca, 0x63, 0x29, 0xd2, 0xa4, 0xcd, 0x7f, 0x08, 0xa0, 0xcd, 0xe5, 0xf1, 0x4e, 0x94, 0xd9,
	0x42, 0x24, 0xf9, 0x92, 0x9c, 0x59, 0xdf, 0x1a, 0x50, 0xd8, 0x76, 0x5d, 0xe6, 0x73, 0x7d, 0x97,
	0xaf, 0x60, 0xb9, 0x2f, 0x44, 0xe0, 0x78, 0x0c, 0xbb, 0xce, 0x31, 0xf6, 0xb0, 0xdf, 0xa5, 0x7e,
	0x4f, 0x9d, 0x2b, 0xbf, 0xf9, 0xa3, 0xcc, 0x72, 0xef, 0x0a, 0x11, 0xec, 0x31, 0xec, 0xbe, 0x8c,
	0xad, 0xed, 0xa5, 0xfe, 0x45, 0x11, 0x3a, 0x85, 0x72, 0x9f, 0x85, 0xf4, 0xb5, 0x74, 0xf4, 0x9c,
	0x80, 0xb9, 0x0e, 0x1e, 0x0a, 0xc6, 0xbb, 0xd8, 0x93, 0xe1, 0xa7, 0x54, 0xf8, 0xec, 0xdb, 0xdc,
	0x4d, 0xdc, 0xda, 0xcc, 0xdd, 0x1e, 0x3b, 0xd9, 0x66, 0xff, 0x0a, 0x8d, 0x55, 0x85, 0xa5, 0x4b,
	0x49, 0xc9, 0xab, 0x70, 0x29, 0xc7, 0xc7, 0x1e, 0x71, 0xd5, 0x71, 0xe6, 0xed, 0x64, 0x6d, 0x3d,
	0x05, 0xf3, 0xaa, 0x6d, 0xae, 0xf5, 0xfb, 0xc3, 0x02, 0xcc, 0xd5, 0xa2, 0x5b, 0x42, 0x08, 0x72,
	0x29, 0x08, 0xa8, 0xdf, 0x68, 0x0d, 0xf2, 0x2e, 0xe1, 0xdd, 0x90, 0x06, 0xb2, 0x7d, 0x34, 0x02,
	0xd2, 0x22, 0xf4, 0x53, 0x40, 0xd4, 0xa7, 0x82, 0x62, 0xcf, 0xf1, 0x99, 0x4b, 0x9c, 0x2e, 0x1b,
	0xfa, 0xc2, 0x9c, 0x56, 0xed, 0x51, 0xd2, 0x9a, 0x08, 0xcf, 0x43, 0x5f, 0xa0, 0x17, 0x90, 0xd7,
	0x56, 0xf2, 0xb2, 0xcc, 0x9c, 0x2a, 0xdb, 0x83, 0x1b, 0x9a, 0xc0, 0x06, 0x7f, 0xdc, 0xab, 0x2f,
	0x20, 0x3f, 0x50, 0xd0, 0x95, 0xf5, 0xef, 0x9b, 0x33, 0xd7, 0x44, 0x18, 0x43, 0xdc, 0x86, 0xc1,
	0x18, 0xee, 0x3f, 0x86, 0x7b, 0x1e, 0xeb, 0xf5, 0xa8, 0xdf, 0x8b, 0x59, 0xc7, 0x9c, 0x55, 0xe7,
	0x5a, 0xd4, 0xe2, 0x4e, 0x24, 0x95, 0x48, 0x1d, 0x30, 0x9f, 0x0a, 0x16, 0xa6, 0x6d, 0xe7, 0x22,
	0xa4, 0x8e, 0x35, 0xb1, 0xb9, 0x09, 0x73, 0x3e, 0x11, 0x5f, 0xb3, 0xf0, 0xd4, 0x9c, 0x57, 0x36,
	0xf1, 0x12, 0x3d, 0x84, 0xa5, 0xb8, 0x51, 0x68, 0x30, 0xda, 0x72, 0xba, 0xd4, 0x0d, 0xcd, 0x05,
	0x65, 0x73, 0x4f, 0x2b, 0x9a, 0xc1, 0x68, 0xab, 0x46, 0xdd, 0x10, 0x7d, 0x0e, 0x45, 0xac, 0xf0,
	0x1c, 0xd7, 0x08, 0xd4, 0x09, 0x3f, 0xc8, 0x3c, 0x61, 0x1a, 0xf9, 0x76, 0x01, 0xa7, 0xfb, 0xe0,
	0x7d, 0x00, 0x3e, 0x3c, 0x8e, 0x13, 0xca, 0xab, 0xcd, 0x52, 0x12, 0xf4, 0x7d, 0x58, 0xe0, 0xc4,
	0x3b, 0x71, 0x3c, 0xea, 0x9f, 0xea, 0x7e, 0x9d, 0x97, 0x82, 0x3d, 0xea, 0x9f, 0x4a, 0x28, 0xbc,
	0x66, 0x7e, 0xdc, 0x95, 0xea, 0xb7, 0x84, 0x11, 0xf1, 0xdd, 0x80, 0x51, 0x5f, 0xe8, 0x36, 0x4c,
	0xd6, 0xe8, 0x29, 0xbc, 0x17, 0x83, 0x20, 0x3e, 0xe8, 0x88, 0x84, 0x5c, 0x42, 0xa6, 0xa7, 0x4c,
	0xef, 0x6b, 0xb5, 0xc6, 0xda, 0xab, 0x48, 0xa9, 0x18, 0x64, 0x18, 0x86, 0xb2, 0xbb, 0xf5, 0xa5,
	0xc6, 0x6e, 0x7d, 0xcd, 0x20, 0x91, 0x36, 0xba, 0xc9, 0xd8, 0xeb, 0x31, 0xc4, 0xf2, 0x08, 0x72,
	0xb1, 0x0f, 0x55, 0x3e, 0x48, 0xeb, 0x24, 0x7e, 0x62, 0x8f, 0x07, 0x90, 0xef, 0x86, 0x04, 0x0b,
	0xe2, 0x08, 0x3a, 0x20, 0xe6, 0x57, 0x51, 0x35, 0x22, 0xd1, 0x21, 0x1d, 0x10, 0xf4, 0x1c, 0x66,
	0xb9, 0xc0, 0x62, 0xc8, 0xcd, 0xd3, 0x35, 0x63, 0x7d, 0x71, 0xf3, 0xc3, 0xcc, 0x72, 0xeb, 0xec,
	0x2b, 0x1d, 0x65, 0x6a, 0x6b, 0x17, 0xf4, 0x11, 0x2c, 0x46, 0xbf, 0x9c, 0x01, 0xe1, 0x1c, 0xf7,
	0x88, 0xe9, 0xa9, 0x0d, 0x8a, 0x91, 0x74, 0x3f, 0x12, 0xa2, 0x47, 0xb0, 0xac, 0xd2, 0x4d, 0x20,
	0xa0, 0x86, 0x89, 0x39, 0x88, 0x5a, 0x45, 0xaa, 0x62, 0x10, 0xc8, 0x89, 0x22, 0x1b, 0x4b, 0x43,
	0x8e, 0xa7, 0x50, 0xe3, 0xab, 0xc8, 0xa5, 0x58, 0x93, 0xc0, 0xa6, 0x02, 0xcb, 0xd4, 0xe7, 0x02,
	0xfb, 0x5d, 0xe2, 0xf4, 0x42, 0x36, 0x0c, 0x9c, 0x61, 0xe8, 0x71, 0x93, 0xa9, 0x21, 0xb4, 0x14,
	0xab, 0x76, 0xa4, 0xe6, 0x28, 0xf4, 0xb8, 0x8c, 0x3e, 0x51, 0xc3, 0xa8, 0x6d, 0x83, 0x28, 0x97,
	0x54, 0x05, 0x55, 0xdb, 0x5a, 0x14, 0x66, 0xa3, 0x33, 0xa3, 0x55, 0x40, 0x9d, 0xc3, 0xed, 0xc3,
	0xa3, 0x8e, 0x73, 0x74, 0xd0, 0x69, 0x37, 0x6a, 0xcd, 0xcf, 0x9b, 0x8d, 0x7a, 0xe9, 0x7b, 0xa8,
	0x04, 0x85, 0xb6, 0xdd, 0x7a, 0xd5, 0xec, 0x34, 0x5b, 0x07, 0xcd, 0x83, 0x9d, 0x92, 0x81, 0xf2,
	0x30, 0x67, 0x1f, 0x1d, 0xa8, 0xc5, 0x14, 0xba, 0x07, 0x79, 0xbb, 0x51, 0x6b, 0x1d, 0xd4, 0x9a,
	0x7b, 0x52, 0x30, 0x8d, 0x0a, 0x30, 0xdf, 0x39, 0x6c, 0xb5, 0xdb, 0x72, 0x95, 0x43, 0x0b, 0x30,
	0xd3, 0xb0, 0xed, 0x96, 0x5d, 0x9a, 0xb1, 0x7e, 0x3f, 0x05, 0x45, 0x5d, 0xe7, 0xa3, 0xc0, 0x95,
	0x13, 0xe0, 0x31, 0xac, 0xb8, 0x84, 0xd3, 0x90, 0xb8, 0x93, 0xd7, 0x9d, 0x8b, 0xae, 0x5b, 0xeb,
	0xd2, 0xd7, 0xfd, 0x29, 0x94, 0x63, 0x8f, 0x8c, 0x06, 0x9e, 0x51, 0x7e, 0xa6, 0xb6, 0xd8, 0xbf,
	0xd4, 0xc7, 0x47, 0x70, 0x3f, 0xf6, 0x9e, 0xec, 0xc4, 0xd9, 0xdb, 0x76, 0xe2, 0xb2, 0xf6, 0x9f,
	0x18, 0x4c, 0x5b, 0xb0, 0x9a, 0x24, 0x35, 0x89, 0x75, 0x3d, 0x2d, 0xe3, 0x84, 0xd2, 0x58, 0xb7,
	0xfe, 0x9d, 0x83, 0x85, 0x56, 0x40, 0x42, 0xf5, 0x7c, 0xc9, 0xa4, 0xe8, 0xb8, 0x57, 0xa7, 0x52,
	0xbd, 0xfa, 0x05, 0x2c, 0xb2, 0xd8, 0x29, 0x7a, 0xd2, 0x4c, 0x5f, 0x03, 0xeb, 0x24, 0x7e, 0x45,
	0x3e, 0x75, 0xec, 0x62, 0xe2, 0xaa, 0x5e, 0x3e, 0xbf, 0x4c, 0x5a, 0x23, 0xa7, 0x62, 0x7c, 0x74,
	0x43, 0x8c, 0x0b, 0xcd, 0xb1, 0x0a, 0xb3, 0x2e, 0x11, 0x98, 0x7a, 0x9a, 0x14, 0xf5, 0x2a, 0xa3,
	0x69, 0x66, 0xb2, 0x9a, 0x66, 0x82, 0xa6, 0x66, 0x2f, 0xd0, 0xd4, 0x03, 0xc8, 0x0b, 0x1c, 0xf6,
	0x88, 0x88, 0xd4, 0x11, 0x33, 0x43, 0x24, 0x92, 0x06, 0x56, 0xfd, 0x46, 0xdc, 0xe6, 0x61, 0xae,
	0xdd, 0x38, 0xa8, 0x67, 0x40, 0x76, 0x1e, 0x72, 0xf5, 0xd6, 0x41, 0xa3, 0x34, 0x6d, 0xfd, 0xcb,
	0x80, 0x9c, 0x2a, 0xc5, 0x0a, 0x94, 0x0e, 0x7f, 0xd5, 0x6e, 0x5c, 0x08, 0x81, 0x60, 0xb1, 0x66,
	0x37, 0xb6, 0x0f, 0x1b, 0x4e, 0x6d, 0xef, 0xa8, 0x73, 0xd8, 0xb0, 0x4b, 0x86, 0x94, 0xd5, 0x1b,
	0x7b, 0x8d, 0x94, 0x6c, 0x4a, 0xca, 0x8e, 0xda, 0x3b, 0xf6, 0x76, 0xbd, 0xe1, 0xec, 0x6f, 0x2b,
	0xd9, 0x34, 0x5a, 0x82, 0x62, 0x2c, 0x3b, 0x68, 0xd5, 0x1b, 0x9d, 0x52, 0x4e, 0x9a, 0xd9, 0x8d,
	0xf6, 0x76, 0xd3, 0x4e, 0x5c, 0x67, 0x22, 0xd7, 0x7a, 0x7a, 0x8b, 0x59, 0x99, 0x8c, 0xde, 0x56,
	0x7a, 0x3a, 0xed, 0x56, 0x6b, 0xaf, 0x34, 0x27, 0xa5, 0x7a, 0xe3, 0xb1, 0x74, 0xde, 0xfa, 0xad,
	0x01, 0x2b, 0x35, 0xc5, 0x76, 0xba, 0xb5, 0x6c, 0xf2, 0x9b, 0x21, 0xe1, 0x42, 0xbe, 0xae, 0x82,
	0x90, 0x7d, 0x45, 0xba, 0xc2, 0xa1, 0xae, 0x86, 0xd5, 0x82, 0x96, 0x34, 0xdd, 0x4c, 0x6c, 0x3d,
	0x85, 0x39, 0xcd, 0xf1, 0x0a, 0x54, 0xf9, 0xcd, 0x1f, 0x5c, 0xc7, 0x95, 0x76, 0x6c, 0x6c, 0x11,
	0x58, 0xda, 0x21, 0xe2, 0xee, 0xfb, 0xab, 0x07, 0xa1, 0x1e, 0xa6, 0xae, 0x4a, 0x41, 0x3d, 0x08,
	0xa3, 0x29, 0xea, 0x5a, 0xdf, 0x18, 0xb0, 0x12, 0x11, 0xc7, 0xbb, 0xde, 0x0a, 0x3d, 0x83, 0xd9,
	0xa1, 0xda, 0x49, 0xbf, 0x63, 0xac, 0xeb, 0x0a, 0x11, 0xe5, 0x64, 0x6b, 0x0f, 0xab, 0x0f, 0x2b,
	0x75, 0xe2, 0x91, 0x77, 0x9f, 0xa5, 0xb5, 0x0b, 0xcb, 0x7b, 0x94, 0xc7, 0x85, 0xe7, 0xdf, 0x7d,
	0x23, 0x6b, 0x08, 0x2b, 0x93, 0x91, 0x78, 0xc0, 0x7c, 0x4e, 0xd0, 0x27, 0x30, 0xaf, 0xb7, 0xe3,
	0xa6, 0xa1, 0x3e, 0x6b, 0xae, 0x87, 0x44, 0x62, 0x8d, 0x3e, 0x84, 0xe2, 0x80, 0x72, 0x2e, 0xd9,
	0x59, 0xee, 0xc0, 0xcd, 0x29, 0x35, 0xaf, 0x0a, 0x5a, 0xf8, 0x6b, 0x29, 0xb3, 0x4e, 0x61, 0x79,
	0x87, 0x88, 0x84, 0x60, 0xee, 0x50, 0x29, 0xf9, 0x89, 0x96, 0xd0, 0x62, 0x52, 0xab, 0x7c, 0x22,
	0x6b, 0xba, 0xd6, 0x17, 0x70, 0x5f, 0x9e, 0x31, 0xd9, 0xed, 0x2e, 0xf5, 0x3a, 0x87, 0xd5, 0x8b,
	0xb1, 0x74, 0xc5, 0x3e, 0x03, 0x48, 0x36, 0x8d, 0x6b, 0xf6, 0xfe, 0xf5, 0xbc, 0x6a, 0xa7, 0x3c,
	0x6e, 0x57, 0xb7, 0x2f, 0x61, 0x75, 0x87, 0x08, 0x39, 0xd5, 0x48, 0xa8, 0x07, 0xd3, 0x77, 0x3f,
	0xcb, 0x08, 0x0a, 0xe9, 0x48, 0xf2, 0xc5, 0xe7, 0x92, 0x13, 0x3c, 0xf4, 0xc4, 0xa5, 0x17, 0x5f,
	0x14, 0xef, 0xbe, 0x56, 0x5f, 0x78, 0xf1, 0x55, 0x60, 0x79, 0x84, 0x3d, 0x3a, 0x39, 0xca, 0xe3,
	0x8f, 0xe5, 0x25, 0xa5, 0x4a, 0x4d, 0x72, 0xbe, 0xf9, 0x17, 0x80, 0x45, 0x1d, 0x62, 0x1f, 0xfb,
	0xb8, 0x47, 0x42, 0xf4, 0x57, 0x03, 0x0a, 0x69, 0x1c, 0xa2, 0xf5, 0xcc, 0xca, 0x65, 0x80, 0xbe,
	0xfc, 0x93, 0x5b, 0x58, 0x46, 0x57, 0x64, 0xfd, 0xfc, 0x77, 0xdf, 0xfe, 0xf7, 0x8f, 0x53, 0x1b,
	0xa8, 0x5a, 0x1d, 0x6d, 0x54, 0x75, 0x6d, 0x78, 0xf5, 0xcd, 0xb8, 0x6e, 0xe7, 0x55, 0x55, 0xfa,
	0xea, 0x1b, 0xf9, 0xe7, 0xbc, 0x9a, 0x60, 0xfa, 0xcf, 0x06, 0xc0, 0x98, 0xe8, 0x50, 0xf6, 0x27,
	0xe7, 0x25, 0x26, 0x2c, 0x5f, 0xdb, 0x32, 0x56, 0x5d, 0x65, 0xf3, 0x19, 0xfa, 0xf4, 0x2d, 0xb3,
	0xa9, 0xbe, 0x19, 0x53, 0xc3, 0x39, 0xfa, 0x93, 0x01, 0xc5, 0x89, 0x31, 0x80, 0xb2, 0x0b, 0x92,
	0x35, 0x2a, 0xca, 0x37, 0xe0, 0xd3, 0x7a, 0xa6, 0x52, 0xdc, 0xb2, 0xde, 0xb6, 0x60, 0xcf, 0x8c,
	0x87, 0xe8, 0x9f, 0x06, 0x14, 0x27, 0x48, 0xfb, 0x8a, 0xc4, 0xb2, 0x88, 0xfd, 0xc6, 0xc4, 0x76,
	0x54, 0x62, 0xdb, 0xe5, 0x3b, 0xd5, 0x4e, 0x66, 0xf9, 0x77, 0x03, 0x8a, 0x13, 0xa4, 0x7d, 0x45,
	0x96, 0x59, 0xc4, 0x7e, 0x63, 0x96, 0xfa, 0x86, 0x1f, 0xde, 0xed, 0x86, 0xbf, 0x31, 0x60, 0x71,
	0x92, 0x73, 0xd0, 0xc3, 0x2b, 0x31, 0x7f, 0x89, 0xe4, 0xca, 0x1f, 0xdf, 0xca, 0x56, 0x77, 0xc8,
	0x2f, 0x54, 0xc6, 0x4f, 0xd0, 0xc6, 0x2d, 0x33, 0x4e, 0xf1, 0xd7, 0x3f, 0x0c, 0x28, 0xa4, 0x39,
	0xfd, 0x8a, 0x16, 0xce, 0xa0, 0xfd, 0x1b, 0xeb, 0xb8, 0xab, 0xb2, 0x7a, 0x89, 0x5e, 0xbc, 0x75,
	0x56, 0xd5, 0x37, 0xe9, 0xe1, 0x70, 0x8e, 0xfe, 0x66, 0xc0, 0xbd, 0x0b, 0x04, 0x8a, 0x3e, 0xbe,
	0x2a, 0xcf, 0x0c, 0x9a, 0x2d, 0x67, 0x7f, 0x29, 0xa4, 0x2d, 0xad, 0xe7, 0x2a, 0xdb, 0x9f, 0xa1,
	0x27, 0xb7, 0xcc, 0x96, 0x2b, 0xe7, 0xe8, 0x7b, 0xe4, 0xe5, 0x63, 0x78, 0xaf, 0xcb, 0x06, 0x59,
	0x9b, 0xbc, 0x5c, 0xd6, 0xe8, 0xd3, 0xdf, 0x34, 0xed, 0x90, 0x09, 0xd6, 0x36, 0x8e, 0x67, 0xd5,
	0xbf, 0x3f, 0x9f, 0xfc, 0x3f, 0x00, 0x00, 0xff, 0xff, 0xb0, 0xc9, 0x54, 0x5a, 0xaa, 0x15, 0x00,
	0x00,
}
