// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/storagetransfer/v1/transfer.proto
// DO NOT EDIT!

/*
Package google_storagetransfer_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/storagetransfer/v1/transfer.proto
	google.golang.org/genproto/googleapis/storagetransfer/v1/transfer_types.proto

It has these top-level messages:
	GetGoogleServiceAccountRequest
	CreateTransferJobRequest
	UpdateTransferJobRequest
	GetTransferJobRequest
	ListTransferJobsRequest
	ListTransferJobsResponse
	PauseTransferOperationRequest
	ResumeTransferOperationRequest
	GoogleServiceAccount
	AwsAccessKey
	ObjectConditions
	GcsData
	AwsS3Data
	HttpData
	TransferOptions
	TransferSpec
	Schedule
	TransferJob
	ErrorLogEntry
	ErrorSummary
	TransferCounters
	TransferOperation
*/
package google_storagetransfer_v1 // import "google.golang.org/genproto/googleapis/storagetransfer/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "google.golang.org/genproto/protobuf"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request passed to GetGoogleServiceAccount.
type GetGoogleServiceAccountRequest struct {
	// The ID of the Google Cloud Platform Console project that the Google service
	// account is associated with.
	// Required.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
}

func (m *GetGoogleServiceAccountRequest) Reset()                    { *m = GetGoogleServiceAccountRequest{} }
func (m *GetGoogleServiceAccountRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGoogleServiceAccountRequest) ProtoMessage()               {}
func (*GetGoogleServiceAccountRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Request passed to CreateTransferJob.
type CreateTransferJobRequest struct {
	// The job to create.
	// Required.
	TransferJob *TransferJob `protobuf:"bytes,1,opt,name=transfer_job,json=transferJob" json:"transfer_job,omitempty"`
}

func (m *CreateTransferJobRequest) Reset()                    { *m = CreateTransferJobRequest{} }
func (m *CreateTransferJobRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateTransferJobRequest) ProtoMessage()               {}
func (*CreateTransferJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *CreateTransferJobRequest) GetTransferJob() *TransferJob {
	if m != nil {
		return m.TransferJob
	}
	return nil
}

// Request passed to UpdateTransferJob.
type UpdateTransferJobRequest struct {
	// The name of job to update.
	// Required.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName" json:"job_name,omitempty"`
	// The ID of the Google Cloud Platform Console project that owns the job.
	// Required.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The job to update.
	// Required.
	TransferJob *TransferJob `protobuf:"bytes,3,opt,name=transfer_job,json=transferJob" json:"transfer_job,omitempty"`
	// The field mask of the fields in `transferJob` that are to be updated in
	// this request.  Fields in `transferJob` that can be updated are:
	// `description`, `transferSpec`, and `status`.  To update the `transferSpec`
	// of the job, a complete transfer specification has to be provided. An
	// incomplete specification which misses any required fields will be rejected
	// with the error `INVALID_ARGUMENT`.
	UpdateTransferJobFieldMask *google_protobuf2.FieldMask `protobuf:"bytes,4,opt,name=update_transfer_job_field_mask,json=updateTransferJobFieldMask" json:"update_transfer_job_field_mask,omitempty"`
}

func (m *UpdateTransferJobRequest) Reset()                    { *m = UpdateTransferJobRequest{} }
func (m *UpdateTransferJobRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateTransferJobRequest) ProtoMessage()               {}
func (*UpdateTransferJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *UpdateTransferJobRequest) GetTransferJob() *TransferJob {
	if m != nil {
		return m.TransferJob
	}
	return nil
}

func (m *UpdateTransferJobRequest) GetUpdateTransferJobFieldMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateTransferJobFieldMask
	}
	return nil
}

// Request passed to GetTransferJob.
type GetTransferJobRequest struct {
	// The job to get.
	// Required.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName" json:"job_name,omitempty"`
	// The ID of the Google Cloud Platform Console project that owns the job.
	// Required.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
}

func (m *GetTransferJobRequest) Reset()                    { *m = GetTransferJobRequest{} }
func (m *GetTransferJobRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTransferJobRequest) ProtoMessage()               {}
func (*GetTransferJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// `project_id`, `job_names`, and `job_statuses` are query parameters that can
// be specified when listing transfer jobs.
type ListTransferJobsRequest struct {
	// A list of query parameters specified as JSON text in the form of
	// {"project_id":"my_project_id",
	// "job_names":["jobid1","jobid2",...],
	// "job_statuses":["status1","status2",...]}.
	// Since `job_names` and `job_statuses` support multiple values, their values
	// must be specified with array notation. `project_id` is required. `job_names`
	// and `job_statuses` are optional.  The valid values for `job_statuses` are
	// case-insensitive: `ENABLED`, `DISABLED`, and `DELETED`.
	Filter string `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	// The list page size. The max allowed value is 256.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The list page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTransferJobsRequest) Reset()                    { *m = ListTransferJobsRequest{} }
func (m *ListTransferJobsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTransferJobsRequest) ProtoMessage()               {}
func (*ListTransferJobsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Response from ListTransferJobs.
type ListTransferJobsResponse struct {
	// A list of transfer jobs.
	TransferJobs []*TransferJob `protobuf:"bytes,1,rep,name=transfer_jobs,json=transferJobs" json:"transfer_jobs,omitempty"`
	// The list next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTransferJobsResponse) Reset()                    { *m = ListTransferJobsResponse{} }
func (m *ListTransferJobsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTransferJobsResponse) ProtoMessage()               {}
func (*ListTransferJobsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ListTransferJobsResponse) GetTransferJobs() []*TransferJob {
	if m != nil {
		return m.TransferJobs
	}
	return nil
}

// Request passed to PauseTransferOperation.
type PauseTransferOperationRequest struct {
	// The name of the transfer operation.
	// Required.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *PauseTransferOperationRequest) Reset()                    { *m = PauseTransferOperationRequest{} }
func (m *PauseTransferOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*PauseTransferOperationRequest) ProtoMessage()               {}
func (*PauseTransferOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// Request passed to ResumeTransferOperation.
type ResumeTransferOperationRequest struct {
	// The name of the transfer operation.
	// Required.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *ResumeTransferOperationRequest) Reset()                    { *m = ResumeTransferOperationRequest{} }
func (m *ResumeTransferOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*ResumeTransferOperationRequest) ProtoMessage()               {}
func (*ResumeTransferOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func init() {
	proto.RegisterType((*GetGoogleServiceAccountRequest)(nil), "google.storagetransfer.v1.GetGoogleServiceAccountRequest")
	proto.RegisterType((*CreateTransferJobRequest)(nil), "google.storagetransfer.v1.CreateTransferJobRequest")
	proto.RegisterType((*UpdateTransferJobRequest)(nil), "google.storagetransfer.v1.UpdateTransferJobRequest")
	proto.RegisterType((*GetTransferJobRequest)(nil), "google.storagetransfer.v1.GetTransferJobRequest")
	proto.RegisterType((*ListTransferJobsRequest)(nil), "google.storagetransfer.v1.ListTransferJobsRequest")
	proto.RegisterType((*ListTransferJobsResponse)(nil), "google.storagetransfer.v1.ListTransferJobsResponse")
	proto.RegisterType((*PauseTransferOperationRequest)(nil), "google.storagetransfer.v1.PauseTransferOperationRequest")
	proto.RegisterType((*ResumeTransferOperationRequest)(nil), "google.storagetransfer.v1.ResumeTransferOperationRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for StorageTransferService service

type StorageTransferServiceClient interface {
	// Returns the Google service account that is used by Storage Transfer
	// Service to access buckets in the project where transfers
	// run or in other projects. Each Google service account is associated
	// with one Google Cloud Platform Console project. Users
	// should add this service account to the Google Cloud Storage bucket
	// ACLs to grant access to Storage Transfer Service. This service
	// account is created and owned by Storage Transfer Service and can
	// only be used by Storage Transfer Service.
	GetGoogleServiceAccount(ctx context.Context, in *GetGoogleServiceAccountRequest, opts ...grpc.CallOption) (*GoogleServiceAccount, error)
	// Creates a transfer job that runs periodically.
	CreateTransferJob(ctx context.Context, in *CreateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Updates a transfer job. Updating a job's transfer spec does not affect
	// transfer operations that are running already. Updating the scheduling
	// of a job is not allowed.
	UpdateTransferJob(ctx context.Context, in *UpdateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Gets a transfer job.
	GetTransferJob(ctx context.Context, in *GetTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Lists transfer jobs.
	ListTransferJobs(ctx context.Context, in *ListTransferJobsRequest, opts ...grpc.CallOption) (*ListTransferJobsResponse, error)
	// Pauses a transfer operation.
	PauseTransferOperation(ctx context.Context, in *PauseTransferOperationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Resumes a transfer operation that is paused.
	ResumeTransferOperation(ctx context.Context, in *ResumeTransferOperationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
}

type storageTransferServiceClient struct {
	cc *grpc.ClientConn
}

func NewStorageTransferServiceClient(cc *grpc.ClientConn) StorageTransferServiceClient {
	return &storageTransferServiceClient{cc}
}

func (c *storageTransferServiceClient) GetGoogleServiceAccount(ctx context.Context, in *GetGoogleServiceAccountRequest, opts ...grpc.CallOption) (*GoogleServiceAccount, error) {
	out := new(GoogleServiceAccount)
	err := grpc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/GetGoogleServiceAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) CreateTransferJob(ctx context.Context, in *CreateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := grpc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/CreateTransferJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) UpdateTransferJob(ctx context.Context, in *UpdateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := grpc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/UpdateTransferJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) GetTransferJob(ctx context.Context, in *GetTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := grpc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/GetTransferJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) ListTransferJobs(ctx context.Context, in *ListTransferJobsRequest, opts ...grpc.CallOption) (*ListTransferJobsResponse, error) {
	out := new(ListTransferJobsResponse)
	err := grpc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/ListTransferJobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) PauseTransferOperation(ctx context.Context, in *PauseTransferOperationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/PauseTransferOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) ResumeTransferOperation(ctx context.Context, in *ResumeTransferOperationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/ResumeTransferOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for StorageTransferService service

type StorageTransferServiceServer interface {
	// Returns the Google service account that is used by Storage Transfer
	// Service to access buckets in the project where transfers
	// run or in other projects. Each Google service account is associated
	// with one Google Cloud Platform Console project. Users
	// should add this service account to the Google Cloud Storage bucket
	// ACLs to grant access to Storage Transfer Service. This service
	// account is created and owned by Storage Transfer Service and can
	// only be used by Storage Transfer Service.
	GetGoogleServiceAccount(context.Context, *GetGoogleServiceAccountRequest) (*GoogleServiceAccount, error)
	// Creates a transfer job that runs periodically.
	CreateTransferJob(context.Context, *CreateTransferJobRequest) (*TransferJob, error)
	// Updates a transfer job. Updating a job's transfer spec does not affect
	// transfer operations that are running already. Updating the scheduling
	// of a job is not allowed.
	UpdateTransferJob(context.Context, *UpdateTransferJobRequest) (*TransferJob, error)
	// Gets a transfer job.
	GetTransferJob(context.Context, *GetTransferJobRequest) (*TransferJob, error)
	// Lists transfer jobs.
	ListTransferJobs(context.Context, *ListTransferJobsRequest) (*ListTransferJobsResponse, error)
	// Pauses a transfer operation.
	PauseTransferOperation(context.Context, *PauseTransferOperationRequest) (*google_protobuf1.Empty, error)
	// Resumes a transfer operation that is paused.
	ResumeTransferOperation(context.Context, *ResumeTransferOperationRequest) (*google_protobuf1.Empty, error)
}

func RegisterStorageTransferServiceServer(s *grpc.Server, srv StorageTransferServiceServer) {
	s.RegisterService(&_StorageTransferService_serviceDesc, srv)
}

func _StorageTransferService_GetGoogleServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).GetGoogleServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/GetGoogleServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).GetGoogleServiceAccount(ctx, req.(*GetGoogleServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_CreateTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).CreateTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/CreateTransferJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).CreateTransferJob(ctx, req.(*CreateTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_UpdateTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).UpdateTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/UpdateTransferJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).UpdateTransferJob(ctx, req.(*UpdateTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_GetTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).GetTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/GetTransferJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).GetTransferJob(ctx, req.(*GetTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_ListTransferJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).ListTransferJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/ListTransferJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).ListTransferJobs(ctx, req.(*ListTransferJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_PauseTransferOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseTransferOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).PauseTransferOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/PauseTransferOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).PauseTransferOperation(ctx, req.(*PauseTransferOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_ResumeTransferOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeTransferOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).ResumeTransferOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/ResumeTransferOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).ResumeTransferOperation(ctx, req.(*ResumeTransferOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _StorageTransferService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.storagetransfer.v1.StorageTransferService",
	HandlerType: (*StorageTransferServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGoogleServiceAccount",
			Handler:    _StorageTransferService_GetGoogleServiceAccount_Handler,
		},
		{
			MethodName: "CreateTransferJob",
			Handler:    _StorageTransferService_CreateTransferJob_Handler,
		},
		{
			MethodName: "UpdateTransferJob",
			Handler:    _StorageTransferService_UpdateTransferJob_Handler,
		},
		{
			MethodName: "GetTransferJob",
			Handler:    _StorageTransferService_GetTransferJob_Handler,
		},
		{
			MethodName: "ListTransferJobs",
			Handler:    _StorageTransferService_ListTransferJobs_Handler,
		},
		{
			MethodName: "PauseTransferOperation",
			Handler:    _StorageTransferService_PauseTransferOperation_Handler,
		},
		{
			MethodName: "ResumeTransferOperation",
			Handler:    _StorageTransferService_ResumeTransferOperation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/storagetransfer/v1/transfer.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/storagetransfer/v1/transfer.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 768 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x55, 0xed, 0x4e, 0xd4, 0x4c,
	0x14, 0xce, 0xf0, 0xf5, 0xc2, 0x00, 0xef, 0x0b, 0x93, 0xbc, 0x4b, 0xa9, 0x61, 0x43, 0x4a, 0xb2,
	0xe2, 0x6a, 0x5a, 0xd9, 0x25, 0x51, 0x49, 0x8c, 0x11, 0xa3, 0x1b, 0x54, 0x14, 0x17, 0xfc, 0x6b,
	0x33, 0xbb, 0x7b, 0xb6, 0x76, 0xd9, 0x76, 0x6a, 0x67, 0x4a, 0x04, 0xc2, 0x1f, 0x6f, 0xc0, 0x44,
	0x63, 0x62, 0x62, 0x4c, 0xbc, 0x09, 0xaf, 0xc4, 0x5b, 0xf0, 0x22, 0xf4, 0x97, 0xa6, 0xd3, 0x76,
	0x29, 0xfb, 0x51, 0x40, 0xfc, 0x43, 0x3a, 0x73, 0xe6, 0x3c, 0xcf, 0x73, 0xce, 0xe1, 0x39, 0x8b,
	0x2b, 0x16, 0x63, 0x56, 0x1b, 0x74, 0x8b, 0xb5, 0xa9, 0x6b, 0xe9, 0xcc, 0xb7, 0x0c, 0x0b, 0x5c,
	0xcf, 0x67, 0x82, 0x19, 0x51, 0x88, 0x7a, 0x36, 0x37, 0xb8, 0x60, 0x3e, 0xb5, 0x40, 0xf8, 0xd4,
	0xe5, 0x4d, 0xf0, 0x8d, 0xbd, 0x15, 0x23, 0xf9, 0xd6, 0xe5, 0x63, 0x32, 0x1f, 0x03, 0x75, 0xbd,
	0xd4, 0xf7, 0x56, 0xd4, 0x8d, 0xb3, 0x71, 0x50, 0xcf, 0x36, 0x38, 0xf8, 0x7b, 0x76, 0x1d, 0xea,
	0xcc, 0x6d, 0xda, 0x96, 0x41, 0x5d, 0x97, 0x09, 0x2a, 0x6c, 0xe6, 0xf2, 0x88, 0x45, 0x2d, 0x5b,
	0xb6, 0x78, 0x19, 0xd4, 0xf4, 0x3a, 0x73, 0x8c, 0x08, 0xce, 0x90, 0x81, 0x5a, 0xd0, 0x34, 0x3c,
	0xb1, 0xef, 0x01, 0x37, 0xc0, 0xf1, 0xc4, 0x7e, 0xf4, 0x37, 0x4e, 0x5a, 0xcd, 0xe0, 0xef, 0x64,
	0x37, 0x6d, 0x68, 0x37, 0x4c, 0x87, 0xf2, 0xdd, 0x38, 0x6b, 0xf3, 0xc2, 0x9d, 0x31, 0xa5, 0xa0,
	0x08, 0x4e, 0xbb, 0x83, 0xf3, 0x15, 0x10, 0x15, 0x99, 0xb8, 0x1d, 0x55, 0x79, 0xb7, 0x5e, 0x67,
	0x81, 0x2b, 0xaa, 0xf0, 0x2a, 0x00, 0x2e, 0xc8, 0x02, 0xc6, 0x9e, 0xcf, 0x5a, 0x50, 0x17, 0xa6,
	0xdd, 0x50, 0xd0, 0x22, 0x5a, 0x9e, 0xa8, 0x4e, 0xc4, 0x37, 0x1b, 0x0d, 0x0d, 0xb0, 0x72, 0xcf,
	0x07, 0x2a, 0x60, 0x27, 0x86, 0x7f, 0xc8, 0x6a, 0x49, 0xea, 0x06, 0x9e, 0xea, 0x90, 0xb6, 0x58,
	0x4d, 0x26, 0x4f, 0x96, 0x0a, 0xfa, 0xc0, 0x99, 0xe8, 0x69, 0x90, 0x49, 0x71, 0x7c, 0xd0, 0x7e,
	0x21, 0xac, 0x3c, 0xf7, 0x1a, 0xfd, 0x79, 0xe6, 0xf1, 0x78, 0x8b, 0xd5, 0x4c, 0x97, 0x3a, 0x10,
	0x0b, 0xfc, 0xa7, 0xc5, 0x6a, 0x4f, 0xa8, 0x03, 0x5d, 0xea, 0x87, 0xba, 0xd4, 0xf7, 0x28, 0x1c,
	0xfe, 0x63, 0x85, 0xe4, 0x05, 0xce, 0x07, 0x52, 0xa0, 0x99, 0x46, 0x34, 0x8f, 0x07, 0xa8, 0x8c,
	0x48, 0x70, 0x35, 0x01, 0x4f, 0x66, 0xac, 0x3f, 0x08, 0x9f, 0x6c, 0x52, 0xbe, 0x5b, 0x55, 0x83,
	0xee, 0x12, 0x3b, 0x31, 0xed, 0x19, 0xfe, 0xbf, 0x02, 0xe2, 0x6f, 0x56, 0xaf, 0x39, 0x78, 0xee,
	0xb1, 0xcd, 0xd3, 0x98, 0x3c, 0x01, 0xcd, 0xe1, 0xb1, 0xa6, 0xdd, 0x16, 0xe0, 0xc7, 0x90, 0xf1,
	0x89, 0x5c, 0xc2, 0x13, 0x1e, 0xb5, 0xc0, 0xe4, 0xf6, 0x01, 0xc8, 0x82, 0x46, 0xab, 0xe3, 0xe1,
	0xc5, 0xb6, 0x7d, 0x10, 0xd1, 0x85, 0x41, 0xc1, 0x76, 0xc1, 0x55, 0x46, 0x63, 0x3a, 0x6a, 0xc1,
	0x4e, 0x78, 0xa1, 0xbd, 0x45, 0x58, 0xe9, 0xe5, 0xe3, 0x1e, 0x73, 0x39, 0x90, 0x47, 0x78, 0x3a,
	0xdd, 0x37, 0xae, 0xa0, 0xc5, 0xe1, 0x73, 0x8c, 0x62, 0x2a, 0x35, 0x0a, 0x4e, 0x0a, 0xf8, 0x3f,
	0x17, 0x5e, 0x0b, 0x33, 0xa5, 0x26, 0x2a, 0x7e, 0x3a, 0xbc, 0xde, 0xea, 0x28, 0x2a, 0xe3, 0x85,
	0x2d, 0x1a, 0xf0, 0x4e, 0xc3, 0x9f, 0x7a, 0xe0, 0x4b, 0x63, 0x27, 0x6d, 0x20, 0x78, 0x24, 0xd5,
	0x57, 0xf9, 0xad, 0xad, 0xe2, 0x7c, 0x15, 0x78, 0xe0, 0x9c, 0x2b, 0xab, 0xf4, 0x73, 0x1c, 0xe7,
	0xb6, 0xa3, 0x1a, 0x92, 0xbc, 0xd8, 0x6f, 0xe4, 0x2b, 0xc2, 0x73, 0x03, 0x4c, 0x48, 0x6e, 0x65,
	0xd4, 0x9f, 0x6d, 0x5c, 0xd5, 0xc8, 0x4a, 0xed, 0x93, 0xa7, 0xe9, 0x6f, 0xbe, 0x7d, 0x7f, 0x3f,
	0xb4, 0x4c, 0x0a, 0xe1, 0xb6, 0xb0, 0xfa, 0xbc, 0xe0, 0xc6, 0xe1, 0xf1, 0xbf, 0xd3, 0x11, 0xf9,
	0x88, 0xf0, 0x6c, 0x8f, 0xf7, 0x49, 0x39, 0x83, 0x76, 0xd0, 0xa6, 0x50, 0xcf, 0x38, 0x66, 0xad,
	0x20, 0x25, 0x2e, 0x6a, 0x33, 0xe9, 0x85, 0x16, 0x8e, 0x7c, 0xed, 0x84, 0x8f, 0xc9, 0x27, 0x84,
	0x67, 0x7b, 0xd6, 0x45, 0xa6, 0xb4, 0x41, 0xcb, 0xe5, 0xcc, 0xd2, 0xae, 0x48, 0x69, 0x4b, 0xa5,
	0x7c, 0x28, 0xed, 0x30, 0x71, 0xe4, 0xed, 0xb4, 0x48, 0xa3, 0x58, 0x3c, 0x5a, 0x43, 0x45, 0xf2,
	0x0e, 0xe1, 0x7f, 0x4f, 0x7a, 0x99, 0x5c, 0xcf, 0x9e, 0xf3, 0xc5, 0x5b, 0x46, 0x4e, 0xd1, 0x45,
	0x3e, 0x20, 0x3c, 0xd3, 0xed, 0x4e, 0x52, 0xca, 0x20, 0x19, 0xb0, 0x3a, 0xd4, 0xf2, 0xb9, 0x72,
	0x22, 0xfb, 0x6b, 0x8a, 0x54, 0x49, 0x48, 0xcf, 0x60, 0xc9, 0x67, 0x84, 0x73, 0xfd, 0x4d, 0x4a,
	0x6e, 0x66, 0x30, 0x65, 0xfa, 0x5a, 0xcd, 0xf5, 0x2c, 0xe1, 0xfb, 0xe1, 0x2f, 0xb3, 0xb6, 0x22,
	0x65, 0x5c, 0xd5, 0xa4, 0x05, 0x0e, 0x4f, 0x34, 0xaa, 0x83, 0x11, 0x8d, 0xd1, 0x0b, 0xf1, 0xc3,
	0x61, 0x7e, 0x41, 0x78, 0x6e, 0xc0, 0x3e, 0xc8, 0x74, 0x6f, 0xf6, 0x0e, 0x19, 0xa8, 0xb0, 0x24,
	0x15, 0x5e, 0xd3, 0x2e, 0x9f, 0xaa, 0xd0, 0x97, 0x04, 0x6b, 0xa8, 0xb8, 0x7e, 0x03, 0x2f, 0xd5,
	0x99, 0x93, 0xa1, 0x45, 0x72, 0xac, 0x4f, 0x27, 0x62, 0xb6, 0xc2, 0xe3, 0x0f, 0x84, 0x6a, 0x63,
	0x32, 0x50, 0xfe, 0x1d, 0x00, 0x00, 0xff, 0xff, 0xaa, 0x9f, 0x42, 0x0f, 0x8f, 0x09, 0x00, 0x00,
}
