/* Generated By:JavaCC: Do not edit this line. ExprParser.java */
package opendap.dap.parser;

import java.util.Vector;
import java.util.Stack;

import opendap.dap.*;
import opendap.dap.Server.*;

/** The constraint expression parser class. <p>

    Because it only makes sense to evaluate CEs when serving data, the
    BaseTyeFactory <em>must</em> create instances of the SDtype classes, not
    the Dtype classes. The is because we use the setRead method of the class
    ServerMethods when creating constants (to ensure that the evaluator
    doesn't try to read tem from the dataset!).

    @author jhrg */

public class ExprParser implements ExprParserConstants {
    private ServerDDS sdds;
    private CEEvaluator ceEval;
    private BaseTypeFactory factory;
    private ClauseFactory clauseFactory;

    /** Run the named projection function. Projection functions are run for
	their side effect; the return value is discarded.
	@param name The name of the projection function, look this up in the
	ServerDDS.
	@param btv A vector of BaseType variables that are the arguments of
	the projection function. */
    private void runProjectionFunction(String name, Vector btv) {
    }

    /** Remove double quotes from around a string. If there's not both start
	and ending quotes, does nothing.
	@param s The source string.
	@return The string without double quotes. */
    private String removeQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\""))
            return s.substring(1, s.length() - 1);
        else
            return s;
    }

    /** Given a stack of BaseType variables, mark these as part of the
     * current projection. This function assumes that if the TOS contains a
     * Ctor type variable, all of its members are to be projected. Also
     * assume  all variables under the TOS are Ctor variables and
     * only the ctor itself is to be projected; the member within the Ctor
     * that is part of the projection will be on the stack, too. */
    private void markStackedVariables(Stack s) {
        // Reverse the stack.
        Stack bts = new Stack();
        // System.err.println("Variables to be marked:");
        while (!s.empty()) {
            // System.err.println(((BaseType)s.peek()).getName());
            bts.push(s.pop());
        }

        // For each but the last stack element, set the projection.
        // setProject(true, false) for a ctor type sets the projection for
        // the ctor itself but *does not* set the projection for all its
        // children. Thus, if a user wants the variable S.X, and S contains Y
        // and Z too, S's projection will be set (so serialize will descend
        // into S) but X, Y and Z's projection remain clear. In this example,
        // X's projection is set by the code that follows the while loop.
        // 1/28/2000 jhrg
        while (bts.size() > 1) {
            ServerMethods ct = (ServerMethods)bts.pop();
            ct.setProject(true, false);
        }

        // For the last element, project the entire variable.
        ServerMethods bt = (ServerMethods)bts.pop();
        bt.setProject(true, true);
    }

/** This is the entry point for the Constraint expression parser.<p>

    Note that this method catches any ParserException and recasts it to a
    DAP2Exception after replacing all double quotes with single quotes.

    @param ceEval A CEEvaluator instance where any select clauses will be
    dumped and from which the DDS, which supplies the evaluation environment,
    will be read.
    @param factory A BaseTypeFactory used to generate instances of variables
    as needed (e.g., to hold values of constants).
    @param clauseFactory A ClauseFactory used to generate instances of each
    type of clause. */
  final public void constraint_expression(CEEvaluator ceEval, BaseTypeFactory factory,
                           ClauseFactory clauseFactory) throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, DAP2Exception, InvalidParameterException, SBHException, WrongTypeException {
    this.ceEval = ceEval;
    this.sdds = ceEval.getDDS();
    this.factory = factory;
    this.clauseFactory = clauseFactory;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
        projection();
        label_1:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case AMPERSAND:
            ;
            break;
          default:
            jj_la1[0] = jj_gen;
            break label_1;
          }
          selection();
        }
        break;
      default:
        jj_la1[2] = jj_gen;
            ceEval.markAll(true); // No projection; mark all

        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case AMPERSAND:
            ;
            break;
          default:
            jj_la1[1] = jj_gen;
            break label_2;
          }
          selection();
        }
      }
    } catch (ParseException pe) {
        // Extract the message and rethrow after changing all the double
        // quotes to single quotes so that the code that (might) send the
        // text of this exception back to a client over the network won't
        // barf.
        String msg = pe.getMessage();
        if (msg != null)
            msg = msg.replace('\"', '\'');
        {if (true) throw new DAP2Exception(DAP2Exception.MALFORMED_EXPR, msg);}
    }
  }

  final public void selection() throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, ParseException, SBHException, DAP2Exception {
    Clause c;
    jj_consume_token(AMPERSAND);
    c = clause();
        ceEval.appendClause(c);
  }

  final public Clause clause() throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, ParseException, DAP2Exception {
    Clause c;
    SubClause lop, rop;
    Vector ropv;
    int op;
    if (jj_2_1(2)) {
      c = bool_function();
        {if (true) return c;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
        lop = value();
        op = rel_op();
                                   ropv = new Vector();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WORD:
          rop = value();
                           ropv.addElement(rop);
          break;
        case LBRACE:
          jj_consume_token(LBRACE);
          label_3:
          while (true) {
            rop = value();
                                       ropv.addElement(rop);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              jj_consume_token(COMMA);
              break;
            default:
              jj_la1[3] = jj_gen;
              ;
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case WORD:
              ;
              break;
            default:
              jj_la1[4] = jj_gen;
              break label_3;
            }
          }
          jj_consume_token(RBRACE);
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        {if (true) return clauseFactory.newRelOpClause(op, lop, ropv);}
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Clause bool_function() throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, ParseException, DAP2Exception {
    Token name;                 // Name of the function
    Vector btv;
    name = jj_consume_token(WORD);
    btv = arg_list();
        {if (true) return clauseFactory.newBoolFunctionClause(name.image, btv);}
    throw new Error("Missing return statement in function");
  }

// Note that I'm using the constants from the ExprParserConstants interface
// rather than (re)define a new set of constants. 7/20/99 jhrg
  final public int rel_op() throws ParseException {
    Token op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUAL:
      op = jj_consume_token(EQUAL);
      {if (true) return op.kind;}
      break;
    case NOT_EQUAL:
      op = jj_consume_token(NOT_EQUAL);
      {if (true) return op.kind;}
      break;
    case GREATER:
      op = jj_consume_token(GREATER);
      {if (true) return op.kind;}
      break;
    case GREATER_EQL:
      op = jj_consume_token(GREATER_EQL);
      {if (true) return op.kind;}
      break;
    case LESS:
      op = jj_consume_token(LESS);
      {if (true) return op.kind;}
      break;
    case LESS_EQL:
      op = jj_consume_token(LESS_EQL);
      {if (true) return op.kind;}
      break;
    case REGEXP:
      op = jj_consume_token(REGEXP);
      {if (true) return op.kind;}
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void projection() throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, ParseException, InvalidParameterException, SBHException, WrongTypeException, DAP2Exception {
    proj_clause();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      proj_clause();
    }
  }

// Note that we have to keep a count of the array index number for the calls
// to array_index(). 7/20/99 jhrg
  final public void proj_clause() throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, ParseException, InvalidParameterException, SBHException, WrongTypeException, DAP2Exception {
    Token t;
    Vector btv;
    if (jj_2_2(2)) {
      t = jj_consume_token(WORD);
      btv = arg_list();
        ceEval.appendClause(clauseFactory.newBTFunctionClause(t.image, btv));
        // runProjectionFunction(t.image, btv);

    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
        proj_variable();
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void proj_variable() throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, ParseException, InvalidParameterException, SBHException, WrongTypeException, DAP2Exception {
    Token t;
    BaseType bt;
    Stack comp = new Stack();
    comp = component(comp);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEPARATOR:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_5;
      }
      jj_consume_token(SEPARATOR);
      comp = component(comp);
    }
        markStackedVariables(comp);
  }

  final public Stack component(Stack components) throws ParseException, ParseException, DAP2Exception {
    Token t;
    int count = 0;
    ServerArrayMethods abt;
    if (jj_2_3(2)) {
      t = jj_consume_token(WORD);
        components = sdds.search(t.image, components);
        try {
            abt = (ServerArrayMethods)components.peek();
        }
        catch (ClassCastException cce) {
            String msg = "Attempt to treat the variable `" + t.image
            + "' as if it is an array.";
            {if (true) throw new DAP2Exception(DAP2Exception.MALFORMED_EXPR, msg);}
        }
      label_6:
      while (true) {
        array_index(count++, abt);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_6;
        }
      }
        {if (true) return components;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
        t = jj_consume_token(WORD);
        components = sdds.search(t.image, components);
        {if (true) return components;}
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Vector arg_list() throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, ParseException, DAP2Exception {
    Vector cv = new Vector();
    Clause c;
    jj_consume_token(LPAREN);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_7;
      }
      c = value();
                           cv.addElement(c);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
    }
    jj_consume_token(RPAREN);
              {if (true) return cv;}
    throw new Error("Missing return statement in function");
  }

// Note that we must explicitly catch the NumberFormatExceptions since it is
// a child of RuntimeException. Might as well do it here and munge the
// message into a DAP2Exception object. 1/6/2000 jhrg
  final public void array_index(int count, ServerArrayMethods bt) throws ParseException, ParseException, DAP2Exception, InvalidParameterException, SBHException {
    Token t1, t2, t3;
    if (jj_2_4(5)) {
      jj_consume_token(LBRACKET);
      t1 = jj_consume_token(WORD);
      jj_consume_token(COLON);
      t2 = jj_consume_token(WORD);
      jj_consume_token(COLON);
      t3 = jj_consume_token(WORD);
      jj_consume_token(RBRACKET);
        try {
            bt.setProjection(count, Integer.parseInt(t1.image),
                             Integer.parseInt(t2.image),
                             Integer.parseInt(t3.image) );
        }
        catch (NumberFormatException e) {
            {if (true) throw new DAP2Exception(DAP2Exception.MALFORMED_EXPR,
"Could not parse one of " + t1.image + ", " + t2.image + ", " + t3.image +
" as an integer: " + e.getMessage());}
        }
    } else if (jj_2_5(3)) {
      jj_consume_token(LBRACKET);
      t1 = jj_consume_token(WORD);
      jj_consume_token(COLON);
      t2 = jj_consume_token(WORD);
      jj_consume_token(RBRACKET);
          try {
              bt.setProjection(count, Integer.parseInt(t1.image), 1,
                               Integer.parseInt(t2.image) );
          }
          catch (NumberFormatException e) {
              {if (true) throw new DAP2Exception(DAP2Exception.MALFORMED_EXPR,
"Could not parse one of " + t1.image + ", " + t2.image +
" as an integer: " + e.getMessage());}
          }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        t1 = jj_consume_token(WORD);
        jj_consume_token(RBRACKET);
           try {
               bt.setProjection(count, Integer.parseInt(t1.image), 1,
                                Integer.parseInt(t1.image) );
           }
           catch (NumberFormatException e) {
               {if (true) throw new DAP2Exception(DAP2Exception.MALFORMED_EXPR,
"Could not parse " + t1.image + " as an integer: " + e.getMessage());}
           }
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// Values only appear in the selection part of a CE.
// Use clauseFactory to create the appropriate type of clause - joew
  final public SubClause value() throws ParseException, NoSuchVariableException, NoSuchFunctionException, InvalidOperatorException, DAP2Exception, ParseException {
    Token t;
    Vector btv;
    BaseType bt;
    String name;
    Stack comp = new Stack();
    if (jj_2_6(2)) {
      t = jj_consume_token(WORD);
      btv = arg_list();
        {if (true) return clauseFactory.newBTFunctionClause(t.image, btv);}
    } else if (jj_2_7(2)) {
      comp = component(comp);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEPARATOR:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_8;
        }
        jj_consume_token(SEPARATOR);
        comp = component(comp);
      }
        bt = (BaseType)comp.pop();
        {if (true) return clauseFactory.newValueClause(bt, false);}
    } else if (jj_2_8(2)) {
      bt = constant();
        {if (true) return clauseFactory.newValueClause(bt, true);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String field() throws ParseException, ParseException {
    String name;
    Token t;
    t = jj_consume_token(WORD);
        name = t.image;
    label_9:
    while (true) {
      jj_consume_token(SEPARATOR);
      t = jj_consume_token(WORD);
            name += "." + t.image;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEPARATOR:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_9;
      }
    }
        {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

// See my comment above about the NumberFormatExceptions. 8/20/99 jhrg
  final public BaseType constant() throws ParseException, DAP2Exception, ParseException {
    Token t;
    if (jj_2_9(2)) {
      t = jj_consume_token(WORD);
        //System.out.println("Setting constant value: "+t.image + " (<WORD>)");
        DInt32 i = factory.newDInt32("constant");
        try {
            i.setValue(Integer.parseInt(t.image));
            ((ServerMethods)i).setRead(true);
            ((ServerMethods)i).setProject(true);
        }
        catch (NumberFormatException e) {
            {if (true) throw new DAP2Exception(DAP2Exception.MALFORMED_EXPR,
            "Could not parse `" + t.image + "' as an integer: " + e.getMessage());}
        }
        {if (true) return i;}
    } else if (jj_2_10(2)) {
      t = jj_consume_token(WORD);
    System.out.println("Setting constant value: "+t.image + " (<WORD>)");
        DFloat64 f = factory.newDFloat64("constant");
        try {
            f.setValue(Double.valueOf(t.image).doubleValue());
            ((ServerMethods)f).setRead(true);
            ((ServerMethods)f).setProject(true);
        }
        catch (NumberFormatException e) {
            {if (true) throw new DAP2Exception(DAP2Exception.MALFORMED_EXPR,
            "Could not parse `" + t.image + "' as an integer: " + e.getMessage());}
        }
        {if (true) return f;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
        t = jj_consume_token(WORD);
    System.out.println("Setting constant value: "+t.image + " (<WORD>)");
        DString s = factory.newDString("constant");
        s.setValue(removeQuotes(t.image));
        ((ServerMethods)s).setRead(true);
        ((ServerMethods)s).setProject(true);

        {if (true) return s;}
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_3R_18() {
    if (jj_scan_token(WORD)) return true;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(WORD)) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(WORD)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(WORD)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(SEPARATOR)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(WORD)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_13()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_14()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_scan_token(WORD)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(WORD)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(WORD)) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(WORD)) return true;
    Token xsp;
    if (jj_3R_12()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) return true;
    }
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(WORD)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(WORD)) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    }
    }
    return false;
  }

  public ExprParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[19];
  static private int[] jj_la1_0;
  static {
      jj_la1_0();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x10000,0x10000,0x400000,0x8000,0x400000,0x480000,0x400000,0xfe0,0x8000,0x400000,0x200000,0x1000,0x400000,0x400000,0x8000,0x1000,0x200000,0x200000,0x400000,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public ExprParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public ExprParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ExprParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ExprParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ExprParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ExprParser(ExprParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ExprParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 19; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[23];
    for (int i = 0; i < 23; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 19; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 23; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
