<?xml version="1.0" encoding="ISO-8859-1"?>


<!--
Site-wide style for each sub-project
version $Date: 2004/06/08 20:55:30 $


Creates an HTML-viewable document for a code-coverage report.

 @author Matt Albrecht (mailto:groboclown@users.sourceforge.net)
-->

<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0' >

    <xsl:output method="html" indent="no"
        doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
        doctype-system="http://www.w3.org/TR/html4/loose.dtd"
    />

    <xsl:param name="perfectP" select="'100'" />
    <xsl:param name="goodP" select="'80'" />
    <xsl:param name="warnP" select="'60'" />
    
    <!-- not used
    <xsl:param name="do-weight" select="false" />
    -->
    <xsl:param name="title" select="'Code Coverage Report'" />
    <xsl:param name="footerText" select="'Generated with GroboUtils Code Coverage'" />
    <xsl:param name="footerLink" select="'http://groboutils.sourceforge.net/codecoverage'" />
    
    <xsl:param name="TSTAMP" select="'(unknown)'" />
    
    <xsl:param name="DoBarGraph" select="'false'" />
    <xsl:param name="BarWidth" select="'50'" />
    
    <!-- commonly used variables -->
    <xsl:variable name="modules" select="//moduletypes/module" />
    <xsl:variable name="moduleCount" select="count($modules)" />
    <xsl:variable name="moduleCellCount" select="4 + 3 * $moduleCount" />
    
    
    <!-- base document: contains all coverage reports -->
    <xsl:template match="/coveragereport">
        <!-- *************************************************************
        Summarize all the packages.
        ************************************************************** -->
        <!-- file="overview-summary.html" -->
<!--NewPage-->
<html>
    <xsl:call-template name="func-summary-head">
        <xsl:with-param name="subtitle" select="'Overview'" />
    </xsl:call-template>

<body BGCOLOR="white" onload="windowTitle();">
    <xsl:call-template name="func-summary-navbar">
    </xsl:call-template>
    <hr />

    <table BORDER="0" WIDTH="100%" CELLPADDING="3" CELLSPACING="1" SUMMARY="">
        <tbody>
    <xsl:call-template name="func-cover-header">
        <xsl:with-param name="ref" select="'AllPackages'" />
    </xsl:call-template>
    <xsl:call-template name="func-cover-line">
        <xsl:with-param name="node" select="cover" />
        <xsl:with-param name="name" select="'All Packages'" />
        <xsl:with-param name="href" select="'#Packages'" />
        <xsl:with-param name="reldir" select="''" />
    </xsl:call-template>
    
    <xsl:call-template name="func-hspace" />
    
    <xsl:call-template name="func-cover-header">
        <xsl:with-param name="header" select="'Package'" />
        <xsl:with-param name="ref" select="'Packages'" />
    </xsl:call-template>
    
    <xsl:if test="not(boolean(package))">
        <tr><td>
            <xsl:attribute name="COLSPAN">
                <xsl:value-of select="$moduleCellCount" />
            </xsl:attribute>
            <i>No coverage numbers exist for this project</i>
        </td></tr>
    </xsl:if>
    <!-- else -->
    <xsl:for-each select="package">
        <xsl:sort data-type="number" order="ascending" select="cover/@percentcovered" />
        <xsl:call-template name="func-cover-line">
            <xsl:with-param name="node" select="cover" />
            <xsl:with-param name="name" select="@name" />
            <xsl:with-param name="href"
                select="concat(translate(@name, '.', '/'),'/package-frame.html')" />
            <xsl:with-param name="reldir" select="''" />
        </xsl:call-template>
    </xsl:for-each>
    </tbody></table>
    
    
    <xsl:call-template name="func-footer" />
</body>
</html>
    </xsl:template>
    
    <!-- *************************************************************
    ************************************************************** -->
    <xsl:template match="/package">
        <xsl:variable name="reldir" select="@updir" />
        <xsl:variable name="pname" select="@name" />
<!--NewPage-->
<html>
    <xsl:call-template name="func-summary-head">
        <xsl:with-param name="subtitle" select="concat('Package ',$pname)" />
        <xsl:with-param name="reldir" select="$reldir" />
    </xsl:call-template>

<body BGCOLOR="white" onload="windowTitle();">
    <xsl:call-template name="func-summary-navbar">
        <xsl:with-param name="overviewLink" select="concat($reldir, 'overview-summary.html')" />
        <xsl:with-param name="nodeType" select="'package'" />
    </xsl:call-template>
    <hr />

    <table BORDER="0" WIDTH="100%" CELLPADDING="3" CELLSPACING="1" SUMMARY="">
        <tbody>
    <xsl:call-template name="func-cover-header">
        <xsl:with-param name="header" select="'Package'" />
        <xsl:with-param name="ref" select="'Package'" />
    </xsl:call-template>
    <xsl:call-template name="func-cover-line">
        <xsl:with-param name="node" select="cover" />
        <xsl:with-param name="name" select="$pname" />
        <xsl:with-param name="href" select="'#Classes'" />
        <xsl:with-param name="reldir" select="$reldir" />
    </xsl:call-template>
    
    <xsl:call-template name="func-hspace" />
    
    <xsl:call-template name="func-cover-header">
        <xsl:with-param name="header" select="'Classes'" />
        <xsl:with-param name="ref" select="'Classes'" />
    </xsl:call-template>
    
    <xsl:if test="not(boolean(classcoverage[@package = $pname]))">
        <tr><td>
            <xsl:attribute name="COLSPAN">
                <xsl:value-of select="$moduleCellCount" />
            </xsl:attribute>
            <i>No coverage numbers exist for this package</i>
        </td></tr>
    </xsl:if>
    <!-- else -->
    <xsl:for-each select="classcoverage[@package = $pname]">
        <xsl:sort data-type="number" order="ascending" select="cover/@percentcovered" />
        <xsl:variable name="cname"
            select="substring-after(@classname, concat($pname, '.'))" />
        <xsl:call-template name="func-cover-line">
            <xsl:with-param name="node" select="cover" />
            <xsl:with-param name="name" select="$cname" />
            <xsl:with-param name="href" select="concat(@sourcefile,'.html')" />
            <xsl:with-param name="reldir" select="$reldir" />
        </xsl:call-template>
    </xsl:for-each>
    </tbody></table>
    
    
    <xsl:call-template name="func-footer" />
</body>
</html>
    </xsl:template>
    
    
    <!-- ============================================================
    Used by the Document containing the Java source file and the
    corresponding class(es).  There may be multiple class files per
    Java source file.  Only the contained classcoverage elements
    are to be in this node.
    ============================================================= -->
    <xsl:template match="/javacoverage">
        <xsl:variable name="javaclass" select="@javaclass" />
        <xsl:variable name="reldir" select="@updir" />
<!--
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
-->
<!--NewPage-->
<html>
    <xsl:call-template name="func-summary-head">
        <xsl:with-param name="subtitle" select="concat('Class ',$javaclass)" />
        <xsl:with-param name="reldir" select="$reldir" />
    </xsl:call-template>

<body BGCOLOR="white" onload="windowTitle();">
    <xsl:call-template name="func-summary-navbar">
        <xsl:with-param name="overviewLink" select="concat($reldir, 'overview-summary.html')" />
        <xsl:with-param name="packageLink" select="'package-frame.html'" />
        <xsl:with-param name="nodeType" select="'package'" />
    </xsl:call-template>
    <hr />

    <table BORDER="0" WIDTH="100%" CELLPADDING="3" CELLSPACING="1" SUMMARY="">
    
    <xsl:call-template name="func-cover-header">
        <xsl:with-param name="header" select="'Class'" />
        <xsl:with-param name="ref" select="''" />
    </xsl:call-template>
    <xsl:for-each select="classcoverage">
        <!-- should only be one of these -->
        <xsl:sort data-type="number" order="ascending" select="cover/@percentcovered" />
        <xsl:call-template name="func-cover-line">
            <xsl:with-param name="node" select="cover" />
            <xsl:with-param name="name" select="@classname" />
            <xsl:with-param name="href" select="concat('#', @classname)" />
            <xsl:with-param name="reldir" select="$reldir" />
        </xsl:call-template>
    </xsl:for-each>
        
    <xsl:for-each select="classcoverage">
        <xsl:call-template name="func-hspace" />
    
        <xsl:call-template name="func-cover-header">
            <xsl:with-param name="header" select="@classname" />
            <xsl:with-param name="ref" select="concat('#', @classname)" />
        </xsl:call-template>
        <xsl:if test="not(boolean(methodcoverage))">
            <tr><td>
                <xsl:attribute name="COLSPAN">
                    <xsl:value-of select="$moduleCellCount" />
                </xsl:attribute>
                <i>No coverage numbers exist for class <xsl:value-of select="@classname"/></i>
            </td></tr>
        </xsl:if>
        <!-- else -->
        <xsl:for-each select="methodcoverage">
            <xsl:sort data-type="number" order="ascending" select="cover/@percentcovered" />
            <xsl:call-template name="func-cover-line">
                <xsl:with-param name="node" select="cover" />
                <xsl:with-param name="name" select="@methodsignature" />
                <xsl:with-param name="href" select="''" />
                <xsl:with-param name="reldir" select="$reldir" />
            </xsl:call-template>
        </xsl:for-each>
    </xsl:for-each>
    </table>
    
    <xsl:apply-templates select="nosource" />
    <xsl:apply-templates select="source">
        <xsl:with-param name="reldir" select="$reldir" />
    </xsl:apply-templates>
    
    
    <xsl:call-template name="func-footer" />
</body>
</html>
    </xsl:template>

    <xsl:template match="nosource">
        <p><i>No source available</i></p>
        
        <xsl:apply-templates select="noline" />
        
        <xsl:apply-templates select="nosource-marks" />
    </xsl:template>
    
    
    <xsl:template match="nosource-marks">
        <table BORDER="0" WIDTH="100%" CELLSPACING="3" CELLPADDING="1">
            <tr CLASS="TableHeadingColor">
                <th CLASS="CoverHeader">Method</th>
                <th CLASS="CoverHeader">Source Line</th>
                <th CLASS="CoverHeader">Details</th>
            </tr>
            <xsl:for-each select="mark">
                <xsl:sort data-type="number" order="ascending" select="@sourceline" />
                <tr>
                    <xsl:call-template name="func-rowClass" />
                    <td CLASS="NavBarCell2"><xsl:value-of select="@methodsignature" /></td>
                    <td CLASS="NavBarCell2"><xsl:value-of select="@sourceline" /></td>
                    <td CLASS="NavBarCell2"><xsl:value-of select="@text" /></td>
                </tr>
            </xsl:for-each>
        </table>
    </xsl:template>
    
    <xsl:template match="noline">
        <table BORDER="0" WIDTH="100%" CELLSPACING="3" CELLPADDING="1">
            <tr CLASS="TableHeadingColor">
                <th CLASS="CoverHeader">Method</th>
                <th CLASS="CoverHeader">Index</th>
                <th CLASS="CoverHeader">Details</th>
            </tr>
            <xsl:for-each select="mark">
                <xsl:sort data-type="number" order="ascending" select="@index" />
                <tr>
                    <xsl:call-template name="func-rowClass" />
                    <td CLASS="NavBarCell2"><xsl:value-of select="@methodsignature" /></td>
                    <td CLASS="NavBarCell2"><xsl:value-of select="@index" /></td>
                    <td CLASS="NavBarCell2"><xsl:value-of select="@text" /></td>
                </tr>
            </xsl:for-each>
        </table>
    </xsl:template>
    
    <xsl:template match="source">
        <xsl:param name="reldir" select="''" />
        <xsl:apply-templates select="noline" />
        
        <table CLASS="SourceTable" BORDER="0" CELLSPACING="0" CELLPADDING="0"><tbody>
            <xsl:apply-templates select="line">
                <xsl:sort data-type="number" order="ascending" select="@i" />
                <xsl:with-param name="reldir" select="$reldir" />
            </xsl:apply-templates>
        </tbody></table>
    </xsl:template>
    
    <xsl:template match="line">
        <xsl:param name="reldir" select="''" />
        <xsl:variable name="i" select="@i" />
        <xsl:variable name="markset" select="mark" />
        <xsl:variable name="marksetCount" select="count($markset)" />
        <tr CLASS="SourceRow">
            <td CLASS="SourceLineNo"><xsl:call-template name="nbsp"
                /><xsl:value-of select="$i" /></td>
            <td>
                <!-- this stuff is really really slow -->
                <xsl:choose>
                    <xsl:when test="$marksetCount &gt; 0">
                        <xsl:attribute name="CLASS">NotCoveredLine</xsl:attribute>
                        
                        <!-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
                        how to display which module marked this line?
                        
                        There can be multiple items with the
                        same measure in this list.  Need to reduce
                        this down to just one displayed.
                        -->
                        <img CLASS="bimg">
                            <xsl:attribute name="src"><xsl:value-of
                                select="concat( $reldir, '1x1.png' )"
                            /></xsl:attribute>
                            <xsl:attribute name="alt"
                                ><xsl:for-each select="$modules"
                                    ><xsl:variable name="mname"
                                        select="@measure"
                                    /><xsl:variable name="markcount"
                                        select="count($markset[@measure = $mname])"
                                    /><xsl:if test="$markcount &gt; 0"
                                        ><xsl:value-of select="@measure"
                                        />(<xsl:value-of select="$markcount"
                                    />);</xsl:if
                                ></xsl:for-each
                            ></xsl:attribute>
                            <xsl:attribute name="title"
                                ><xsl:for-each
                                        select="$modules"
                                    ><xsl:variable name="mname"
                                        select="@measure"
                                    /><xsl:variable name="markcount"
                                        select="count($markset[@measure = $mname])"
                                    /><xsl:if test="$markcount &gt; 0"
                                        ><xsl:value-of select="@measure"
                                        />(<xsl:value-of select="$markcount"
                                    />);</xsl:if
                                ></xsl:for-each
                            ></xsl:attribute>
                        </img>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="CLASS">CoveredLine</xsl:attribute>
                        <xsl:call-template name="nbsp" /><xsl:call-template name="nbsp" />
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <!-- should probably copy the contents of the line node;
            the text and any syntax-encoded inner nodes may be here.
            
            This is really really slow.
            -->
            <td><xsl:attribute name="CLASS">
                    <xsl:choose>
                        <xsl:when test="$marksetCount &gt; 0"
                            >SourceLineNC</xsl:when>
                        <xsl:otherwise>SourceLineC</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute
                ><span WIDTH="100%"><xsl:attribute name="title"
                    ><xsl:for-each
                            select="$modules"
                        ><xsl:variable name="mname"
                            select="@measure"
                        /><xsl:variable name="markcount"
                            select="count($markset[@measure = $mname])"
                        /><xsl:if test="$markcount &gt; 0"
                            ><xsl:value-of select="@measure"
                            />(<xsl:value-of select="$markcount"
                        />);</xsl:if
                    ></xsl:for-each
                ></xsl:attribute
                ><xsl:call-template name="nbsp"
                /><xsl:value-of select="@src" /></span></td>
        </tr>
    </xsl:template>

    
    
    <!-- ============================================================
    Here starts the callable templates
    ============================================================= -->
    
    <xsl:template name="func-hspace">
        <tr CLASS="TableSpacer">
        </tr>
    </xsl:template>
    
    <xsl:template name="func-cover-header">
        <xsl:param name="header" select="' '" />
        <xsl:param name="ref" select="'[none]'" />
    <tr CLASS="CoverHeaderRow">
        <th ROWSPAN="2" CLASS="CoverHeader"><a>
            <xsl:attribute name="name">
                <xsl:value-of select="$ref" />
            </xsl:attribute>
            <xsl:value-of select="$header" /></a></th>
        <xsl:for-each select="$modules">
            <th CLASS="CoverHeadDesc" COLSPAN="3"><xsl:value-of select="@measure" /></th>
        </xsl:for-each>
        <xsl:if test="$moduleCount &gt; 1">
            <th CLASS="CoverHeadDesc" COLSPAN="3">TOTAL</th>
        </xsl:if>
    </tr>
    <tr CLASS="CoverHeaderRow">
        <xsl:for-each select="$modules">
            <th CLASS="CoverHeader"><xsl:value-of select="@unit" /> Covered</th>
            <th CLASS="CoverHeader">Total <xsl:value-of select="@unit" /></th>
            <th CLASS="CoverHeader">% Covered</th>
        </xsl:for-each>
        <xsl:if test="$moduleCount &gt; 1">
            <th CLASS="CoverHeader">Units Covered</th>
            <th CLASS="CoverHeader">Total Units</th>
            <th CLASS="CoverHeader">% Covered</th>
        </xsl:if>
    </tr>
    </xsl:template>
    
    <!-- node must be a cover tag -->
    <xsl:template name="func-cover-line">
        <xsl:param name="name" select="'[not set]'" />
        <xsl:param name="href" select="'[not set]'" />
        <xsl:param name="reldir" select="''" />
        <xsl:param name="node" />
        
        <!-- bargraph stuff -->
        <xsl:if test="$DoBarGraph = 'true'">
            <tr>
                <td STYLE="CoverageTitle" ROWSPAN="2"><a>
                <xsl:attribute name="href"><xsl:value-of select="$href" /></xsl:attribute>
                <xsl:value-of select="$name" />
                </a></td>
                <!-- this ensures that the order remains the same -->
                <xsl:for-each select="$modules">
                    <xsl:variable name="modname" select="@measure" />
                    <xsl:for-each select="$node/modulecover[@measure = $modname]">
                        <xsl:call-template name="func-cover-barline">
                            <xsl:with-param name="reldir" select="$reldir" />
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:for-each>
                
                <xsl:if test="$moduleCount &gt; 1">
                    <xsl:for-each select="$node">
                        <xsl:call-template name="func-cover-barline">
                            <xsl:with-param name="reldir" select="$reldir" />
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:if>
            </tr>
        </xsl:if>
        <tr>
            <xsl:call-template name="func-rowClass" />
            <xsl:if test="$DoBarGraph != 'true'">
                <td STYLE="CoverageTitle"><a>
                <xsl:attribute name="href"><xsl:value-of select="$href" /></xsl:attribute>
                <xsl:value-of select="$name" />
                </a></td>
            </xsl:if>
            
            <!-- this ensures that the order remains the same -->
            <xsl:for-each select="$modules">
                <xsl:variable name="modname" select="@measure" />
                <xsl:for-each select="$node/modulecover[@measure = $modname]">
                    <xsl:call-template name="func-cover-numbers" />
                </xsl:for-each>
            </xsl:for-each>
            
            <xsl:if test="$moduleCount &gt; 1">
                <xsl:for-each select="$node">
                    <xsl:call-template name="func-cover-numbers" />
                </xsl:for-each>
            </xsl:if>
        </tr>
    </xsl:template>
    
    
    <xsl:template name="func-cover-barline">
        <xsl:param name="reldir" select="''" />
        
        <td COLSPAN="3" CLASS="bcell">
            <table CLASS="bar"><tr><xsl:if test="@percentcovered &gt; 0">
            <td>
                <xsl:choose>
                    <xsl:when test="@percentcovered &gt;= 100">
                        <xsl:attribute name="CLASS">bpassall</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="CLASS">bpass</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                
                <img CLASS="bimg">
                <xsl:attribute name="src"><xsl:value-of
                    select="concat( $reldir, '1x1.png' )"
                /></xsl:attribute
                ><xsl:attribute name="width"><xsl:value-of
                    select="ceiling((@percentcovered * $BarWidth) div 100)"
                /></xsl:attribute></img>
            </td></xsl:if><xsl:if test="@percentcovered &lt; 100">
            <td>
                <xsl:choose>
                    <xsl:when test="@percentcovered &lt;= 0">
                        <xsl:attribute name="CLASS">bfailall</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="CLASS">bfail</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                <img CLASS="bimg">
                <xsl:attribute name="src"><xsl:value-of
                    select="concat( $reldir, '1x1.png' )"
                /></xsl:attribute
                ><xsl:attribute name="width"><xsl:value-of
                    select="$BarWidth - ceiling((@percentcovered * $BarWidth) div 100)"
                /></xsl:attribute></img>
            </td></xsl:if></tr></table>
        </td>
    </xsl:template>
    
    
    <xsl:template name="func-cover-numbers">
        <td>
        <xsl:call-template name="func-cover-PassFailStyle" />
        <xsl:value-of select="@display-covered" /></td>
        <td>
        <xsl:call-template name="func-cover-PassFailStyle" />
        <xsl:value-of select="@display-total" /></td>
        <td>
        <xsl:call-template name="func-cover-PassFailStyle" />
        <xsl:value-of select="@display-percentcovered" /></td>
    </xsl:template>
    
    
    <!--
    Set the style attribute based on the "percentcovered" attribute.
    -->
    <xsl:template name="func-cover-PassFailStyle">
        <xsl:param name="prepend" select="''" />
        <xsl:attribute name="CLASS"><xsl:value-of select="$prepend"
        /><xsl:choose
            ><xsl:when test="@percentcovered &gt;= $perfectP"
                >Perfect</xsl:when
            ><xsl:when test="@percentcovered &gt;= $goodP"
                >Good</xsl:when
            ><xsl:when test="@percentcovered &gt;= $warnP"
                >Warn</xsl:when
            ><xsl:otherwise
                >Fail</xsl:otherwise
            ></xsl:choose
        ></xsl:attribute>
    </xsl:template>
    
    
    <xsl:template name="func-rowClass">
        <!-- add style here for the tr -->
        <xsl:attribute name="CLASS">
            <xsl:choose>
                <xsl:when test="position() mod 2 = 1">
                    CovRowOdd
                </xsl:when>
                <xsl:otherwise>
                    CovRowEven
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
    
    
    <!--
    All the summary frame callable templates
    -->
    <xsl:template name="func-summary-head">
        <xsl:param name="subtitle" select="''" />
        <xsl:param name="reldir" select="''" />
        <xsl:variable name="fulltitle"
            select="concat($subtitle, ' (', $title, ')')" />
<head>
<title>
<xsl:value-of select="$fulltitle" />
</title>

<meta NAME="keywords">
    <xsl:attribute name="CONTENT">
        <xsl:value-of select="concat($subtitle, ', ', $title)" />
    </xsl:attribute>
</meta>

<link REL="stylesheet" TYPE="text/css" TITLE="Style">
    <xsl:attribute name="HREF">
        <xsl:value-of select="concat($reldir, 'stylesheet.css')" />
    </xsl:attribute>
</link>

<script type="text/javascript"><xsl:text disable-output-escaping="yes">&lt;!--
function windowTitle()
{
    parent.document.title=&quot;</xsl:text><xsl:value-of select="translate($fulltitle,'\', '.')" /><xsl:text disable-output-escaping="yes">&quot;;
}
//--&gt;</xsl:text></script>

</head>
    </xsl:template>
    
    
    <xsl:template name="func-summary-navbar">
        <xsl:param name="overviewLink" select="''" />
        <xsl:param name="packageLink" select="''" />
        <xsl:param name="nodeType" select="'overview'" />
        <xsl:variable name="reldir" select="@updir" />
<xsl:comment> ========= START OF TOP NAVBAR ======= </xsl:comment>
<a NAME="navbar_top"><xsl:comment> spacer </xsl:comment></a>
<table BORDER="0" WIDTH="100%" CELLPADDING="1" CELLSPACING="0" SUMMARY="">
<tr>
<td COLSPAN="3" BGCOLOR="#EEEEFF" CLASS="NavBarCell1">
<a NAME="navbar_top_firstrow"><xsl:comment> spacer </xsl:comment></a>
<table BORDER="0" CELLPADDING="0" CELLSPACING="3" SUMMARY="">
  <tr VALIGN="top">
    <td CLASS="NavBarTitle"><xsl:value-of select="$title" /></td>
  </tr>
  <tr VALIGN="top">
    <td CLASS="NavBarTStamp"><b>Report generated on:</b> <xsl:value-of select="$TSTAMP" /></td>
  </tr>
  <tr ALIGN="center" VALIGN="top">
    <td>
        <xsl:choose>
            <xsl:when test="$overviewLink = ''">
                <xsl:attribute name="CLASS">NavBarBlockLinkRel</xsl:attribute>
                <xsl:call-template name="nbsp" /><b>Overview</b><xsl:call-template name="nbsp" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="CLASS">NavBarBlockLink</xsl:attribute>
                <xsl:call-template name="nbsp" /><a><xsl:attribute name="HREF"
                ><xsl:value-of select="$overviewLink" /></xsl:attribute>Overview</a><xsl:call-template name="nbsp" />
            </xsl:otherwise>
        </xsl:choose>
    </td>
    <td>
        <xsl:choose>
            <xsl:when test="$overviewLink != '' and $packageLink = ''">
                <xsl:attribute name="CLASS">NavBarBlockLinkRel</xsl:attribute>
                <xsl:call-template name="nbsp" /><b>Package</b><xsl:call-template name="nbsp" />
            </xsl:when>
            <xsl:when test="$overviewLink = ''">
                <xsl:attribute name="CLASS">NavBarBlockLink</xsl:attribute>
                <xsl:call-template name="nbsp" />Package<xsl:call-template name="nbsp" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="CLASS">NavBarBlockLink</xsl:attribute>
                <xsl:call-template name="nbsp" /><a><xsl:attribute name="HREF"
                ><xsl:value-of select="$packageLink" /></xsl:attribute>Package</a><xsl:call-template name="nbsp" />
            </xsl:otherwise>
        </xsl:choose>
    </td>
    <td>
        <xsl:choose>
            <xsl:when test="$overviewLink != '' and $packageLink != ''">
                <xsl:attribute name="CLASS">NavBarBlockLinkRel</xsl:attribute>
                <xsl:call-template name="nbsp" /><b>Class</b><xsl:call-template name="nbsp" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="CLASS">NavBarBlockLink</xsl:attribute>
                <xsl:call-template name="nbsp" />Class<xsl:call-template name="nbsp" />
            </xsl:otherwise>
        </xsl:choose>
    </td>
  </tr>
  <tr>
    <td CLASS="NavBarCell2" COLSPAN="3">
        <a target="_top">
            <xsl:attribute name="HREF">
                <xsl:value-of select="concat($reldir, '/index.html')" />
            </xsl:attribute><b>FRAMES</b></a>  <xsl:call-template name="nbsp" />
<xsl:call-template name="nbsp" /><a target="_top">
            <xsl:attribute name="HREF">
                <xsl:value-of select="concat($reldir, '/overview-summary.html')" />
            </xsl:attribute><b>NO FRAMES</b></a>  <xsl:call-template name="nbsp" />
<xsl:call-template name="nbsp" /><script type="text/javascript"><xsl:text disable-output-escaping="yes">
  &lt;!--
  if(window==top) {
    document.writeln('&lt;A HREF="{$reldir}/allclasses-noframe.html"&gt;&lt;B&gt;All Classes&lt;/B&gt;&lt;/A&gt;');
  }
  //--&gt;
</xsl:text></script>
<noscript>
  <a HREF="allclasses-noframe.html"><b>All Classes</b></a>
</noscript>
    </td>
  </tr>
</table>
</td>
<!--
<td ALIGN="right" VALIGN="top">
add some context-sensitive overview data here.
</td>
-->
</tr>
</table>
<a NAME="skip-navbar_top"></a>
<xsl:comment> ========= END OF TOP NAVBAR ========= </xsl:comment>
    </xsl:template>
    
    
    <xsl:template name="func-footer">
<table BORDER="1" WIDTH="100%" CELLPADDING="1" CELLSPACING="0" SUMMARY="">
<tr><td CLASS="NavBarTitle">
<a><xsl:attribute name="href"><xsl:value-of select="$footerLink" /></xsl:attribute>
<xsl:value-of select="$footerText" /></a>
</td></tr>
<tr><td CLASS="NavBarTStamp"><i><xsl:value-of select="$TSTAMP" /></i></td></tr>
</table>
    </xsl:template>
    
    
    <xsl:template name="nbsp"><xsl:text
        disable-output-escaping="yes">&amp;nbsp;</xsl:text></xsl:template>
</xsl:stylesheet>
