/*
 * @(#)GroboReportTaskUTest.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.ant;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;


/**
 * Tests the GroboReportTask class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     March 13, 2004
 */
public class GroboReportTaskUTest extends AntTestA
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = GroboReportTaskUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public GroboReportTaskUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    //...........................
    // Tests that pass
    
    public void testReport1()
    {
        executeTarget( "report-1" );
    }
    
    public void testReport2()
    {
        executeTarget( "report-2" );
    }
    
    public void testReport3()
    {
        try
        {
            executeTarget( "report-3" );
        }
        finally
        {
            System.out.println( getFullLog() );
        }
    }
    
    public void testReport4()
    {
        executeTarget( "report-4" );
    }
    
    
    //...........................
    // Tests that fail
    
    
    public void testFReport1()
    {
        expectBuildExceptionContaining( "f-report-1",
            "Did not fail for no destdir attribute.",
            "Must set the 'destdir' attribute." );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected void assertEquals( String text, Properties expected,
            Properties actual )
    {
        PropertyCheckUtil.assertEquals( text, expected, actual );
    }
    

    protected Properties loadGroboProperties()
            throws IOException
    {
        return loadProperties(
            (new File( getCoverageDir(),
                "classes" + File.separator + "grobocoverage.properties")).
            getAbsolutePath() );
    }
    
    
    protected Properties loadProperties( String file )
            throws IOException
    {
        return PropertyCheckUtil.loadProperties( file );
    }
    
    
    protected File getCoverageDir()
    {
        return new File( getProjectDir(), "instrument" +
            File.separator + "coverage" );
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
        configureProject( "report.xml" );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        executeTarget( "test-teardown" );
        
        super.tearDown();
    }
}

