/*
 * @(#)IParserCollatorUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1.itf.parser;

import  net.sourceforge.groboutils.pmti.v1.itf.*;
import  net.sourceforge.groboutils.pmti.v1.itf.impl.*;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the IParserCollator interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     July 14, 2002
 * @version   $Date: 2003/02/10 22:52:09 $
 */
public class IParserCollatorUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IParserCollatorUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public IParserCollatorUTestI( String name, ImplFactory f )
    {
        super( name, IParserCollator.class, f );
    }

    
    public IParserCollator createIParserCollator()
    {
        return (IParserCollator)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testAddParser1()
    {
        IParserCollator pc = createIParserCollator();
        pc.addParser( null );
    }
    
    
    public static class MyParser implements IParser
    {
        public ITestIssueRecord[] records;
        public MyParser()
        {
            this.records = new ITestIssueRecord[0];
        }
        public MyParser( ITestIssueRecord[] r )
        {
            this.records = r;
        }
        
        public ITestIssueRecord[] parse()
        {
            return this.records;
        }
    }

    
    public void testAddParser2()
    {
        IParserCollator pc = createIParserCollator();
        pc.addParser( new MyParser() );
        pc.addParser( new MyParser() );
    }

    
    public void testAddParser3()
    {
        IParserCollator pc = createIParserCollator();
        pc.addParser( new MyParser() );
        pc.getRecords();
        try
        {
            pc.addParser( new MyParser() );
            fail( "Did not throw IllegalStateException." );
        }
        catch (IllegalStateException ise)
        {
            // check exception??
        }
    }
    
    
    public void testGetRecords1()
    {
        IParserCollator pc = createIParserCollator();
        ITestIssueRecordSet set = pc.getRecords();
        assertNotNull(
            "Returned null set.",
            set );
        ITestIssueRecord[] records = set.getTestIssueRecords();
        assertNotNull(
            "Returned null record array.",
            records );
        assertEquals(
            "Returned a non-empty record set.",
            0,
            records.length );
    }
    
    
    public void testGetRecords2()
    {
        IParserCollator pc = createIParserCollator();
        pc.addParser( new MyParser() );
        pc.addParser( new MyParser() );
        ITestIssueRecordSet set = pc.getRecords();
        assertNotNull(
            "Returned null set.",
            set );
        ITestIssueRecord[] records = set.getTestIssueRecords();
        assertNotNull(
            "Returned null record array.",
            records );
        assertEquals(
            "Returned a non-empty record set.",
            0,
            records.length );
    }
    
    
    public void testGetRecords3()
    {
        IParserCollator pc = createIParserCollator();
        ITestIssueRecord[] real = {
                createRecord1(),
            };
        pc.addParser( new MyParser( real ) );
        ITestIssueRecordSet set = pc.getRecords();
        assertNotNull(
            "Returned null set.",
            set );
        assertContainsOnly( set, real );
    }
    
    
    public void testGetRecords4()
    {
        IParserCollator pc = createIParserCollator();
        ITestIssueRecord[] real = {
                createRecord1(),
                createRecord2(),
                createRecord2(),
                createRecord2(),
                createRecord3(),
            };
        pc.addParser( new MyParser( real ) );
        pc.addParser( new MyParser() );
        ITestIssueRecordSet set = pc.getRecords();
        assertNotNull(
            "Returned null set.",
            set );
        assertContainsOnly( set, real );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    /**
     * NOTE: changes <tt>records</tt>
     */
    protected void assertContainsOnly( ITestIssueRecordSet set,
            ITestIssueRecord[] records )
    {
        int foundCount = 0;
        ITestIssueRecord[] actualRecords = set.getTestIssueRecords();
        assertNotNull(
            "test issue record set contains null record array.",
            actualRecords );
        for (int arIndex = 0; arIndex < actualRecords.length; ++arIndex)
        {
            assertNotNull(
                "Returned a null test issue record in set.",
                actualRecords[ arIndex ] );
            boolean foundRecord = false;
            for (int rIndex = 0; rIndex < records.length; ++rIndex)
            {
                if (records[ rIndex ] != null
                    && actualRecords[ arIndex ] == records[ rIndex ])
                {
                    foundRecord = true;
                    ++foundCount;
                    records[ rIndex ] = null;
                    break;
                }
            }
            assertTrue(
                "Found record "+actualRecords[ arIndex ]+
                " in result set that was not passed into the collate method.",
                foundRecord );
        }
        
        assertEquals(
            "Did not find all the input records to the collate method in its "+
            "results.",
            records.length,
            foundCount );
            
    }
    
    
    protected ITestIssueRecord createRecord1()
    {
        IIssueRecord ir = new DefaultIssueRecord( "", null );
        DefaultTestRecord tr = new DefaultTestRecord();
        ITestIssueRecord tir = new DefaultTestIssueRecord( ir, tr, "text 1" );
        return tir;
    }
    
    
    protected ITestIssueRecord createRecord2()
    {
        IIssueRecord ir = new DefaultIssueRecord( "", null );
        DefaultTestRecord tr = new DefaultTestRecord();
        tr.setTestSuite( "suite" );
        
        ITestIssueRecord tir = new DefaultTestIssueRecord( ir, tr, "text 2" );
        return tir;
    }
    
    
    protected ITestIssueRecord createRecord3()
    {
        IIssueRecord ir = new DefaultIssueRecord( "", null );
        DefaultTestRecord tr = new DefaultTestRecord();
        tr.setTestSuite( "suite" );
        tr.setTestName( "name" );
        
        ITestIssueRecord tir = new DefaultTestIssueRecord( ir, tr, "text 3" );
        return tir;
    }
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

