/*
 * @(#)AutoDocJUnitListenerUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.junit;

import java.util.Enumeration;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.TestListener;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.junit.v1.iftc.ImplFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestCase;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;
import junit.framework.AssertionFailedError;


/**
 * Tests the AutoDocJUnitListener class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 5, 2002
 * @version   $Date: 2003/02/10 22:52:16 $
 */
public class AutoDocJUnitListenerUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AutoDocJUnitListenerUTestI.class;
    private static final AutoDoc AD = new AutoDoc(THIS_CLASS);
    
    public AutoDocJUnitListenerUTestI( String name, ImplFactory f )
    {
        super( name, AutoDocJUnitListener.class, f );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    private MockControl testControl;
    private Test mockTest;
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
        this.testControl = EasyMock.controlFor( Test.class );
        this.mockTest = (Test)this.testControl.getMock();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testAddFailure1()
    {
        AD.getIT().testsIssue( "testAddFailure1", 526454 );
        
        createListener().addFailure( null, null );
    }
    
    
    public void testAddFailure2()
    {
        AD.getIT().testsIssue( 526454 );
        
        createListener().addFailure( null,
            new AssertionFailedError( "ignore error") );
    }
    
    
    public void testAddFailure3()
    {
        this.testControl.activate();
        
        // failures can occur without a startTest being called!
        createListener().addFailure( this.mockTest,
            new AssertionFailedError( "ignore error") );
        
        this.testControl.verify();
    }
    
    
    public void testAddFailure4()
    {
        this.testControl.activate();
        
        AutoDocJUnitListener adjul = createListener();
        adjul.startTest( this.mockTest );
        adjul.addFailure( this.mockTest,
            new AssertionFailedError( "ignore error") );
        adjul.endTest( this.mockTest );
        
        this.testControl.verify();
    }
    
    
    public void testAddError1()
    {
        AD.getIT().testsIssue( "testAddError1", 526454 );
        
        createListener().addError( null, null );
    }
    
    
    public void testAddError2()
    {
        AD.getIT().testsIssue( "testAddError2", 526454 );
        
        createListener().addError( null, new Throwable(
            "ignore error") );
    }
    
    
    public void testAddError3()
    {
        this.testControl.activate();
        
        // errors can occur without a startTest being called!
        createListener().addError( this.mockTest,
            new Throwable( "ignore error") );
        
        this.testControl.verify();
    }
    
    
    public void testAddError4()
    {
        this.testControl.activate();
        
        AutoDocJUnitListener adjul = createListener();
        adjul.startTest( this.mockTest );
        adjul.addError( this.mockTest,
            new Throwable( "ignore error") );
        adjul.endTest( this.mockTest );
        
        this.testControl.verify();
    }
    
    
    public void testAddListener1()
    {
        AutoDocJUnitListener adjul = createListener();
        Enumeration enum = adjul.getListeners();
        int listenerCount = 0;
        while (enum.hasMoreElements())
        {
            ++listenerCount;
            enum.nextElement();
        }
        adjul.addListener( null );
        enum = adjul.getListeners();
        int count = 0;
        while (enum.hasMoreElements())
        {
            ++count;
            enum.nextElement();
        }
        assertEquals(
            "Adding a null listener changed the number of registered "+
            "listeners.",
            count,
            listenerCount );
    }
    
    
    public void testAddListener2()
    {
        TestListener tl = new TestListener() {
            public void addError(Test test, Throwable t)
            {}
            public void addFailure(Test test, AssertionFailedError t)
            {}
            public void endTest(Test test)
            {}
            public void startTest(Test test)
            {}
        };
        AutoDocJUnitListener adjul = createListener();
        Enumeration enum = adjul.getListeners();
        int listenerCount = 0;
        while (enum.hasMoreElements())
        {
            ++listenerCount;
            enum.nextElement();
        }
        adjul.addListener( tl );
        enum = adjul.getListeners();
        int count = 0;
        while (enum.hasMoreElements())
        {
            ++count;
            enum.nextElement();
        }
        assertEquals(
            "Adding a real listener did not increase the number of registered "+
            "listeners.",
            listenerCount + 1,
            count );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    protected AutoDocJUnitListener createListener()
    {
        return (AutoDocJUnitListener)createImplObject();
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

