/*
 * @(#)DefaultMonitorUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.testserver;

import net.sourceforge.groboutils.autodoc.v1.*;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the DefaultMonitor class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 27, 2002
 * @version   $Date: 2003/06/10 01:08:41 $
 */
public class DefaultMonitorUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = DefaultMonitorUTest.class;
    
    public DefaultMonitorUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        try
        {
            new DefaultMonitor( null, null );
            fail("Did not throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ise)
        {
            // test error?
        }
    }
    
    
    public void testConstructor2()
    {
        Server s = new MyServer();
        try
        {
            new DefaultMonitor( s, null );
            fail("Did not throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ise)
        {
            // test error?
        }
    }
    
    
    public void testConstructor3()
    {
        TestDataFactory tdf = new MyTDFactory();
        try
        {
            new DefaultMonitor( null, tdf );
            fail("Did not throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ise)
        {
            // test error?
        }
    }
    
    
    public void testRemoveInfoOnSend1()
    {
        DefaultMonitor dm = new DefaultMonitor(
            new MyServer(), new MyTDFactory() );
        TestInfo ti = new DefaultTestInfo( "A", "b" );
        dm.addTestData( ti );
        dm.sendTestData( ti );
        try
        {
            dm.getTestData( ti );
            fail( "Did not throw an IllegalStateException." );
        }
        catch (IllegalStateException ise)
        {
            // test exception
        }
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected static class MyServer implements Server
    {
        public void addTestData( TestData td )
        {
            // do nothing
        }
    }
    
    
    protected static class MyTestData implements TestData
    {
        TestInfo info;
        public MyTestData( TestInfo ti )
        {
            this.info = ti;
        }
        public TestInfo getTestInfo()
        {
            return this.info;
        }
    }
    
    
    protected static class MyTDFactory implements TestDataFactory
    {
        public TestData createTestData( TestInfo info )
        {
            return new MyTestData( info );
        }
    }

    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = MonitorUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                Server s = new MyServer();
                TestDataFactory tdf = new MyTDFactory();
                return new DefaultMonitor( s, tdf );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

