/*
 *  @(#)Assembler.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.assembler;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;


/**
 * Contains the set of states in their pre-assembled state.  Used for
 * accessing a collection of states.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 13, 2002
 */
public class AsmblStateSet
{
    private Hashtable states = new Hashtable();
    
    /**
     * 
     */
    public AsmblStateSet()
    {
        // do nothing
    }
    
    
    /**
     * 
     */
    public void addState( AsmblState state )
    {
        if (state != null)
        {
            this.states.put( state.getName(), state );
        }
    }
    
    
    /**
     * 
     */
    public void addStates( AsmblState[] states )
    {
        if (states != null)
        {
            for (int i = states.length; --i >= 0;)
            {
                addState( states[i] );
            }
        }
    }
    
    
    /**
     * 
     */
    public AsmblState getState( String name )
    {
        return (AsmblState)this.states.get( name );
    }
    
    
    /**
     * 
     */
    public AsmblState[] getStates()
    {
        AsmblState as[] = new AsmblState[ this.states.size() ];
        Enumeration enum = this.states.elements();
        for (int i = 0; enum.hasMoreElements(); ++i)
        {
            as[i] = (AsmblState)enum.nextElement();
        }
        return as;
    }
}

