/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import com.xerox.VTM.glyphs.Translucent;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;
import net.claribole.zvtm.engine.LowPassFilter;
import net.claribole.zvtm.glyphs.Translucency;
import net.claribole.zvtm.lens.DLTrailingTimer;
import net.claribole.zvtm.lens.FSLinearLens;
import net.claribole.zvtm.lens.TemporalLens;

public class DLinearLens
extends FSLinearLens
implements TemporalLens {
    double frequency = -1.0;
    long mLastSampleTime = -1L;
    int xOffset = -10;
    int yOffset = 10;
    double maxDist = 2 * Math.abs(this.xOffset);
    LowPassFilter filter = new LowPassFilter();
    Point2D currentPos = new Point2D.Double(0.0, 0.0);
    Point2D parentPos = new Point2D.Double(0.0, 0.0);
    Point2D targetPos = new Point2D.Double(0.0, 0.0);
    Timer timer;
    DLTrailingTimer mouseStillUpdater;
    double cutoffParamA = 0.2;
    double cutoffParamB = 0.001;
    float dMM = this.MM;
    float mindMM = 1.0f;

    public DLinearLens() {
        this.initTimer();
    }

    public DLinearLens(float mm) {
        super(mm);
        this.dMM = this.MM;
        this.initTimer();
    }

    public DLinearLens(float mm, int outerRadius, int innerRadius) {
        super(mm, outerRadius, innerRadius);
        this.dMM = this.MM;
        this.initTimer();
    }

    public DLinearLens(float mm, int outerRadius, int innerRadius, int x, int y) {
        super(mm, outerRadius, innerRadius, x, y);
        this.dMM = this.MM;
        this.initTimer();
    }

    void initTimer() {
        this.timer = new Timer();
        this.mouseStillUpdater = new DLTrailingTimer(this);
        this.timer.scheduleAtFixedRate((TimerTask)this.mouseStillUpdater, 40L, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAbsolutePosition(int ax, int ay, long absTime) {
        DLinearLens dLinearLens = this;
        synchronized (dLinearLens) {
            super.setAbsolutePosition(ax, ay);
            this.updateFrequency(absTime);
            this.updateTimeBasedParams(ax, ay);
        }
    }

    public void updateFrequency() {
        this.updateFrequency(System.currentTimeMillis());
    }

    public void updateFrequency(long currentTime) {
        if (this.frequency == -1.0) {
            this.frequency = 1.0;
        } else if (currentTime != this.mLastSampleTime) {
            this.frequency = 1000.0 / (double)(currentTime - this.mLastSampleTime);
        }
        this.mLastSampleTime = currentTime;
    }

    public void updateTimeBasedParams(int cx, int cy) {
        this.parentPos.setLocation(cx, cy);
        this.updateTimeBasedParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeBasedParams() {
        DLinearLens dLinearLens = this;
        synchronized (dLinearLens) {
            this.targetPos.setLocation(this.parentPos.getX() + (double)this.xOffset, this.parentPos.getY() + (double)this.yOffset);
            double distAway = this.targetPos.distance(this.currentPos);
            double opacity = 1.0 - Math.min(1.0, distAway / this.maxDist);
            this.filter.setCutOffFrequency((1.0 - opacity) * this.cutoffParamA + this.cutoffParamB);
            this.currentPos = this.filter.apply(this.targetPos, this.frequency);
            int tx = (int)Math.round(this.currentPos.getX());
            int ty = (int)Math.round(this.currentPos.getY());
            tx = Math.max(tx, this.w / 2);
            ty = Math.min(ty, this.owningView.parent.getPanelSize().height - this.h / 2);
            float nMM = (float)opacity * (this.MM - this.mindMM) + this.mindMM;
            if (Math.abs(this.dMM - nMM) > 0.1f) {
                this.dMM = nMM;
                this.setDynamicMagnification();
                this.owningView.parent.repaintNow();
            }
        }
    }

    void setDynamicMagnification() {
        this.a = (1.0f - this.dMM) / (float)(this.LR1 - this.LR2);
        this.b = (this.dMM * (float)this.LR1 - (float)this.LR2) / (float)(this.LR1 - this.LR2);
        this.owningView.parent.repaintNow();
    }

    public void setCutoffFrequencyParameters(double a, double b) {
        this.cutoffParamA = a;
        this.cutoffParamB = b;
    }

    public void setNoUpdateWhenMouseStill(boolean b) {
        this.mouseStillUpdater.setEnabled(!b);
    }

    public void dispose() {
        super.dispose();
        this.timer.cancel();
    }

    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt(Math.pow(x - (float)this.sw - (float)this.lx, 2.0) + Math.pow(y - (float)this.sh - (float)this.ly, 2.0));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.dMM;
        } else if (this.d <= (double)this.LR1) {
            g[0] = g[1] = this.a * (float)this.d + this.b;
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }

    public void drawBoundary(Graphics2D g2d) {
        g2d.setComposite(Translucency.acs[Math.round((this.dMM / (1.0f - this.MM) + this.MM / (this.MM - 1.0f)) * 20.0f) - 1]);
        if (this.r1Color != null) {
            g2d.setColor(this.r1Color);
            g2d.drawOval(this.lx + this.w / 2 - this.LR1, this.ly + this.h / 2 - this.LR1, 2 * this.LR1, 2 * this.LR1);
        }
        if (this.r2Color != null) {
            int r2 = Math.round(this.dMM / this.MM * (float)this.LR2);
            g2d.setColor(this.r2Color);
            g2d.drawOval(this.lx + this.w / 2 - r2, this.ly + this.h / 2 - r2, 2 * r2, 2 * r2);
        }
        g2d.setComposite(Translucent.acO);
    }

    public float getActualMaximumMagnification() {
        return this.dMM;
    }
}

